/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.util.UUID;
import org.openmetadata.schema.type.SuggestionStatus;
import org.openmetadata.schema.type.SuggestionType;
import org.openmetadata.service.jdbi3.SuggestionRepository;
import org.openmetadata.service.util.FullyQualifiedName;
import org.openmetadata.service.util.RestUtil;

public class SuggestionFilter {
    private SuggestionType suggestionType;
    private SuggestionStatus suggestionStatus;
    private UUID createdBy;
    private String entityFQN;
    private SuggestionRepository.PaginationType paginationType;
    private String before;
    private String after;

    public String getCondition(boolean includePagination) {
        StringBuilder condition = new StringBuilder();
        condition.append("WHERE TRUE ");
        if (this.suggestionType != null) {
            condition.append(String.format(" AND suggestionType = '%s' ", this.suggestionType.value()));
        }
        if (this.suggestionStatus != null) {
            condition.append(String.format(" AND status = '%s' ", this.suggestionStatus.value()));
        }
        if (this.entityFQN != null) {
            condition.append(String.format(" AND fqnHash = '%s' ", FullyQualifiedName.buildHash(this.entityFQN)));
        }
        if (this.createdBy != null) {
            condition.append(String.format(" AND id in (select toId from entity_relationship where fromId = '%s') ", this.createdBy));
        }
        if (this.paginationType != null && includePagination) {
            String paginationCondition = this.paginationType == SuggestionRepository.PaginationType.BEFORE ? String.format(" AND updatedAt > %s ", Long.parseLong(RestUtil.decodeCursor(this.before))) : String.format(" AND updatedAt < %s ", this.after != null ? Long.parseLong(RestUtil.decodeCursor(this.after)) : Long.MAX_VALUE);
            condition.append(paginationCondition);
        }
        return condition.toString();
    }

    SuggestionFilter(SuggestionType suggestionType, SuggestionStatus suggestionStatus, UUID createdBy, String entityFQN, SuggestionRepository.PaginationType paginationType, String before, String after) {
        this.suggestionType = suggestionType;
        this.suggestionStatus = suggestionStatus;
        this.createdBy = createdBy;
        this.entityFQN = entityFQN;
        this.paginationType = paginationType;
        this.before = before;
        this.after = after;
    }

    public static SuggestionFilterBuilder builder() {
        return new SuggestionFilterBuilder();
    }

    public SuggestionType getSuggestionType() {
        return this.suggestionType;
    }

    public SuggestionStatus getSuggestionStatus() {
        return this.suggestionStatus;
    }

    public UUID getCreatedBy() {
        return this.createdBy;
    }

    public String getEntityFQN() {
        return this.entityFQN;
    }

    public SuggestionRepository.PaginationType getPaginationType() {
        return this.paginationType;
    }

    public String getBefore() {
        return this.before;
    }

    public String getAfter() {
        return this.after;
    }

    public static class SuggestionFilterBuilder {
        private SuggestionType suggestionType;
        private SuggestionStatus suggestionStatus;
        private UUID createdBy;
        private String entityFQN;
        private SuggestionRepository.PaginationType paginationType;
        private String before;
        private String after;

        SuggestionFilterBuilder() {
        }

        public SuggestionFilterBuilder suggestionType(SuggestionType suggestionType) {
            this.suggestionType = suggestionType;
            return this;
        }

        public SuggestionFilterBuilder suggestionStatus(SuggestionStatus suggestionStatus) {
            this.suggestionStatus = suggestionStatus;
            return this;
        }

        public SuggestionFilterBuilder createdBy(UUID createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public SuggestionFilterBuilder entityFQN(String entityFQN) {
            this.entityFQN = entityFQN;
            return this;
        }

        public SuggestionFilterBuilder paginationType(SuggestionRepository.PaginationType paginationType) {
            this.paginationType = paginationType;
            return this;
        }

        public SuggestionFilterBuilder before(String before) {
            this.before = before;
            return this;
        }

        public SuggestionFilterBuilder after(String after) {
            this.after = after;
            return this;
        }

        public SuggestionFilter build() {
            return new SuggestionFilter(this.suggestionType, this.suggestionStatus, this.createdBy, this.entityFQN, this.paginationType, this.before, this.after);
        }

        public String toString() {
            return "SuggestionFilter.SuggestionFilterBuilder(suggestionType=" + this.suggestionType + ", suggestionStatus=" + this.suggestionStatus + ", createdBy=" + this.createdBy + ", entityFQN=" + this.entityFQN + ", paginationType=" + this.paginationType + ", before=" + this.before + ", after=" + this.after + ")";
        }
    }
}

