/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.migration;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.jdbi3.MigrationDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationValidationClient {
    private static final Logger LOG = LoggerFactory.getLogger(MigrationValidationClient.class);
    public static MigrationValidationClient instance;
    private final MigrationDAO migrationDAO;
    private final OpenMetadataApplicationConfig config;
    private final List<String> expectedMigrationList;

    private MigrationValidationClient(MigrationDAO migrationDAO, OpenMetadataApplicationConfig config) {
        this.migrationDAO = migrationDAO;
        this.config = config;
        this.expectedMigrationList = this.loadExpectedMigrationList();
    }

    public static MigrationValidationClient initialize(MigrationDAO migrationDAO, OpenMetadataApplicationConfig config) {
        if (instance == null) {
            instance = new MigrationValidationClient(migrationDAO, config);
        }
        return instance;
    }

    public List<String> getCurrentVersions() {
        return this.migrationDAO.getMigrationVersions();
    }

    private List<String> loadExpectedMigrationList() {
        try {
            String nativePath = this.config.getMigrationConfiguration().getNativePath();
            String extensionPath = this.config.getMigrationConfiguration().getExtensionPath();
            List<String> availableOMNativeMigrations = this.getMigrationFilesFromPath(nativePath);
            if (extensionPath == null || extensionPath.isEmpty()) {
                return availableOMNativeMigrations;
            }
            List<String> availableOMExtensionMigrations = this.getMigrationFilesFromPath(extensionPath);
            return Stream.concat(availableOMNativeMigrations.stream(), availableOMExtensionMigrations.stream()).sorted().toList();
        }
        catch (Exception e) {
            LOG.error("Error loading expected migration list", (Throwable)e);
            return List.of();
        }
    }

    private List<String> getMigrationFilesFromPath(String path) {
        return Arrays.stream(Objects.requireNonNull(new File(path).listFiles(File::isDirectory))).map(File::getName).sorted().toList();
    }

    public static MigrationValidationClient getInstance() {
        return instance;
    }

    public List<String> getExpectedMigrationList() {
        return this.expectedMigrationList;
    }
}

