/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.dqtests;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.beans.IntrospectionException;
import java.lang.reflect.InvocationTargetException;
import java.util.UUID;
import javax.json.JsonPatch;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import lombok.NonNull;
import org.openmetadata.schema.api.tests.CreateTestCaseResolutionStatus;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.tests.TestCase;
import org.openmetadata.schema.tests.type.TestCaseResolutionStatus;
import org.openmetadata.schema.tests.type.TestCaseResolutionStatusTypes;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.MetadataOperation;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.jdbi3.TestCaseResolutionStatusRepository;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.resources.EntityTimeSeriesResource;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.security.policyevaluator.OperationContext;
import org.openmetadata.service.security.policyevaluator.ReportDataContext;
import org.openmetadata.service.util.RestUtil;
import org.openmetadata.service.util.ResultList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/dataQuality/testCases/testCaseIncidentStatus")
@Tag(name="Test Case Incident Manager", description="APIs to test case incident status from incident manager.")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="TestCases")
public class TestCaseResolutionStatusResource
extends EntityTimeSeriesResource<TestCaseResolutionStatus, TestCaseResolutionStatusRepository> {
    private static final Logger LOG = LoggerFactory.getLogger(TestCaseResolutionStatusResource.class);
    public static final String COLLECTION_PATH = "/v1/dataQuality/testCases/testCaseIncidentStatus";

    public TestCaseResolutionStatusResource(Authorizer authorizer) {
        super("testCaseResolutionStatus", authorizer);
    }

    @GET
    @Operation(operationId="getTestCaseResolutionStatus", summary="List the test case failure statuses", description="Get a list of all the test case failure statuses, optionally filtered by `startTs` and `endTs` of the status creation, status, assignee, and test case id. Use cursor-based pagination to limit the number of entries in the list using `limit` and `before` or `after` query params.", responses={@ApiResponse(responseCode="200", description="List of test case statuses", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestCaseResolutionStatusResultList.class))})})
    public ResultList<TestCaseResolutionStatus> list(@Context SecurityContext securityContext, @Parameter(description="Test Case ID", schema=@Schema(type="UUID")) @QueryParam(value="testCaseId") UUID testCaseId, @Parameter(description="Limit the number tests returned. (1 to 1000000, default = 10)") @DefaultValue(value="10") @QueryParam(value="limit") @Min(value=0L) @Max(value=1000000L) @Min(value=0L) @Max(value=1000000L) int limitParam, @Parameter(description="Returns list of tests at the offset", schema=@Schema(type="string")) @QueryParam(value="offset") String offset, @Parameter(description="Filter test case statuses after the given start timestamp", schema=@Schema(type="number")) @QueryParam(value="startTs") @NonNull Long startTs, @Parameter(description="Filter test case statuses before the given end timestamp", schema=@Schema(type="number")) @QueryParam(value="endTs") @NonNull Long endTs, @Parameter(description="Filter test case statuses by status", schema=@Schema(implementation=TestCaseResolutionStatusTypes.class)) @QueryParam(value="testCaseResolutionStatusType") String testCaseResolutionStatusType, @Parameter(description="Only list the latest statuses", schema=@Schema(type="Boolean")) @DefaultValue(value="false") @QueryParam(value="latest") Boolean latest, @Parameter(description="Filter test case statuses by assignee", schema=@Schema(type="String")) @QueryParam(value="assignee") String assignee, @Parameter(description="Test case fully qualified name", schema=@Schema(type="String")) @QueryParam(value="testCaseFQN") String testCaseFQN) {
        if (startTs == null) {
            throw new NullPointerException("startTs is marked non-null but is null");
        }
        if (endTs == null) {
            throw new NullPointerException("endTs is marked non-null but is null");
        }
        OperationContext operationContext = new OperationContext("testCase", MetadataOperation.VIEW_ALL);
        ReportDataContext resourceContext = ReportDataContext.builder().build();
        this.authorizer.authorize(securityContext, operationContext, resourceContext);
        ListFilter filter = new ListFilter(null);
        filter.addQueryParam("testCaseResolutionStatusType", testCaseResolutionStatusType);
        filter.addQueryParam("assignee", assignee);
        filter.addQueryParam("entityFQNHash", testCaseFQN);
        return ((TestCaseResolutionStatusRepository)this.repository).list(offset, startTs, endTs, limitParam, filter, latest);
    }

    @GET
    @Path(value="/stateId/{stateId}")
    @Operation(operationId="getTestCaseResolutionStatusesForAStateId", summary="Get test case failure statuses for a sequence id", description="Get a test case failure statuses for a sequence id", responses={@ApiResponse(responseCode="200", description="The test case failure status", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestCaseResolutionStatus.class))})})
    public ResultList<TestCaseResolutionStatus> listForStateId(@Context SecurityContext securityContext, @Parameter(description="Sequence ID", schema=@Schema(type="UUID")) @PathParam(value="stateId") UUID stateId) {
        OperationContext operationContext = new OperationContext("testCase", MetadataOperation.VIEW_ALL);
        ReportDataContext resourceContext = ReportDataContext.builder().build();
        this.authorizer.authorize(securityContext, operationContext, resourceContext);
        return ((TestCaseResolutionStatusRepository)this.repository).listTestCaseResolutionStatusesForStateId(stateId);
    }

    @GET
    @Path(value="/{id}")
    @Operation(operationId="getTestCaseResolutionStatusById", summary="Get test case failure status by id", description="Get a test case failure status by id", responses={@ApiResponse(responseCode="200", description="The test case failure status", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestCaseResolutionStatus.class))})})
    public TestCaseResolutionStatus get(@Context SecurityContext securityContext, @Parameter(description="Test Case Failure Status ID", schema=@Schema(type="UUID")) @PathParam(value="id") UUID testCaseResolutionStatusId) {
        OperationContext operationContext = new OperationContext("testCase", MetadataOperation.VIEW_ALL);
        ReportDataContext resourceContext = ReportDataContext.builder().build();
        this.authorizer.authorize(securityContext, operationContext, resourceContext);
        return (TestCaseResolutionStatus)((TestCaseResolutionStatusRepository)this.repository).getById(testCaseResolutionStatusId);
    }

    @POST
    @Operation(operationId="createTestCaseResolutionStatus", summary="Create a new test case failure status", description="Create a new test case failure status", responses={@ApiResponse(responseCode="200", description="The created test case failure status", content={@Content(mediaType="application/json", schema=@Schema(implementation=CreateTestCaseResolutionStatus.class))})})
    public Response create(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateTestCaseResolutionStatus createTestCaseResolutionStatus) {
        OperationContext operationContext = new OperationContext("testCase", MetadataOperation.EDIT_TESTS);
        ReportDataContext resourceContext = ReportDataContext.builder().build();
        this.authorizer.authorize(securityContext, operationContext, resourceContext);
        TestCase testCaseEntity = (TestCase)Entity.getEntityByName("testCase", createTestCaseResolutionStatus.getTestCaseReference(), null, Include.ALL);
        TestCaseResolutionStatus testCaseResolutionStatus = this.getTestCaseResolutionStatus(testCaseEntity, createTestCaseResolutionStatus, securityContext.getUserPrincipal().getName());
        return this.create(testCaseResolutionStatus, testCaseEntity.getFullyQualifiedName());
    }

    @PATCH
    @Path(value="/{id}")
    @Operation(operationId="updateTestCaseResolutionStatus", summary="Update an existing test case failure status", description="Update an existing test case failure status", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"))
    @Consumes(value={"application/json-patch+json"})
    public Response patch(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the test case result status", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @RequestBody(description="JsonPatch with array of operations. Only `updateAt` and `updatedBy` fields can be patched.", content={@Content(mediaType="application/json-patch+json", examples={@ExampleObject(value="[{op:remove, path:/a},{op:add, path: /b, value: val}]")})}) JsonPatch patch) throws IntrospectionException, InvocationTargetException, IllegalAccessException {
        OperationContext operationContext = new OperationContext("testCase", MetadataOperation.EDIT_TESTS);
        ReportDataContext resourceContext = ReportDataContext.builder().build();
        this.authorizer.authorize(securityContext, operationContext, resourceContext);
        RestUtil.PatchResponse<TestCaseResolutionStatus> response = ((TestCaseResolutionStatusRepository)this.repository).patch(id, patch, securityContext.getUserPrincipal().getName());
        return response.toResponse();
    }

    private TestCaseResolutionStatus getTestCaseResolutionStatus(TestCase testCaseEntity, CreateTestCaseResolutionStatus createTestCaseResolutionStatus, String userName) {
        User userEntity = (User)Entity.getEntityByName("user", userName, null, Include.ALL);
        return new TestCaseResolutionStatus().withTimestamp(Long.valueOf(System.currentTimeMillis())).withTestCaseResolutionStatusType(createTestCaseResolutionStatus.getTestCaseResolutionStatusType()).withTestCaseResolutionStatusDetails(createTestCaseResolutionStatus.getTestCaseResolutionStatusDetails()).withUpdatedBy(userEntity.getEntityReference()).withUpdatedAt(Long.valueOf(System.currentTimeMillis())).withTestCaseReference(testCaseEntity.getEntityReference());
    }

    public static class TestCaseResolutionStatusResultList
    extends ResultList<TestCaseResolutionStatus> {
    }
}

