/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.policies;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import javax.json.JsonPatch;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.api.data.RestoreEntity;
import org.openmetadata.schema.api.policies.CreatePolicy;
import org.openmetadata.schema.entity.policies.Policy;
import org.openmetadata.schema.entity.policies.accessControl.Rule;
import org.openmetadata.schema.type.EntityHistory;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Function;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.MetadataOperation;
import org.openmetadata.schema.type.ResourceDescriptor;
import org.openmetadata.service.Entity;
import org.openmetadata.service.FunctionList;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.ResourceRegistry;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.jdbi3.PolicyRepository;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.resources.CollectionRegistry;
import org.openmetadata.service.resources.EntityResource;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.security.policyevaluator.CompiledRule;
import org.openmetadata.service.security.policyevaluator.RuleEvaluator;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.ResultList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/policies")
@Tag(name="Policies", description="A `Policy` defines control that needs to be applied across different Data Entities.")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="policies", order=0)
public class PolicyResource
extends EntityResource<Policy, PolicyRepository> {
    private static final Logger LOG = LoggerFactory.getLogger(PolicyResource.class);
    public static final String COLLECTION_PATH = "v1/policies/";
    public static final String FIELDS = "owner,location,teams,roles";

    @Override
    public Policy addHref(UriInfo uriInfo, Policy policy) {
        super.addHref(uriInfo, policy);
        Entity.withHref(uriInfo, policy.getTeams());
        Entity.withHref(uriInfo, policy.getRoles());
        return policy;
    }

    public PolicyResource(Authorizer authorizer) {
        super("policy", authorizer);
    }

    @Override
    protected List<MetadataOperation> getEntitySpecificOperations() {
        this.addViewOperation("location,teams,roles", MetadataOperation.VIEW_BASIC);
        return null;
    }

    @Override
    public void initialize(OpenMetadataApplicationConfig config) throws IOException {
        ((PolicyRepository)this.repository).initSeedDataFromResources();
    }

    @Override
    public void upgrade() {
        try {
            Policy organizationPolicy = (Policy)((PolicyRepository)this.repository).findByName("OrganizationPolicy", Include.NON_DELETED);
            String originalJson = JsonUtils.pojoToJson(organizationPolicy);
            for (Rule rule : organizationPolicy.getRules()) {
                if (!rule.getName().equals("OrganizationPolicy-Owner-Rule") || rule.getOperations().contains(MetadataOperation.ALL)) continue;
                rule.getOperations().clear();
                rule.getOperations().add(MetadataOperation.ALL);
            }
            String updatedJson = JsonUtils.pojoToJson(organizationPolicy);
            JsonPatch patch = JsonUtils.getJsonPatch(originalJson, updatedJson);
            ((PolicyRepository)this.repository).patch(null, organizationPolicy.getId(), "admin", patch);
        }
        catch (Exception e) {
            LOG.error("Failed to update OrganizationPolicy", (Throwable)e);
        }
    }

    @GET
    @Valid
    @Operation(operationId="listPolicies", summary="List policies", description="Get a list of policies. Use `fields` parameter to get only necessary fields. Use cursor-based pagination to limit the number entries in the list using `limit` and `before` or `after` query params.", responses={@ApiResponse(responseCode="200", description="List of policies", content={@Content(mediaType="application/json", schema=@Schema(implementation=PolicyList.class))})})
    public ResultList<Policy> list(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner,location,teams,roles")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Limit the number policies returned. (1 to 1000000, default = 10)") @DefaultValue(value="10") @Min(value=0L) @Max(value=1000000L) @QueryParam(value="limit") @Min(value=0L) @Max(value=1000000L) int limitParam, @Parameter(description="Returns list of policies before this cursor", schema=@Schema(type="string")) @QueryParam(value="before") String before, @Parameter(description="Returns list of policies after this cursor", schema=@Schema(type="string")) @QueryParam(value="after") String after, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        ListFilter filter = new ListFilter(include);
        return super.listInternal(uriInfo, securityContext, fieldsParam, filter, limitParam, before, after);
    }

    @GET
    @Path(value="/{id}")
    @Operation(operationId="getPolicyByID", summary="Get a policy by id", description="Get a policy by `Id`.", responses={@ApiResponse(responseCode="200", description="The policy", content={@Content(mediaType="application/json", schema=@Schema(implementation=Policy.class))}), @ApiResponse(responseCode="404", description="Policy for instance {id} is not found")})
    public Policy get(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the policy", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner,location,teams,roles")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        return (Policy)this.getInternal(uriInfo, securityContext, id, fieldsParam, include);
    }

    @GET
    @Path(value="/name/{fqn}")
    @Operation(operationId="getPolicyByFQN", summary="Get a policy by fully qualified name", description="Get a policy by fully qualified name.", responses={@ApiResponse(responseCode="200", description="The policy", content={@Content(mediaType="application/json", schema=@Schema(implementation=Policy.class))}), @ApiResponse(responseCode="404", description="Policy for instance {fqn} is not found")})
    public Policy getByName(@Context UriInfo uriInfo, @Parameter(description="Fully qualified name of the policy", schema=@Schema(type="string")) @PathParam(value="fqn") String fqn, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner,location,teams,roles")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        return (Policy)this.getByNameInternal(uriInfo, securityContext, fqn, fieldsParam, include);
    }

    @GET
    @Path(value="/{id}/versions")
    @Operation(operationId="listAllPolicyVersion", summary="List policy versions", description="Get a list of all the versions of a policy identified by `id`", responses={@ApiResponse(responseCode="200", description="List of policy versions", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntityHistory.class))})})
    public EntityHistory listVersions(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the policy", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) {
        return super.listVersionsInternal(securityContext, id);
    }

    @GET
    @Path(value="/{id}/versions/{version}")
    @Operation(operationId="getSpecificPolicyVersion", summary="Get a version of the policy by Id", description="Get a version of the policy by given `Id`", responses={@ApiResponse(responseCode="200", description="policy", content={@Content(mediaType="application/json", schema=@Schema(implementation=Policy.class))}), @ApiResponse(responseCode="404", description="Policy for instance {id} and version {version} is not found")})
    public Policy getVersion(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the policy", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="policy version number in the form `major`.`minor`", schema=@Schema(type="string", example="0.1 or 1.1")) @PathParam(value="version") String version) {
        return (Policy)super.getVersionInternal(securityContext, id, version);
    }

    @GET
    @Path(value="/resources")
    @Operation(operationId="listPolicyResources", summary="Get list of policy resources used in authoring a policy", description="Get list of policy resources used in authoring a policy.")
    public ResultList<ResourceDescriptor> listPolicyResources(@Context UriInfo uriInfo, @Context SecurityContext securityContext) {
        return new ResultList<ResourceDescriptor>(ResourceRegistry.listResourceDescriptors());
    }

    @GET
    @Path(value="/functions")
    @Operation(operationId="listPolicyFunctions", summary="Get list of policy functions used in authoring conditions in policy rules.", description="Get list of policy functions used in authoring conditions in policy rules.")
    public ResultList<Function> listPolicyFunctions(@Context UriInfo uriInfo, @Context SecurityContext securityContext) {
        return new FunctionList(CollectionRegistry.getInstance().getFunctions(RuleEvaluator.class));
    }

    @Override
    @POST
    @Operation(operationId="createPolicy", summary="Create a policy", description="Create a new policy.", responses={@ApiResponse(responseCode="200", description="The policy", content={@Content(mediaType="application/json", schema=@Schema(implementation=Policy.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response create(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreatePolicy create) {
        Policy policy = this.getPolicy(create, securityContext.getUserPrincipal().getName());
        return this.create(uriInfo, securityContext, policy);
    }

    @PATCH
    @Path(value="/{id}")
    @Operation(operationId="patchPolicy", summary="Update a policy", description="Update an existing policy using JsonPatch.", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"))
    @Consumes(value={"application/json-patch+json"})
    public Response patch(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the policy", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @RequestBody(description="JsonPatch with array of operations", content={@Content(mediaType="application/json-patch+json", examples={@ExampleObject(value="[{op:remove, path:/a},{op:add, path: /b, value: val}]")})}) JsonPatch patch) {
        return this.patchInternal(uriInfo, securityContext, id, patch);
    }

    @Override
    @PUT
    @Operation(operationId="createOrUpdatePolicy", summary="Create or update a policy", description="Create a new policy, if it does not exist or update an existing policy.", responses={@ApiResponse(responseCode="200", description="The policy", content={@Content(mediaType="application/json", schema=@Schema(implementation=Policy.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response createOrUpdate(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreatePolicy create) {
        Policy policy = this.getPolicy(create, securityContext.getUserPrincipal().getName());
        return this.createOrUpdate(uriInfo, securityContext, policy);
    }

    @DELETE
    @Path(value="/{id}")
    @Operation(operationId="deletePolicy", summary="Delete a policy by Id", description="Delete a policy by `Id`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="policy for instance {id} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Id of the policy", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) {
        return this.delete(uriInfo, securityContext, id, false, hardDelete);
    }

    @DELETE
    @Path(value="/name/{fqn}")
    @Operation(operationId="deletePolicyByFQN", summary="Delete a policy by fully qualified name", description="Delete a policy by `fullyQualifiedName`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="policy for instance {fqn} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Fully qualified name of the policy", schema=@Schema(type="string")) @PathParam(value="fqn") String fqn) {
        return this.deleteByName(uriInfo, securityContext, fqn, false, hardDelete);
    }

    @PUT
    @Path(value="/restore")
    @Operation(operationId="restore", summary="Restore a soft deleted policy", description="Restore a soft deleted policy.", responses={@ApiResponse(responseCode="200", description="Successfully restored the Policy ", content={@Content(mediaType="application/json", schema=@Schema(implementation=Policy.class))})})
    public Response restorePolicy(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid RestoreEntity restore) {
        return this.restoreEntity(uriInfo, securityContext, restore.getId());
    }

    @GET
    @Path(value="/validation/condition/{expression}")
    @Operation(operationId="validateCondition", summary="Validate a given condition", description="Validate a given condition expression used in authoring rules.", responses={@ApiResponse(responseCode="204", description="No value is returned"), @ApiResponse(responseCode="400", description="Invalid expression")})
    public void validateCondition(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Expression of validating rule", schema=@Schema(type="string")) @PathParam(value="expression") String expression) {
        this.authorizer.authorizeAdmin(securityContext);
        CompiledRule.validateExpression(expression, Boolean.class);
    }

    private Policy getPolicy(CreatePolicy create, String user) {
        Policy policy = ((PolicyRepository)this.repository).copy(new Policy(), (CreateEntity)create, user).withRules(create.getRules()).withEnabled(create.getEnabled());
        if (create.getLocation() != null) {
            policy = policy.withLocation(new EntityReference().withId(create.getLocation()));
        }
        return policy;
    }

    public static class ResourceDescriptorList
    extends ResultList<ResourceDescriptor> {
    }

    public static class PolicyList
    extends ResultList<Policy> {
    }
}

