/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.settings;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckForNull;
import lombok.NonNull;
import org.openmetadata.api.configuration.LogoConfiguration;
import org.openmetadata.schema.api.configuration.LoginConfiguration;
import org.openmetadata.schema.email.SmtpSettings;
import org.openmetadata.schema.settings.Settings;
import org.openmetadata.schema.settings.SettingsType;
import org.openmetadata.service.Entity;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.jdbi3.SystemRepository;
import org.openmetadata.service.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettingsCache {
    private static final Logger LOG = LoggerFactory.getLogger(SettingsCache.class);
    private static volatile boolean initialized = false;
    protected static final LoadingCache<String, Settings> CACHE = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(3L, TimeUnit.MINUTES).build((CacheLoader)new SettingsLoader());
    protected static SystemRepository systemRepository;

    private SettingsCache() {
    }

    public static void initialize(OpenMetadataApplicationConfig config) {
        if (!initialized) {
            systemRepository = Entity.getSystemRepository();
            initialized = true;
            SettingsCache.createDefaultConfiguration(config);
        }
    }

    private static void createDefaultConfiguration(OpenMetadataApplicationConfig applicationConfig) {
        Settings storedLoginConf;
        Settings storedCustomLogoConf;
        Settings setting;
        Settings storedSettings = systemRepository.getConfigWithKey(SettingsType.EMAIL_CONFIGURATION.toString());
        if (storedSettings == null) {
            SmtpSettings emailConfig = applicationConfig.getSmtpSettings();
            setting = new Settings().withConfigType(SettingsType.EMAIL_CONFIGURATION).withConfigValue((Object)emailConfig);
            systemRepository.createNewSetting(setting);
        }
        if ((storedCustomLogoConf = systemRepository.getConfigWithKey(SettingsType.CUSTOM_LOGO_CONFIGURATION.toString())) == null) {
            setting = new Settings().withConfigType(SettingsType.CUSTOM_LOGO_CONFIGURATION).withConfigValue((Object)new LogoConfiguration().withCustomLogoUrlPath("").withCustomMonogramUrlPath("").withCustomFaviconUrlPath(""));
            systemRepository.createNewSetting(setting);
        }
        if ((storedLoginConf = systemRepository.getConfigWithKey(SettingsType.LOGIN_CONFIGURATION.toString())) == null) {
            Settings setting2 = new Settings().withConfigType(SettingsType.LOGIN_CONFIGURATION).withConfigValue((Object)new LoginConfiguration().withMaxLoginFailAttempts(Integer.valueOf(3)).withAccessBlockTime(Integer.valueOf(600)).withJwtTokenExpiryTime(Integer.valueOf(3600)));
            systemRepository.createNewSetting(setting2);
        }
    }

    public static <T> T getSetting(SettingsType settingName, Class<T> clazz) {
        try {
            String json = JsonUtils.pojoToJson(((Settings)CACHE.get((Object)settingName.toString())).getConfigValue());
            return JsonUtils.readValue(json, clazz);
        }
        catch (Exception ex) {
            LOG.error("Failed to fetch Settings . Setting {}", (Object)settingName, (Object)ex);
            throw new EntityNotFoundException("Setting not found");
        }
    }

    public static void cleanUp() {
        CACHE.invalidateAll();
        initialized = false;
    }

    public static void invalidateSettings(String settingsName) {
        try {
            CACHE.invalidate((Object)settingsName);
        }
        catch (Exception ex) {
            LOG.error("Failed to invalidate cache for settings {}", (Object)settingsName, (Object)ex);
        }
    }

    static class SettingsLoader
    extends CacheLoader<String, Settings> {
        SettingsLoader() {
        }

        @NonNull
        public Settings load(@CheckForNull String settingsName) {
            Settings fetchedSettings;
            switch (SettingsType.fromValue((String)settingsName)) {
                case EMAIL_CONFIGURATION: {
                    fetchedSettings = systemRepository.getEmailConfigInternal();
                    LOG.info("Loaded Email Setting");
                    break;
                }
                case SLACK_APP_CONFIGURATION: {
                    fetchedSettings = systemRepository.getSlackApplicationConfigInternal();
                    LOG.info("Loaded Slack Application Configuration");
                    break;
                }
                default: {
                    fetchedSettings = systemRepository.getConfigWithKey(settingsName);
                    LOG.info("Loaded Setting {}", (Object)fetchedSettings.getConfigType());
                }
            }
            return fetchedSettings;
        }
    }
}

