/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.tags;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.UUID;
import javax.json.JsonPatch;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.api.classification.CreateClassification;
import org.openmetadata.schema.api.data.RestoreEntity;
import org.openmetadata.schema.entity.classification.Classification;
import org.openmetadata.schema.entity.data.Table;
import org.openmetadata.schema.type.EntityHistory;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.MetadataOperation;
import org.openmetadata.service.jdbi3.ClassificationRepository;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.resources.EntityResource;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.util.ResultList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/classifications")
@Tag(name="Classifications", description="These APIs are related to `Classification` and `Tags`. A `Classification` entity contains hierarchical terms called `Tags` used for categorizing and classifying data assets and other entities.")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="classifications", order=4)
public class ClassificationResource
extends EntityResource<Classification, ClassificationRepository> {
    private static final Logger LOG = LoggerFactory.getLogger(ClassificationResource.class);
    public static final String TAG_COLLECTION_PATH = "/v1/classifications/";
    static final String FIELDS = "usageCount,termCount";

    public ClassificationResource(Authorizer authorizer) {
        super("classification", authorizer);
    }

    @Override
    protected List<MetadataOperation> getEntitySpecificOperations() {
        this.addViewOperation(FIELDS, MetadataOperation.VIEW_BASIC);
        return null;
    }

    @GET
    @Operation(operationId="listClassifications", summary="List classifications", description="Get a list of classifications.", responses={@ApiResponse(responseCode="200", description="The user ", content={@Content(mediaType="application/json", schema=@Schema(implementation=ClassificationList.class))})})
    public ResultList<Classification> list(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="usageCount,termCount")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Filter Disabled Classifications") @QueryParam(value="disabled") String disabled, @Parameter(description="Limit the number classifications returned. (1 to 1000000, default = 10) ") @DefaultValue(value="10") @Min(value=0L) @Max(value=1000000L) @QueryParam(value="limit") @Min(value=0L) @Max(value=1000000L) int limitParam, @Parameter(description="Returns list of classifications before this cursor", schema=@Schema(type="string")) @QueryParam(value="before") String before, @Parameter(description="Returns list of classifications after this cursor", schema=@Schema(type="string")) @QueryParam(value="after") String after, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        ListFilter filter = new ListFilter(include);
        return super.listInternal(uriInfo, securityContext, fieldsParam, filter, limitParam, before, after);
    }

    @GET
    @Path(value="/{id}")
    @Operation(operationId="getClassificationByID", summary="Get a classification by id", description="Get a classification by `id`", responses={@ApiResponse(responseCode="200", description="classification", content={@Content(mediaType="application/json", schema=@Schema(implementation=Classification.class))}), @ApiResponse(responseCode="404", description="Classification for instance {id} is not found")})
    public Classification get(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the classification", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="usageCount,termCount")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        return (Classification)this.getInternal(uriInfo, securityContext, id, fieldsParam, include);
    }

    @GET
    @Path(value="name/{name}")
    @Operation(operationId="getClassificationByName", summary="Get a classification by name", description="Get a classification identified by name. The response includes classification information along with the entire hierarchy of all the children tags.", responses={@ApiResponse(responseCode="200", description="The user ", content={@Content(mediaType="application/json", schema=@Schema(implementation=Classification.class))}), @ApiResponse(responseCode="404", description="Classification for instance {name} is not found")})
    public Classification getByName(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Name of the classification", schema=@Schema(type="string")) @PathParam(value="name") String name, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="usageCount,termCount")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        return (Classification)this.getByNameInternal(uriInfo, securityContext, name, fieldsParam, include);
    }

    @GET
    @Path(value="/{id}/versions")
    @Operation(operationId="listAllClassificationVersion", summary="List classification versions", description="Get a list of all the versions of a classification identified by `id`", responses={@ApiResponse(responseCode="200", description="List of classification versions", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntityHistory.class))})})
    public EntityHistory listVersions(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the classification", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) {
        return super.listVersionsInternal(securityContext, id);
    }

    @GET
    @Path(value="/{id}/versions/{version}")
    @Operation(operationId="getSpecificClassificationVersion", summary="Get a version of the classification", description="Get a version of the classification by given `id`", responses={@ApiResponse(responseCode="200", description="glossaries", content={@Content(mediaType="application/json", schema=@Schema(implementation=Classification.class))}), @ApiResponse(responseCode="404", description="Classification for instance {id} and version {version} is not found")})
    public Classification getVersion(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the classification", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="classification version number in the form `major`.`minor`", schema=@Schema(type="string", example="0.1 or 1.1")) @PathParam(value="version") String version) {
        return (Classification)super.getVersionInternal(securityContext, id, version);
    }

    @Override
    @POST
    @Operation(operationId="createClassification", summary="Create a classification", description="Create a new classification. The request can include the children tags to be created along with the classification.", responses={@ApiResponse(responseCode="200", description="The user ", content={@Content(mediaType="application/json", schema=@Schema(implementation=Classification.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response create(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateClassification create) {
        Classification category = this.getClassification(create, securityContext);
        return this.create(uriInfo, securityContext, category);
    }

    @Override
    @PUT
    @Operation(operationId="createOrUpdateClassification", summary="Update a classification", description="Update an existing category identify by category name")
    public Response createOrUpdate(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateClassification create) {
        Classification category = this.getClassification(create, securityContext);
        return this.createOrUpdate(uriInfo, securityContext, category);
    }

    @PATCH
    @Path(value="/{id}")
    @Operation(operationId="patchClassification", summary="Update a classification", description="Update an existing classification using JsonPatch.", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"))
    @Consumes(value={"application/json-patch+json"})
    public Response patch(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the classification", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @RequestBody(description="JsonPatch with array of operations", content={@Content(mediaType="application/json-patch+json", examples={@ExampleObject(value="[{op:remove, path:/a},{op:add, path: /b, value: val}]")})}) JsonPatch patch) {
        return this.patchInternal(uriInfo, securityContext, id, patch);
    }

    @DELETE
    @Path(value="/{id}")
    @Operation(operationId="deleteClassification", summary="Delete classification by id", description="Delete a classification and all the tags under it.")
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Recursively delete this entity and it's children. (Default `false`)") @DefaultValue(value="false") @QueryParam(value="recursive") boolean recursive, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Id of the classification", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) {
        return this.delete(uriInfo, securityContext, id, recursive, hardDelete);
    }

    @DELETE
    @Path(value="/name/{name}")
    @Operation(operationId="deleteClassificationByName", summary="Delete classification by name", description="Delete a classification by `name` and all the tags under it.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="classification for instance {name} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Name of the classification", schema=@Schema(type="string")) @PathParam(value="name") String name) {
        return this.deleteByName(uriInfo, securityContext, name, false, hardDelete);
    }

    @PUT
    @Path(value="/restore")
    @Operation(operationId="restoreClassification", summary="Restore a soft deleted classification", description="Restore a soft deleted classification.", responses={@ApiResponse(responseCode="200", description="Successfully restored the Table ", content={@Content(mediaType="application/json", schema=@Schema(implementation=Table.class))})})
    public Response restore(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid RestoreEntity restore) {
        return this.restoreEntity(uriInfo, securityContext, restore.getId());
    }

    private Classification getClassification(CreateClassification create, SecurityContext securityContext) {
        return ClassificationResource.getClassification((ClassificationRepository)this.repository, create, securityContext.getUserPrincipal().getName());
    }

    public static Classification getClassification(ClassificationRepository repository, CreateClassification create, String updatedBy) {
        return repository.copy(new Classification(), (CreateEntity)create, updatedBy).withFullyQualifiedName(create.getName()).withProvider(create.getProvider()).withMutuallyExclusive(create.getMutuallyExclusive());
    }

    static class ClassificationList
    extends ResultList<Classification> {
        ClassificationList() {
        }
    }
}

