/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.version;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.InputStream;
import java.util.Properties;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.openmetadata.schema.api.OpenMetadataServerVersion;
import org.openmetadata.service.OpenMetadataApplication;
import org.openmetadata.service.resources.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/system/version")
@Tag(name="System", description="APIs related to System configuration and settings.")
@Produces(value={"application/json"})
@Collection(name="version")
public class VersionResource {
    private static final Logger LOG = LoggerFactory.getLogger(VersionResource.class);
    private static final OpenMetadataServerVersion OPEN_METADATA_SERVER_VERSION = new OpenMetadataServerVersion();

    @GET
    @Operation(operationId="getCatalogVersion", summary="Get version of metadata service", description="Get the build version of OpenMetadata service and build timestamp.")
    public OpenMetadataServerVersion getCatalogVersion() {
        return OPEN_METADATA_SERVER_VERSION;
    }

    static {
        try {
            InputStream fileInput = OpenMetadataApplication.class.getResourceAsStream("/catalog/VERSION");
            Properties props = new Properties();
            props.load(fileInput);
            OPEN_METADATA_SERVER_VERSION.setVersion(props.getProperty("version", "unknown"));
            OPEN_METADATA_SERVER_VERSION.setRevision(props.getProperty("revision", "unknown"));
            String timestampAsString = props.getProperty("timestamp");
            Long timestamp = timestampAsString != null ? Long.valueOf(timestampAsString) : null;
            OPEN_METADATA_SERVER_VERSION.setTimestamp(timestamp);
        }
        catch (Exception ie) {
            LOG.warn("Failed to read catalog version file");
        }
    }
}

