/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.entity.teams.Team;
import org.openmetadata.service.search.SearchIndexUtils;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;
import org.openmetadata.service.util.JsonUtils;

public class TeamIndex
implements SearchIndex {
    final Team team;
    final List<String> excludeFields = List.of("owns", "changeDescription");

    public TeamIndex(Team team) {
        this.team = team;
    }

    @Override
    public Map<String, Object> buildESDoc() {
        Map<String, Object> doc = JsonUtils.getMap(this.team);
        SearchIndexUtils.removeNonIndexableFields(doc, this.excludeFields);
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.team.getName()).weight(5).build());
        suggest.add(SearchSuggest.builder().input(this.team.getDisplayName()).weight(10).build());
        doc.put("fqnParts", this.getFQNParts(this.team.getFullyQualifiedName(), suggest.stream().map(SearchSuggest::getInput).toList()));
        doc.put("suggest", suggest);
        doc.put("entityType", "team");
        doc.put("isBot", false);
        doc.put("displayName", CommonUtil.nullOrEmpty((String)this.team.getDisplayName()) ? this.team.getName() : this.team.getDisplayName());
        doc.put("followers", SearchIndexUtils.parseFollowers(this.team.getFollowers()));
        return doc;
    }
}

