/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.security;

import java.util.List;
import java.util.UUID;
import javax.ws.rs.core.SecurityContext;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Permission;
import org.openmetadata.schema.type.ResourcePermission;
import org.openmetadata.service.Entity;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.jdbi3.UserRepository;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.security.policyevaluator.OperationContext;
import org.openmetadata.service.security.policyevaluator.PolicyEvaluator;
import org.openmetadata.service.security.policyevaluator.ResourceContextInterface;
import org.openmetadata.service.util.RestUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoopAuthorizer
implements Authorizer {
    private static final Logger LOG = LoggerFactory.getLogger(NoopAuthorizer.class);

    @Override
    public void init(OpenMetadataApplicationConfig openMetadataApplicationConfig) {
        this.addAnonymousUser();
    }

    @Override
    public List<ResourcePermission> listPermissions(SecurityContext securityContext, String user) {
        return PolicyEvaluator.getResourcePermissions(Permission.Access.ALLOW);
    }

    @Override
    public ResourcePermission getPermission(SecurityContext securityContext, String user, String resource) {
        return PolicyEvaluator.getResourcePermission(resource, Permission.Access.ALLOW);
    }

    @Override
    public ResourcePermission getPermission(SecurityContext securityContext, String user, ResourceContextInterface resourceContext) {
        return PolicyEvaluator.getResourcePermission(resourceContext.getResource(), Permission.Access.ALLOW);
    }

    @Override
    public void authorize(SecurityContext securityContext, OperationContext operationContext, ResourceContextInterface resourceContext) {
    }

    private void addAnonymousUser() {
        String username = "anonymous";
        try {
            Entity.getEntityByName("user", username, "", Include.NON_DELETED);
        }
        catch (EntityNotFoundException ex) {
            User user = new User().withId(UUID.randomUUID()).withName(username).withEmail(username + "@domain.com").withUpdatedBy(username).withUpdatedAt(Long.valueOf(System.currentTimeMillis()));
            this.addOrUpdateUser(user);
        }
        catch (Exception e) {
            LOG.error("Failed to create anonymous user {}", (Object)username, (Object)e);
        }
    }

    private void addOrUpdateUser(User user) {
        try {
            UserRepository userRepository = (UserRepository)Entity.getEntityRepository("user");
            RestUtil.PutResponse<User> addedUser = userRepository.createOrUpdate(null, user);
            LOG.debug("Added anonymous user entry: {}", addedUser);
        }
        catch (Exception exception) {
            LOG.debug("Caught exception ", (Throwable)exception);
            LOG.debug("Anonymous user entry: {} already exists.", (Object)user);
        }
    }

    @Override
    public void authorizeAdmin(SecurityContext securityContext) {
    }

    @Override
    public void authorizeAdminOrBot(SecurityContext securityContext) {
    }

    @Override
    public boolean shouldMaskPasswords(SecurityContext securityContext) {
        return false;
    }

    @Override
    public boolean authorizePII(SecurityContext securityContext, EntityReference owner) {
        return true;
    }
}

