/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.socket;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class HeaderRequestWrapper
extends HttpServletRequestWrapper {
    private final Map<String, String> headerMap = new HashMap<String, String>();

    public HeaderRequestWrapper(HttpServletRequest request) {
        super(request);
    }

    public void addHeader(String name, String value) {
        this.headerMap.put(name, value);
    }

    public String getHeader(String name) {
        String headerValue = super.getHeader(name);
        if (this.headerMap.containsKey(name)) {
            headerValue = this.headerMap.get(name);
        }
        return headerValue;
    }

    public Enumeration<String> getHeaderNames() {
        ArrayList names = Collections.list(super.getHeaderNames());
        names.addAll(this.headerMap.keySet());
        return Collections.enumeration(names);
    }

    public Enumeration<String> getHeaders(String name) {
        ArrayList values = Collections.list(super.getHeaders(name));
        if (this.headerMap.containsKey(name)) {
            values.add(this.headerMap.get(name));
        }
        return Collections.enumeration(values);
    }
}

