/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.feed.Thread;
import org.openmetadata.schema.type.ChangeDescription;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.schema.type.EventType;
import org.openmetadata.service.Entity;
import org.openmetadata.service.events.subscription.AlertsRuleEvaluator;
import org.openmetadata.service.formatter.decorators.MessageDecorator;
import org.openmetadata.service.formatter.util.FormatterUtil;
import org.openmetadata.service.resources.feeds.MessageParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FeedUtils {
    private static final Logger LOG = LoggerFactory.getLogger(FeedUtils.class);

    private FeedUtils() {
    }

    public static List<Thread> getThreadWithMessage(MessageDecorator<?> messageDecorator, ChangeEvent changeEvent, String loggedInUserName) {
        if (changeEvent == null || changeEvent.getEntity() == null) {
            return Collections.emptyList();
        }
        if (changeEvent.getEntityType().equals("THREAD")) {
            return Collections.emptyList();
        }
        if (Entity.getEntityList().contains(changeEvent.getEntityType())) {
            return FeedUtils.populateMessageForDataAssets(messageDecorator, changeEvent, loggedInUserName);
        }
        LOG.error("Invalid Entity Type: {}, Currently Change Events are expected as Thread or Data Assets", (Object)changeEvent.getEntityType());
        return Collections.emptyList();
    }

    private static List<Thread> populateMessageForThread(ChangeEvent changeEvent, String loggedInUserName) {
        return null;
    }

    private static List<Thread> populateMessageForDataAssets(MessageDecorator<?> messageDecorator, ChangeEvent changeEvent, String loggedInUserName) {
        EntityInterface entityInterface = AlertsRuleEvaluator.getEntity(changeEvent);
        MessageParser.EntityLink about = new MessageParser.EntityLink(changeEvent.getEntityType(), entityInterface.getFullyQualifiedName(), null, null, null);
        return switch (changeEvent.getEventType()) {
            case EventType.ENTITY_CREATED -> {
                String message = String.format("Created **%s**: `%s`", changeEvent.getEntityType(), entityInterface.getFullyQualifiedName());
                yield List.of(FeedUtils.getThread(about.getLinkString(), message, loggedInUserName));
            }
            case EventType.ENTITY_UPDATED -> FeedUtils.getThreadWithMessage(messageDecorator, entityInterface, changeEvent.getChangeDescription(), loggedInUserName);
            case EventType.ENTITY_SOFT_DELETED -> {
                String message = String.format("Soft deleted **%s**: `%s`", changeEvent.getEntityType(), entityInterface.getFullyQualifiedName());
                yield List.of(FeedUtils.getThread(about.getLinkString(), message, loggedInUserName));
            }
            case EventType.ENTITY_DELETED -> {
                String message = String.format("Permanently Deleted **%s**: `%s`", changeEvent.getEntityType(), entityInterface.getFullyQualifiedName());
                yield List.of(FeedUtils.getThread(about.getLinkString(), message, loggedInUserName));
            }
            case EventType.LOGICAL_TEST_CASE_ADDED -> {
                String message = String.format("Added Logical Test Cases to **%s**: `%s`", changeEvent.getEntityType(), entityInterface.getFullyQualifiedName());
                yield List.of(FeedUtils.getThread(about.getLinkString(), message, loggedInUserName));
            }
            default -> entityInterface.getChangeDescription() == null ? Collections.emptyList() : FeedUtils.getThreadWithMessage(messageDecorator, entityInterface, entityInterface.getChangeDescription(), loggedInUserName);
        };
    }

    private static List<Thread> getThreadWithMessage(MessageDecorator<?> messageDecorator, EntityInterface entity, ChangeDescription changeDescription, String loggedInUserName) {
        ArrayList<Thread> threads = new ArrayList<Thread>();
        Map<MessageParser.EntityLink, String> messages = FormatterUtil.getFormattedMessages(messageDecorator, changeDescription, entity);
        for (Map.Entry<MessageParser.EntityLink, String> entry : messages.entrySet()) {
            threads.add(FeedUtils.getThread(entry.getKey().getLinkString(), entry.getValue(), loggedInUserName));
        }
        return threads;
    }

    private static Thread getThread(String linkString, String message, String loggedInUserName) {
        return new Thread().withId(UUID.randomUUID()).withThreadTs(Long.valueOf(System.currentTimeMillis())).withCreatedBy(loggedInUserName).withAbout(linkString).withReactions(Collections.emptyList()).withUpdatedBy(loggedInUserName).withUpdatedAt(Long.valueOf(System.currentTimeMillis())).withMessage(message);
    }
}

