/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.openmetadata.schema.entity.services.ServiceType;
import org.openmetadata.service.exception.ReflectionException;

public class ReflectionUtil {
    private ReflectionUtil() {
    }

    public static List<Method> getMethodsAnnotatedWith(Class<?> clazz, Class<? extends Annotation> annotation) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(annotation)) continue;
            methods.add(method);
        }
        return methods;
    }

    public static Class<?> createConnectionConfigClass(String connectionType, ServiceType serviceType) throws ClassNotFoundException {
        String clazzName = "org.openmetadata.schema.services.connections." + serviceType.value().toLowerCase(Locale.ROOT) + "." + connectionType + "Connection";
        return Class.forName(clazzName);
    }

    public static void setValueInMethod(Object toEncryptObject, String fieldValue, Method toSet) {
        try {
            toSet.invoke(toEncryptObject, fieldValue);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ReflectionException(e.getMessage());
        }
    }

    public static Method getToSetMethod(Object toEncryptObject, Object obj, String fieldName) {
        try {
            return toEncryptObject.getClass().getMethod("set" + fieldName, obj.getClass());
        }
        catch (NoSuchMethodException e) {
            throw new ReflectionException(e.getMessage());
        }
    }

    public static Object getObjectFromMethod(Method method, Object toEncryptObject) {
        Object obj;
        try {
            obj = method.invoke(toEncryptObject, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ReflectionException(e.getMessage());
        }
        return obj;
    }

    public static boolean isGetMethodOfObject(Method method) {
        return method.getName().startsWith("get") && !method.getReturnType().equals(Void.TYPE) && !method.getReturnType().isPrimitive();
    }
}

