/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.util;

import io.dropwizard.jersey.validation.DropwizardConfiguredValidator;
import java.util.Arrays;
import java.util.Set;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ValidatorUtil {
    public static final Validator VALIDATOR;

    private ValidatorUtil() {
    }

    public static <T> String validate(T entity) {
        Set violations = VALIDATOR.validate(entity, new Class[0]);
        return violations.isEmpty() ? null : Arrays.toString(violations.stream().map(v -> String.format("%s %s", v.getPropertyPath(), v.getMessage())).toArray());
    }

    static {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        VALIDATOR = new DropwizardConfiguredValidator(factory.getValidator());
    }
}

