/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.workflows.searchIndex;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.system.EntityError;
import org.openmetadata.schema.system.StepStats;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.jdbi3.ListFilter;
import os.org.opensearch.action.bulk.BulkItemResponse;
import os.org.opensearch.action.bulk.BulkResponse;

public class ReindexingUtil {
    public static final String ENTITY_TYPE_KEY = "entityType";

    private ReindexingUtil() {
    }

    public static void getUpdatedStats(StepStats stats, int currentSuccess, int currentFailed) {
        stats.setSuccessRecords(Integer.valueOf(stats.getSuccessRecords() + currentSuccess));
        stats.setFailedRecords(Integer.valueOf(stats.getFailedRecords() + currentFailed));
    }

    public static boolean isDataInsightIndex(String entityType) {
        return Entity.getSearchRepository().getDataInsightReports().contains(entityType);
    }

    public static int getTotalRequestToProcess(Set<String> entities, CollectionDAO dao) {
        int total = 0;
        for (String entityType : entities) {
            if (!ReindexingUtil.isDataInsightIndex(entityType)) {
                EntityRepository<? extends EntityInterface> repository = Entity.getEntityRepository(entityType);
                total += repository.getDao().listTotalCount();
                continue;
            }
            total += dao.reportDataTimeSeriesDao().listCount(new ListFilter(null).addQueryParam("entityFQNHash", entityType));
        }
        return total;
    }

    public static int getSuccessFromBulkResponse(BulkResponse response) {
        int success = 0;
        for (BulkItemResponse bulkItemResponse : response) {
            if (bulkItemResponse.isFailed()) continue;
            ++success;
        }
        return success;
    }

    public static List<EntityError> getErrorsFromBulkResponse(BulkResponse response) {
        ArrayList<EntityError> entityErrors = new ArrayList<EntityError>();
        for (BulkItemResponse bulkItemResponse : response) {
            if (!bulkItemResponse.isFailed()) continue;
            entityErrors.add(new EntityError().withMessage(bulkItemResponse.getFailureMessage()).withEntity((Object)bulkItemResponse.getItemId()));
        }
        return entityErrors;
    }

    public static List<EntityError> getErrorsFromBulkResponse(es.org.elasticsearch.action.bulk.BulkResponse response) {
        ArrayList<EntityError> entityErrors = new ArrayList<EntityError>();
        for (es.org.elasticsearch.action.bulk.BulkItemResponse bulkItemResponse : response) {
            if (!bulkItemResponse.isFailed()) continue;
            entityErrors.add(new EntityError().withMessage(bulkItemResponse.getFailureMessage()).withEntity((Object)bulkItemResponse.getItemId()));
        }
        return entityErrors;
    }

    public static int getSuccessFromBulkResponseEs(es.org.elasticsearch.action.bulk.BulkResponse response) {
        int success = 0;
        for (es.org.elasticsearch.action.bulk.BulkItemResponse bulkItemResponse : response) {
            if (bulkItemResponse.isFailed()) continue;
            ++success;
        }
        return success;
    }
}

