/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.UriInfo;
import lombok.NonNull;
import org.jdbi.v3.core.Jdbi;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.EntityTimeSeriesInterface;
import org.openmetadata.schema.FieldInterface;
import org.openmetadata.schema.entity.services.ServiceType;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.MetadataOperation;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.ResourceRegistry;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.jdbi3.ChangeEventRepository;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.jdbi3.EntityTimeSeriesRepository;
import org.openmetadata.service.jdbi3.FeedRepository;
import org.openmetadata.service.jdbi3.LineageRepository;
import org.openmetadata.service.jdbi3.PolicyRepository;
import org.openmetadata.service.jdbi3.Repository;
import org.openmetadata.service.jdbi3.RoleRepository;
import org.openmetadata.service.jdbi3.SuggestionRepository;
import org.openmetadata.service.jdbi3.SystemRepository;
import org.openmetadata.service.jdbi3.TokenRepository;
import org.openmetadata.service.jdbi3.UsageRepository;
import org.openmetadata.service.resources.feeds.MessageParser;
import org.openmetadata.service.resources.tags.TagLabelUtil;
import org.openmetadata.service.search.SearchRepository;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Entity {
    private static final Logger LOG = LoggerFactory.getLogger(Entity.class);
    private static volatile boolean initializedRepositories = false;
    private static CollectionDAO collectionDAO;
    public static final String SEPARATOR = ".";
    private static final Map<String, EntityRepository<? extends EntityInterface>> ENTITY_REPOSITORY_MAP;
    private static final Map<String, EntityTimeSeriesRepository<? extends EntityTimeSeriesInterface>> ENTITY_TS_REPOSITORY_MAP;
    private static TokenRepository tokenRepository;
    private static PolicyRepository policyRepository;
    private static RoleRepository roleRepository;
    private static FeedRepository feedRepository;
    private static LineageRepository lineageRepository;
    private static UsageRepository usageRepository;
    private static SystemRepository systemRepository;
    private static ChangeEventRepository changeEventRepository;
    private static SearchRepository searchRepository;
    private static SuggestionRepository suggestionRepository;
    private static final Set<String> ENTITY_LIST;
    public static final String FIELD_OWNER = "owner";
    public static final String FIELD_NAME = "name";
    public static final String FIELD_DESCRIPTION = "description";
    public static final String FIELD_FOLLOWERS = "followers";
    public static final String FIELD_VOTES = "votes";
    public static final String FIELD_TAGS = "tags";
    public static final String FIELD_DELETED = "deleted";
    public static final String FIELD_PIPELINE_STATUS = "pipelineStatus";
    public static final String FIELD_DISPLAY_NAME = "displayName";
    public static final String FIELD_EXTENSION = "extension";
    public static final String FIELD_USAGE_SUMMARY = "usageSummary";
    public static final String FIELD_CHILDREN = "children";
    public static final String FIELD_PARENT = "parent";
    public static final String FIELD_REVIEWERS = "reviewers";
    public static final String FIELD_EXPERTS = "experts";
    public static final String FIELD_DOMAIN = "domain";
    public static final String FIELD_DATA_PRODUCTS = "dataProducts";
    public static final String FIELD_ASSETS = "assets";
    public static final String FIELD_STYLE = "style";
    public static final String FIELD_LIFE_CYCLE = "lifeCycle";
    public static final String FIELD_DISABLED = "disabled";
    public static final String DATABASE_SERVICE = "databaseService";
    public static final String MESSAGING_SERVICE = "messagingService";
    public static final String DASHBOARD_SERVICE = "dashboardService";
    public static final String PIPELINE_SERVICE = "pipelineService";
    public static final String STORAGE_SERVICE = "storageService";
    public static final String MLMODEL_SERVICE = "mlmodelService";
    public static final String METADATA_SERVICE = "metadataService";
    public static final String SEARCH_SERVICE = "searchService";
    public static final String TABLE = "table";
    public static final String STORED_PROCEDURE = "storedProcedure";
    public static final String DATABASE = "database";
    public static final String DATABASE_SCHEMA = "databaseSchema";
    public static final String METRICS = "metrics";
    public static final String DASHBOARD = "dashboard";
    public static final String DASHBOARD_DATA_MODEL = "dashboardDataModel";
    public static final String PIPELINE = "pipeline";
    public static final String TASK = "task";
    public static final String CHART = "chart";
    public static final String APPLICATION = "app";
    public static final String APP_MARKET_PLACE_DEF = "appMarketPlaceDefinition";
    public static final String REPORT = "report";
    public static final String TOPIC = "topic";
    public static final String SEARCH_INDEX = "searchIndex";
    public static final String MLMODEL = "mlmodel";
    public static final String CONTAINER = "container";
    public static final String QUERY = "query";
    public static final String GLOSSARY = "glossary";
    public static final String GLOSSARY_TERM = "glossaryTerm";
    public static final String TAG = "tag";
    public static final String CLASSIFICATION = "classification";
    public static final String TYPE = "type";
    public static final String TEST_DEFINITION = "testDefinition";
    public static final String TEST_CONNECTION_DEFINITION = "testConnectionDefinition";
    public static final String TEST_SUITE = "testSuite";
    public static final String KPI = "kpi";
    public static final String TEST_CASE = "testCase";
    public static final String WEB_ANALYTIC_EVENT = "webAnalyticEvent";
    public static final String DATA_INSIGHT_CHART = "dataInsightChart";
    public static final String POLICY = "policy";
    public static final String POLICIES = "policies";
    public static final String ROLE = "role";
    public static final String USER = "user";
    public static final String TEAM = "team";
    public static final String PERSONA = "persona";
    public static final String BOT = "bot";
    public static final String INGESTION_PIPELINE = "ingestionPipeline";
    public static final String DOMAIN = "domain";
    public static final String DATA_PRODUCT = "dataProduct";
    public static final String EVENT_SUBSCRIPTION = "eventsubscription";
    public static final String THREAD = "THREAD";
    public static final String SUGGESTION = "SUGGESTION";
    public static final String WORKFLOW = "workflow";
    public static final String ENTITY_REPORT_DATA = "entityReportData";
    public static final String TEST_CASE_RESOLUTION_STATUS = "testCaseResolutionStatus";
    public static final String WEB_ANALYTIC_ENTITY_VIEW_REPORT_DATA = "webAnalyticEntityViewReportData";
    public static final String WEB_ANALYTIC_USER_ACTIVITY_REPORT_DATA = "webAnalyticUserActivityReportData";
    public static final String RAW_COST_ANALYSIS_REPORT_DATA = "rawCostAnalysisReportData";
    public static final String AGGREGATED_COST_ANALYSIS_REPORT_DATA = "aggregatedCostAnalysisReportData";
    public static final String ADMIN_USER_NAME = "admin";
    public static final String ORGANIZATION_NAME = "Organization";
    public static final String ORGANIZATION_POLICY_NAME = "OrganizationPolicy";
    public static final String INGESTION_BOT_NAME = "ingestion-bot";
    public static final String INGESTION_BOT_ROLE = "IngestionBotRole";
    public static final String PROFILER_BOT_NAME = "profiler-bot";
    public static final String PROFILER_BOT_ROLE = "ProfilerBotRole";
    public static final String QUALITY_BOT_NAME = "quality-bot";
    public static final String QUALITY_BOT_ROLE = "QualityBotRole";
    public static final String ALL_RESOURCES = "All";
    public static final String DOCUMENT = "document";
    static final Map<ServiceType, String> SERVICE_TYPE_ENTITY_MAP;

    private Entity() {
    }

    public static void initializeRepositories(OpenMetadataApplicationConfig config, Jdbi jdbi) {
        if (!initializedRepositories) {
            tokenRepository = new TokenRepository();
            policyRepository = new PolicyRepository();
            roleRepository = new RoleRepository();
            List<Class<?>> repositories = Entity.getRepositories();
            for (Class<?> clz : repositories) {
                if (Modifier.isAbstract(clz.getModifiers())) continue;
                try {
                    clz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    try {
                        clz.getDeclaredConstructor(OpenMetadataApplicationConfig.class).newInstance(new Object[]{config});
                    }
                    catch (Exception ex) {
                        try {
                            clz.getDeclaredConstructor(Jdbi.class).newInstance(jdbi);
                        }
                        catch (Exception exception) {
                            LOG.warn("Exception encountered", (Throwable)exception);
                        }
                    }
                }
            }
            initializedRepositories = true;
        }
    }

    public static void cleanup() {
        initializedRepositories = false;
        collectionDAO = null;
        searchRepository = null;
        ENTITY_REPOSITORY_MAP.clear();
    }

    public static <T extends EntityInterface> void registerEntity(Class<T> clazz, String entity, EntityRepository<T> entityRepository) {
        ENTITY_REPOSITORY_MAP.put(entity, entityRepository);
        EntityInterface.CANONICAL_ENTITY_NAME_MAP.put(entity.toLowerCase(Locale.ROOT), entity);
        EntityInterface.ENTITY_TYPE_TO_CLASS_MAP.put(entity.toLowerCase(Locale.ROOT), clazz);
        ENTITY_LIST.add(entity);
        LOG.debug("Registering entity {} {}", clazz, (Object)entity);
    }

    public static <T extends EntityTimeSeriesInterface> void registerEntity(Class<T> clazz, String entity, EntityTimeSeriesRepository<T> entityRepository) {
        ENTITY_TS_REPOSITORY_MAP.put(entity, entityRepository);
        EntityTimeSeriesInterface.CANONICAL_ENTITY_NAME_MAP.put(entity.toLowerCase(Locale.ROOT), entity);
        EntityTimeSeriesInterface.ENTITY_TYPE_TO_CLASS_MAP.put(entity.toLowerCase(Locale.ROOT), clazz);
        ENTITY_LIST.add(entity);
        LOG.debug("Registering entity time series {} {}", clazz, (Object)entity);
    }

    public static void registerResourcePermissions(String entity, List<MetadataOperation> entitySpecificOperations) {
        Class<? extends EntityInterface> clazz = Entity.getEntityClassFromType(entity);
        ResourceRegistry.addResource(entity, entitySpecificOperations, Entity.getEntityFields(clazz));
    }

    public static void registerTimeSeriesResourcePermissions(String entity) {
        Class<? extends EntityTimeSeriesInterface> clazz = Entity.getEntityTimeSeriesClassFromType(entity);
        ResourceRegistry.addResource(entity, null, Entity.getEntityFields(clazz));
    }

    public static Set<String> getEntityList() {
        return Collections.unmodifiableSet(ENTITY_LIST);
    }

    public static EntityReference getEntityReference(EntityReference ref, Include include) {
        if (ref == null) {
            return null;
        }
        return ref.getId() != null ? Entity.getEntityReferenceById(ref.getType(), ref.getId(), include) : Entity.getEntityReferenceByName(ref.getType(), ref.getFullyQualifiedName(), include);
    }

    public static EntityReference getEntityReferenceById(@NonNull String entityType, @NonNull UUID id, Include include) {
        if (entityType == null) {
            throw new NullPointerException("entityType is marked non-null but is null");
        }
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        EntityRepository<? extends EntityInterface> repository = Entity.getEntityRepository(entityType);
        include = repository.supportsSoftDelete ? Include.ALL : include;
        return repository.getReference(id, include);
    }

    public static EntityReference getEntityReferenceByName(@NonNull String entityType, String fqn, Include include) {
        if (entityType == null) {
            throw new NullPointerException("entityType is marked non-null but is null");
        }
        if (fqn == null) {
            return null;
        }
        EntityRepository<? extends EntityInterface> repository = Entity.getEntityRepository(entityType);
        return repository.getReferenceByName(fqn, include);
    }

    public static EntityReference getOwner(@NonNull EntityReference reference) {
        if (reference == null) {
            throw new NullPointerException("reference is marked non-null but is null");
        }
        EntityRepository<? extends EntityInterface> repository = Entity.getEntityRepository(reference.getType());
        return repository.getOwner(reference);
    }

    public static void withHref(UriInfo uriInfo, List<EntityReference> list) {
        CommonUtil.listOrEmpty(list).forEach(ref -> Entity.withHref(uriInfo, ref));
    }

    public static void withHref(UriInfo uriInfo, EntityReference ref) {
        if (ref == null) {
            return;
        }
        String entityType = ref.getType();
        EntityRepository<? extends EntityInterface> entityRepository = Entity.getEntityRepository(entityType);
        URI href = entityRepository.getHref(uriInfo, ref.getId());
        ref.withHref(href);
    }

    public static EntityUtil.Fields getFields(String entityType, List<String> fields) {
        EntityRepository<? extends EntityInterface> entityRepository = Entity.getEntityRepository(entityType);
        return entityRepository.getFields(String.join((CharSequence)",", fields));
    }

    public static <T> T getEntity(EntityReference ref, String fields, Include include) {
        return ref.getId() != null ? Entity.getEntity(ref.getType(), ref.getId(), fields, include) : Entity.getEntityByName(ref.getType(), ref.getFullyQualifiedName(), fields, include);
    }

    public static <T> T getEntity(MessageParser.EntityLink link, String fields, Include include) {
        return Entity.getEntityByName(link.getEntityType(), link.getEntityFQN(), fields, include);
    }

    public static <T> T getEntity(String entityType, UUID id, String fields, Include include, boolean fromCache) {
        EntityRepository<? extends EntityInterface> entityRepository = Entity.getEntityRepository(entityType);
        EntityInterface entity = entityRepository.get(null, id, entityRepository.getFields(fields), include, fromCache);
        return (T)entity;
    }

    public static <T> T getEntity(String entityType, UUID id, String fields, Include include) {
        return Entity.getEntity(entityType, id, fields, include, true);
    }

    public static <T> T getEntityByName(String entityType, String fqn, String fields, Include include, boolean fromCache) {
        EntityRepository<? extends EntityInterface> entityRepository = Entity.getEntityRepository(entityType);
        EntityInterface entity = entityRepository.getByName(null, fqn, entityRepository.getFields(fields), include, fromCache);
        return (T)entity;
    }

    public static <T> T getEntityByName(String entityType, String fqn, String fields, Include include) {
        return Entity.getEntityByName(entityType, fqn, fields, include, true);
    }

    public static EntityRepository<? extends EntityInterface> getEntityRepository(@NonNull String entityType) {
        if (entityType == null) {
            throw new NullPointerException("entityType is marked non-null but is null");
        }
        EntityRepository<? extends EntityInterface> entityRepository = ENTITY_REPOSITORY_MAP.get(entityType);
        if (entityRepository == null) {
            throw EntityNotFoundException.byMessage(CatalogExceptionMessage.entityRepositoryNotFound(entityType));
        }
        return entityRepository;
    }

    public static EntityTimeSeriesRepository<? extends EntityTimeSeriesInterface> getEntityTimeSeriesRepository(@NonNull String entityType) {
        if (entityType == null) {
            throw new NullPointerException("entityType is marked non-null but is null");
        }
        EntityTimeSeriesRepository<? extends EntityTimeSeriesInterface> entityTimeSeriesRepository = ENTITY_TS_REPOSITORY_MAP.get(entityType);
        if (entityTimeSeriesRepository == null) {
            throw EntityNotFoundException.byMessage(CatalogExceptionMessage.entityTypeNotFound(entityType));
        }
        return entityTimeSeriesRepository;
    }

    public static EntityRepository<? extends EntityInterface> getServiceEntityRepository(@NonNull ServiceType serviceType) {
        if (serviceType == null) {
            throw new NullPointerException("serviceType is marked non-null but is null");
        }
        EntityRepository<? extends EntityInterface> entityRepository = ENTITY_REPOSITORY_MAP.get(SERVICE_TYPE_ENTITY_MAP.get(serviceType));
        if (entityRepository == null) {
            throw EntityNotFoundException.byMessage(CatalogExceptionMessage.entityTypeNotFound(serviceType.value()));
        }
        return entityRepository;
    }

    public static List<TagLabel> getEntityTags(String entityType, EntityInterface entity) {
        EntityRepository<? extends EntityInterface> entityRepository = Entity.getEntityRepository(entityType);
        return CommonUtil.listOrEmpty(entityRepository.getAllTags(entity));
    }

    public static void deleteEntity(String updatedBy, String entityType, UUID entityId, boolean recursive, boolean hardDelete) {
        EntityRepository<? extends EntityInterface> dao = Entity.getEntityRepository(entityType);
        try {
            dao.find(entityId, Include.ALL);
            dao.delete(updatedBy, (EntityInterface)entityId, recursive, hardDelete);
        }
        catch (EntityNotFoundException e) {
            LOG.warn("Entity {} is already deleted.", (Object)entityId);
        }
    }

    public static void restoreEntity(String updatedBy, String entityType, UUID entityId) {
        EntityRepository<? extends EntityInterface> dao = Entity.getEntityRepository(entityType);
        dao.restoreEntity(updatedBy, entityType, entityId);
    }

    public static <T> String getEntityTypeFromClass(Class<T> clz) {
        return (String)EntityInterface.CANONICAL_ENTITY_NAME_MAP.get(clz.getSimpleName().toLowerCase(Locale.ROOT));
    }

    public static String getEntityTypeFromObject(Object object) {
        return (String)EntityInterface.CANONICAL_ENTITY_NAME_MAP.get(object.getClass().getSimpleName().toLowerCase(Locale.ROOT));
    }

    public static Class<? extends EntityInterface> getEntityClassFromType(String entityType) {
        return (Class)EntityInterface.ENTITY_TYPE_TO_CLASS_MAP.get(entityType.toLowerCase(Locale.ROOT));
    }

    public static Class<? extends EntityTimeSeriesInterface> getEntityTimeSeriesClassFromType(String entityType) {
        return (Class)EntityTimeSeriesInterface.ENTITY_TYPE_TO_CLASS_MAP.get(entityType.toLowerCase(Locale.ROOT));
    }

    public static <T> Set<String> getEntityFields(Class<T> clz) {
        JsonPropertyOrder propertyOrder = clz.getAnnotation(JsonPropertyOrder.class);
        return new HashSet<String>(Arrays.asList(propertyOrder.value()));
    }

    public static boolean supportsFeed(String entityType) {
        return CommonUtil.listOf((Object[])new String[]{TABLE, DATABASE, DATABASE_SCHEMA, METRICS, DASHBOARD, DASHBOARD_DATA_MODEL, PIPELINE, CHART, REPORT, TOPIC, MLMODEL, CONTAINER, QUERY, GLOSSARY, GLOSSARY_TERM, TAG, CLASSIFICATION}).contains(entityType);
    }

    private static List<Class<?>> getRepositories() {
        try (ScanResult scanResult = new ClassGraph().enableAnnotationInfo().scan();){
            ClassInfoList classList = scanResult.getClassesWithAnnotation(Repository.class);
            List list = classList.loadClasses();
            return list;
        }
    }

    public static <T extends FieldInterface> void populateEntityFieldTags(String entityType, List<T> fields, String fqnPrefix, boolean setTags) {
        EntityRepository<? extends EntityInterface> repository = Entity.getEntityRepository(entityType);
        List<T> flattenedFields = EntityUtil.getFlattenedEntityField(fields);
        Map<String, List<TagLabel>> allTags = repository.getTagsByPrefix(fqnPrefix, ".%");
        for (FieldInterface c : CommonUtil.listOrEmpty(flattenedFields)) {
            if (setTags) {
                List<TagLabel> columnTag = allTags.get(FullyQualifiedName.buildHash(c.getFullyQualifiedName()));
                if (columnTag == null) {
                    c.setTags(new ArrayList());
                    continue;
                }
                c.setTags(TagLabelUtil.addDerivedTags(columnTag));
                continue;
            }
            c.setTags(c.getTags());
        }
    }

    public static SearchIndex buildSearchIndex(String entityType, Object entity) {
        if (searchRepository != null) {
            return searchRepository.getSearchIndexFactory().buildIndex(entityType, entity);
        }
        throw new BadRequestException("searchrepository not initialized");
    }

    public static <T> T getDao() {
        return (T)collectionDAO;
    }

    public static CollectionDAO getCollectionDAO() {
        return collectionDAO;
    }

    public static void setCollectionDAO(CollectionDAO collectionDAO) {
        Entity.collectionDAO = collectionDAO;
    }

    public static TokenRepository getTokenRepository() {
        return tokenRepository;
    }

    public static void setTokenRepository(TokenRepository tokenRepository) {
        Entity.tokenRepository = tokenRepository;
    }

    public static PolicyRepository getPolicyRepository() {
        return policyRepository;
    }

    public static void setPolicyRepository(PolicyRepository policyRepository) {
        Entity.policyRepository = policyRepository;
    }

    public static RoleRepository getRoleRepository() {
        return roleRepository;
    }

    public static void setRoleRepository(RoleRepository roleRepository) {
        Entity.roleRepository = roleRepository;
    }

    public static FeedRepository getFeedRepository() {
        return feedRepository;
    }

    public static void setFeedRepository(FeedRepository feedRepository) {
        Entity.feedRepository = feedRepository;
    }

    public static LineageRepository getLineageRepository() {
        return lineageRepository;
    }

    public static void setLineageRepository(LineageRepository lineageRepository) {
        Entity.lineageRepository = lineageRepository;
    }

    public static UsageRepository getUsageRepository() {
        return usageRepository;
    }

    public static void setUsageRepository(UsageRepository usageRepository) {
        Entity.usageRepository = usageRepository;
    }

    public static SystemRepository getSystemRepository() {
        return systemRepository;
    }

    public static void setSystemRepository(SystemRepository systemRepository) {
        Entity.systemRepository = systemRepository;
    }

    public static ChangeEventRepository getChangeEventRepository() {
        return changeEventRepository;
    }

    public static void setChangeEventRepository(ChangeEventRepository changeEventRepository) {
        Entity.changeEventRepository = changeEventRepository;
    }

    public static SearchRepository getSearchRepository() {
        return searchRepository;
    }

    public static void setSearchRepository(SearchRepository searchRepository) {
        Entity.searchRepository = searchRepository;
    }

    public static SuggestionRepository getSuggestionRepository() {
        return suggestionRepository;
    }

    public static void setSuggestionRepository(SuggestionRepository suggestionRepository) {
        Entity.suggestionRepository = suggestionRepository;
    }

    static {
        ENTITY_REPOSITORY_MAP = new HashMap<String, EntityRepository<? extends EntityInterface>>();
        ENTITY_TS_REPOSITORY_MAP = new HashMap<String, EntityTimeSeriesRepository<? extends EntityTimeSeriesInterface>>();
        ENTITY_LIST = new TreeSet<String>();
        SERVICE_TYPE_ENTITY_MAP = new EnumMap<ServiceType, String>(ServiceType.class);
        SERVICE_TYPE_ENTITY_MAP.put(ServiceType.DATABASE, DATABASE_SERVICE);
        SERVICE_TYPE_ENTITY_MAP.put(ServiceType.MESSAGING, MESSAGING_SERVICE);
        SERVICE_TYPE_ENTITY_MAP.put(ServiceType.DASHBOARD, DASHBOARD_SERVICE);
        SERVICE_TYPE_ENTITY_MAP.put(ServiceType.PIPELINE, PIPELINE_SERVICE);
        SERVICE_TYPE_ENTITY_MAP.put(ServiceType.ML_MODEL, MLMODEL_SERVICE);
        SERVICE_TYPE_ENTITY_MAP.put(ServiceType.METADATA, METADATA_SERVICE);
        SERVICE_TYPE_ENTITY_MAP.put(ServiceType.STORAGE, STORAGE_SERVICE);
        SERVICE_TYPE_ENTITY_MAP.put(ServiceType.SEARCH, SEARCH_SERVICE);
    }

    public static class EntityList {
        private EntityList() {
        }

        public static List<String> getEntityList(String name, String entitiesParam) {
            if (entitiesParam == null) {
                return Collections.emptyList();
            }
            if ((entitiesParam = entitiesParam.replace(" ", "")).equals("*")) {
                return List.of("*");
            }
            List<String> list = Arrays.asList(entitiesParam.split(","));
            EntityList.validateEntities(name, list);
            return list;
        }

        private static void validateEntities(String name, List<String> list) {
            for (String entity : list) {
                if (ENTITY_REPOSITORY_MAP.get(entity) != null) continue;
                throw new IllegalArgumentException(String.format("Invalid entity %s in query param %s", entity, name));
            }
        }
    }
}

