/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service;

import com.networknt.schema.JsonSchema;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.entity.Type;
import org.openmetadata.schema.entity.type.CustomProperty;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.util.FullyQualifiedName;
import org.openmetadata.service.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(TypeRegistry.class);
    protected static final Map<String, Type> TYPES = new ConcurrentHashMap<String, Type>();
    protected static final Map<String, CustomProperty> CUSTOM_PROPERTIES = new ConcurrentHashMap<String, CustomProperty>();
    protected static final Map<String, JsonSchema> CUSTOM_PROPERTY_SCHEMAS = new ConcurrentHashMap<String, JsonSchema>();
    private static final TypeRegistry INSTANCE = new TypeRegistry();

    private TypeRegistry() {
    }

    public static TypeRegistry instance() {
        return INSTANCE;
    }

    public void addType(Type type) {
        TYPES.put(type.getName(), type);
        for (CustomProperty property : type.getCustomProperties()) {
            TypeRegistry.instance().addCustomProperty(type.getName(), property.getName(), property);
        }
    }

    public void removeType(String typeName) {
        TYPES.remove(typeName);
        LOG.info("Deleted type {}", (Object)typeName);
    }

    private void addCustomProperty(String entityType, String propertyName, CustomProperty customProperty) {
        String customPropertyFQN = TypeRegistry.getCustomPropertyFQN(entityType, propertyName);
        CUSTOM_PROPERTIES.put(customPropertyFQN, customProperty);
        JsonSchema jsonSchema = JsonUtils.getJsonSchema(TYPES.get(customProperty.getPropertyType().getName()).getSchema());
        CUSTOM_PROPERTY_SCHEMAS.put(customPropertyFQN, jsonSchema);
        LOG.info("Adding custom property {} with JSON schema {}", (Object)customPropertyFQN, (Object)jsonSchema);
    }

    public JsonSchema getSchema(String entityType, String propertyName) {
        String customPropertyFQN = TypeRegistry.getCustomPropertyFQN(entityType, propertyName);
        return CUSTOM_PROPERTY_SCHEMAS.get(customPropertyFQN);
    }

    public void validateCustomProperties(Type type) {
        for (CustomProperty property : CommonUtil.listOrEmpty((List)type.getCustomProperties())) {
            if (TYPES.get(property.getPropertyType().getName()) != null) continue;
            throw EntityNotFoundException.byMessage(CatalogExceptionMessage.entityNotFound("type", property.getPropertyType().getName()));
        }
    }

    public static String getCustomPropertyFQNPrefix(String entityType) {
        return FullyQualifiedName.build(entityType, "customProperties");
    }

    public static String getCustomPropertyFQN(String entityType, String propertyName) {
        return FullyQualifiedName.build(entityType, "customProperties", propertyName);
    }

    public static String getPropertyName(String propertyFQN) {
        return FullyQualifiedName.split(propertyFQN)[2];
    }
}

