/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.apps.bundles.changeEvent.gchat;

import java.util.List;
import java.util.UUID;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Invocation;
import org.apache.commons.lang3.tuple.Pair;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.SubscriptionAction;
import org.openmetadata.schema.entity.events.SubscriptionDestination;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.schema.type.Webhook;
import org.openmetadata.service.apps.bundles.changeEvent.Destination;
import org.openmetadata.service.apps.bundles.changeEvent.gchat.GChatMessage;
import org.openmetadata.service.events.errors.EventPublisherException;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.formatter.decorators.GChatMessageDecorator;
import org.openmetadata.service.formatter.decorators.MessageDecorator;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.SubscriptionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GChatPublisher
implements Destination<ChangeEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(GChatPublisher.class);
    private final MessageDecorator<GChatMessage> gChatMessageMessageDecorator = new GChatMessageDecorator();
    private final Webhook webhook;
    private Invocation.Builder target;
    private final Client client;
    private final SubscriptionDestination subscriptionDestination;

    public GChatPublisher(SubscriptionDestination subscription) {
        if (subscription.getType() == SubscriptionDestination.SubscriptionType.G_CHAT) {
            String gChatWebhookURL;
            this.subscriptionDestination = subscription;
            this.webhook = JsonUtils.convertValue(subscription.getConfig(), Webhook.class);
            this.client = SubscriptionUtil.getClient(subscription.getTimeout(), subscription.getReadTimeout());
            if (this.webhook != null && this.webhook.getEndpoint() != null && !CommonUtil.nullOrEmpty((String)(gChatWebhookURL = this.webhook.getEndpoint().toString()))) {
                this.target = this.client.target(gChatWebhookURL).request();
            }
        } else {
            throw new IllegalArgumentException("GChat Alert Invoked with Illegal Type and Settings.");
        }
    }

    @Override
    public void sendMessage(ChangeEvent event) throws EventPublisherException {
        try {
            GChatMessage gchatMessage = this.gChatMessageMessageDecorator.buildOutgoingMessage(event);
            List<Invocation.Builder> targets = SubscriptionUtil.getTargetsForWebhookAlert((SubscriptionAction)this.webhook, this.subscriptionDestination.getCategory(), SubscriptionDestination.SubscriptionType.G_CHAT, this.client, event);
            if (this.target != null) {
                targets.add(this.target);
            }
            for (Invocation.Builder actionTarget : targets) {
                SubscriptionUtil.postWebhookMessage(this, actionTarget, gchatMessage);
            }
        }
        catch (Exception e) {
            String message = CatalogExceptionMessage.eventPublisherFailedToPublish(SubscriptionDestination.SubscriptionType.G_CHAT, event, e.getMessage());
            LOG.error(message);
            throw new EventPublisherException(message, (Pair<UUID, ChangeEvent>)Pair.of((Object)this.subscriptionDestination.getId(), (Object)event));
        }
    }

    @Override
    public boolean getEnabled() {
        return this.subscriptionDestination.getEnabled();
    }

    @Override
    public void close() {
        if (null != this.client) {
            this.client.close();
        }
    }

    @Override
    public SubscriptionDestination getSubscriptionDestination() {
        return this.subscriptionDestination;
    }
}

