/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.util.List;
import javax.json.JsonPatch;
import javax.json.JsonValue;
import javax.ws.rs.core.Response;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.openmetadata.schema.api.configuration.SlackAppConfiguration;
import org.openmetadata.schema.email.SmtpSettings;
import org.openmetadata.schema.entity.services.ingestionPipelines.PipelineServiceClientResponse;
import org.openmetadata.schema.services.connections.metadata.OpenMetadataConnection;
import org.openmetadata.schema.settings.Settings;
import org.openmetadata.schema.settings.SettingsType;
import org.openmetadata.schema.system.StepValidation;
import org.openmetadata.schema.system.ValidationResponse;
import org.openmetadata.schema.type.EventType;
import org.openmetadata.schema.util.EntitiesCount;
import org.openmetadata.schema.util.ServicesCount;
import org.openmetadata.sdk.PipelineServiceClient;
import org.openmetadata.service.Entity;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.exception.CustomExceptionMessage;
import org.openmetadata.service.fernet.Fernet;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.jdbi3.Repository;
import org.openmetadata.service.migration.MigrationValidationClient;
import org.openmetadata.service.resources.settings.SettingsCache;
import org.openmetadata.service.search.SearchRepository;
import org.openmetadata.service.security.JwtFilter;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.OpenMetadataConnectionBuilder;
import org.openmetadata.service.util.RestUtil;
import org.openmetadata.service.util.ResultList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Repository
public class SystemRepository {
    private static final Logger LOG = LoggerFactory.getLogger(SystemRepository.class);
    private static final String FAILED_TO_UPDATE_SETTINGS = "Failed to Update Settings";
    public static final String INTERNAL_SERVER_ERROR_WITH_REASON = "Internal Server Error. Reason :";
    private final CollectionDAO.SystemDAO dao = Entity.getCollectionDAO().systemDAO();
    private final MigrationValidationClient migrationValidationClient;
    private static final String INDEX_NAME = "table_search_index";

    public SystemRepository() {
        Entity.setSystemRepository(this);
        this.migrationValidationClient = MigrationValidationClient.getInstance();
    }

    public EntitiesCount getAllEntitiesCount(ListFilter filter) {
        return this.dao.getAggregatedEntitiesCount(filter.getCondition());
    }

    public ServicesCount getAllServicesCount(ListFilter filter) {
        return this.dao.getAggregatedServicesCount(filter.getCondition());
    }

    public ResultList<Settings> listAllConfigs() {
        List<Settings> settingsList = null;
        try {
            settingsList = this.dao.getAllConfig();
        }
        catch (Exception ex) {
            LOG.error("Error while trying fetch all Settings " + ex.getMessage());
        }
        int count = 0;
        if (settingsList != null) {
            count = settingsList.size();
        }
        return new ResultList<Settings>(settingsList, null, null, count);
    }

    public Settings getConfigWithKey(String key) {
        try {
            Settings fetchedSettings = this.dao.getConfigWithKey(key);
            if (fetchedSettings == null) {
                return null;
            }
            if (fetchedSettings.getConfigType() == SettingsType.EMAIL_CONFIGURATION) {
                SmtpSettings emailConfig = (SmtpSettings)fetchedSettings.getConfigValue();
                emailConfig.setPassword("***********");
                fetchedSettings.setConfigValue((Object)emailConfig);
            }
            return fetchedSettings;
        }
        catch (Exception ex) {
            LOG.error("Error while trying fetch Settings ", (Throwable)ex);
            return null;
        }
    }

    public Settings getEmailConfigInternal() {
        try {
            Settings setting = this.dao.getConfigWithKey(SettingsType.EMAIL_CONFIGURATION.value());
            SmtpSettings emailConfig = SystemRepository.decryptEmailSetting((SmtpSettings)setting.getConfigValue());
            setting.setConfigValue((Object)emailConfig);
            return setting;
        }
        catch (Exception ex) {
            LOG.error("Error while trying fetch EMAIL Settings " + ex.getMessage());
            return null;
        }
    }

    public Settings getSlackApplicationConfigInternal() {
        try {
            Settings setting = this.dao.getConfigWithKey(SettingsType.SLACK_APP_CONFIGURATION.value());
            SlackAppConfiguration slackAppConfiguration = SystemRepository.decryptSlackAppSetting((String)setting.getConfigValue());
            setting.setConfigValue((Object)slackAppConfiguration);
            return setting;
        }
        catch (Exception ex) {
            LOG.error("Error while trying fetch EMAIL Settings " + ex.getMessage());
            return null;
        }
    }

    @Transaction
    public Response createOrUpdate(Settings setting) {
        Settings oldValue = this.getConfigWithKey(setting.getConfigType().toString());
        try {
            this.updateSetting(setting);
        }
        catch (Exception ex) {
            LOG.error(FAILED_TO_UPDATE_SETTINGS + ex.getMessage());
            return Response.status((int)500, (String)(INTERNAL_SERVER_ERROR_WITH_REASON + ex.getMessage())).build();
        }
        if (oldValue == null) {
            return new RestUtil.PutResponse<Settings>(Response.Status.CREATED, setting, EventType.ENTITY_CREATED).toResponse();
        }
        return new RestUtil.PutResponse<Settings>(Response.Status.OK, setting, EventType.ENTITY_UPDATED).toResponse();
    }

    public Response createNewSetting(Settings setting) {
        try {
            this.updateSetting(setting);
        }
        catch (Exception ex) {
            LOG.error(FAILED_TO_UPDATE_SETTINGS + ex.getMessage());
            return Response.status((int)500, (String)(INTERNAL_SERVER_ERROR_WITH_REASON + ex.getMessage())).build();
        }
        return new RestUtil.PutResponse<Settings>(Response.Status.CREATED, setting, EventType.ENTITY_CREATED).toResponse();
    }

    public Response deleteSettings(SettingsType type) {
        Settings oldValue = this.getConfigWithKey(type.toString());
        this.dao.delete(type.value());
        return new RestUtil.DeleteResponse<Settings>(oldValue, EventType.ENTITY_DELETED).toResponse();
    }

    public Response patchSetting(String settingName, JsonPatch patch) {
        Settings original = this.getConfigWithKey(settingName);
        JsonValue updated = JsonUtils.applyPatch(original.getConfigValue(), patch);
        original.setConfigValue((Object)updated);
        try {
            this.updateSetting(original);
        }
        catch (Exception ex) {
            LOG.error(FAILED_TO_UPDATE_SETTINGS + ex.getMessage());
            return Response.status((int)500, (String)(INTERNAL_SERVER_ERROR_WITH_REASON + ex.getMessage())).build();
        }
        return new RestUtil.PutResponse<Settings>(Response.Status.OK, original, EventType.ENTITY_UPDATED).toResponse();
    }

    public void updateSetting(Settings setting) {
        try {
            if (setting.getConfigType() == SettingsType.EMAIL_CONFIGURATION) {
                SmtpSettings emailConfig = JsonUtils.convertValue(setting.getConfigValue(), SmtpSettings.class);
                setting.setConfigValue((Object)SystemRepository.encryptEmailSetting(emailConfig));
            } else if (setting.getConfigType() == SettingsType.SLACK_APP_CONFIGURATION) {
                SlackAppConfiguration appConfiguration = JsonUtils.convertValue(setting.getConfigValue(), SlackAppConfiguration.class);
                setting.setConfigValue((Object)SystemRepository.encryptSlackAppSetting(appConfiguration));
            }
            this.dao.insertSettings(setting.getConfigType().toString(), JsonUtils.pojoToJson(setting.getConfigValue()));
            SettingsCache.invalidateSettings(setting.getConfigType().value());
        }
        catch (Exception ex) {
            LOG.error("Failing in Updating Setting.", (Throwable)ex);
            throw new CustomExceptionMessage(Response.Status.INTERNAL_SERVER_ERROR, "FAILED_TO_UPDATE_SLACK_OR_EMAIL", ex.getMessage());
        }
    }

    public static SmtpSettings encryptEmailSetting(SmtpSettings decryptedSetting) {
        if (Fernet.getInstance().isKeyDefined()) {
            String encryptedPwd = Fernet.getInstance().encryptIfApplies(decryptedSetting.getPassword());
            return decryptedSetting.withPassword(encryptedPwd);
        }
        return decryptedSetting;
    }

    public static SmtpSettings decryptEmailSetting(SmtpSettings encryptedSetting) {
        if (Fernet.getInstance().isKeyDefined() && Fernet.isTokenized(encryptedSetting.getPassword())) {
            String decryptedPassword = Fernet.getInstance().decrypt(encryptedSetting.getPassword());
            return encryptedSetting.withPassword(decryptedPassword);
        }
        return encryptedSetting;
    }

    public static String encryptSlackAppSetting(SlackAppConfiguration decryptedSetting) {
        String json = JsonUtils.pojoToJson(decryptedSetting);
        if (Fernet.getInstance().isKeyDefined()) {
            return Fernet.getInstance().encryptIfApplies(json);
        }
        return json;
    }

    public static SlackAppConfiguration decryptSlackAppSetting(String encryptedSetting) {
        if (Fernet.getInstance().isKeyDefined()) {
            encryptedSetting = Fernet.getInstance().decryptIfApplies(encryptedSetting);
        }
        return JsonUtils.readValue(encryptedSetting, SlackAppConfiguration.class);
    }

    public ValidationResponse validateSystem(OpenMetadataApplicationConfig applicationConfig, PipelineServiceClient pipelineServiceClient, JwtFilter jwtFilter) {
        ValidationResponse validation = new ValidationResponse();
        validation.setDatabase(this.getDatabaseValidation());
        validation.setSearchInstance(this.getSearchValidation());
        validation.setPipelineServiceClient(this.getPipelineServiceClientValidation(pipelineServiceClient));
        validation.setJwks(this.getJWKsValidation(applicationConfig, jwtFilter));
        validation.setMigrations(this.getMigrationValidation(this.migrationValidationClient));
        return validation;
    }

    private StepValidation getDatabaseValidation() {
        try {
            this.dao.testConnection();
            return new StepValidation().withDescription(ValidationStepDescription.DATABASE.key).withPassed(Boolean.TRUE);
        }
        catch (Exception exc) {
            return new StepValidation().withDescription(ValidationStepDescription.DATABASE.key).withPassed(Boolean.FALSE).withMessage(exc.getMessage());
        }
    }

    private StepValidation getSearchValidation() {
        SearchRepository searchRepository = Entity.getSearchRepository();
        if (Boolean.TRUE.equals(searchRepository.getSearchClient().isClientAvailable()) && searchRepository.getSearchClient().indexExists(INDEX_NAME)) {
            return new StepValidation().withDescription(ValidationStepDescription.SEARCH.key).withPassed(Boolean.TRUE);
        }
        return new StepValidation().withDescription(ValidationStepDescription.SEARCH.key).withPassed(Boolean.FALSE).withMessage("Search instance is not reachable or available");
    }

    private StepValidation getPipelineServiceClientValidation(PipelineServiceClient pipelineServiceClient) {
        PipelineServiceClientResponse pipelineResponse = pipelineServiceClient.getServiceStatus();
        if (pipelineResponse.getCode() == 200) {
            return new StepValidation().withDescription(ValidationStepDescription.PIPELINE_SERVICE_CLIENT.key).withPassed(Boolean.TRUE);
        }
        return new StepValidation().withDescription(ValidationStepDescription.PIPELINE_SERVICE_CLIENT.key).withPassed(Boolean.FALSE).withMessage(pipelineResponse.getReason());
    }

    private StepValidation getJWKsValidation(OpenMetadataApplicationConfig applicationConfig, JwtFilter jwtFilter) {
        OpenMetadataConnection openMetadataServerConnection = new OpenMetadataConnectionBuilder(applicationConfig).build();
        try {
            jwtFilter.validateAndReturnDecodedJwtToken(openMetadataServerConnection.getSecurityConfig().getJwtToken());
            return new StepValidation().withDescription(ValidationStepDescription.JWT_TOKEN.key).withPassed(Boolean.TRUE);
        }
        catch (Exception e) {
            return new StepValidation().withDescription(ValidationStepDescription.JWT_TOKEN.key).withPassed(Boolean.FALSE).withMessage(e.getMessage());
        }
    }

    private StepValidation getMigrationValidation(MigrationValidationClient migrationValidationClient) {
        List<String> currentVersions = migrationValidationClient.getCurrentVersions();
        if (currentVersions.equals(migrationValidationClient.getExpectedMigrationList())) {
            return new StepValidation().withDescription(ValidationStepDescription.MIGRATION.key).withPassed(Boolean.TRUE);
        }
        return new StepValidation().withDescription(ValidationStepDescription.MIGRATION.key).withPassed(Boolean.FALSE).withMessage(String.format("Found the versions [%s], but expected [%s]", currentVersions, migrationValidationClient.getExpectedMigrationList()));
    }

    private static enum ValidationStepDescription {
        DATABASE("Validate that we can properly run a query against the configured database."),
        SEARCH("Validate that the search client is available."),
        PIPELINE_SERVICE_CLIENT("Validate that the pipeline service client is available."),
        JWT_TOKEN("Validate that the ingestion-bot JWT token can be properly decoded."),
        MIGRATION("Validate that all the necessary migrations have been properly executed.");

        public final String key;

        private ValidationStepDescription(String param) {
            this.key = param;
        }
    }
}

