/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.util.List;
import java.util.UUID;
import org.openmetadata.schema.TokenInterface;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.Repository;
import org.openmetadata.service.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Repository
public class TokenRepository {
    private static final Logger LOG = LoggerFactory.getLogger(TokenRepository.class);
    static final String TOKEN_NOT_PRESENT_MSG = "Token not present for the user";
    private final CollectionDAO dao = Entity.getCollectionDAO();

    public TokenInterface findByToken(String token) {
        TokenInterface result = this.dao.getTokenDAO().findByToken(token);
        if (result == null) {
            throw new EntityNotFoundException("Invalid Request Token. Please check your Token");
        }
        return result;
    }

    public List<TokenInterface> findByUserIdAndType(UUID userId, String type) {
        return this.dao.getTokenDAO().getAllUserTokenWithType(userId, type);
    }

    public void insertToken(TokenInterface tokenInterface) {
        this.dao.getTokenDAO().insert(JsonUtils.pojoToJson(tokenInterface));
    }

    public void deleteToken(String token) {
        try {
            this.dao.getTokenDAO().delete(token);
        }
        catch (Exception ex) {
            LOG.info(TOKEN_NOT_PRESENT_MSG);
        }
    }

    public void deleteAllToken(List<String> tokens) {
        try {
            this.dao.getTokenDAO().deleteAll(tokens);
        }
        catch (Exception ex) {
            LOG.info(TOKEN_NOT_PRESENT_MSG);
        }
    }

    public void deleteTokenByUserAndType(UUID userId, String type) {
        try {
            this.dao.getTokenDAO().deleteTokenByUserAndType(userId, type);
        }
        catch (Exception ex) {
            LOG.info(TOKEN_NOT_PRESENT_MSG);
        }
    }
}

