/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.security;

import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(value={"/api/v1/auth/logout"})
public class AuthLogoutServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(AuthLogoutServlet.class);
    private final String url;

    public AuthLogoutServlet(String url) {
        this.url = url;
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        try {
            LOG.debug("Performing application logout");
            HttpSession session = httpServletRequest.getSession(false);
            if (session != null) {
                LOG.debug("Invalidating the session for logout");
                session.invalidate();
                httpServletResponse.sendRedirect(this.url);
            } else {
                LOG.error("No session store available for this web context");
            }
        }
        catch (Exception ex) {
            LOG.error("[Auth Logout] Error while performing logout", (Throwable)ex);
        }
    }
}

