/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.security;

import com.auth0.jwk.Jwk;
import com.auth0.jwk.JwkException;
import com.auth0.jwk.JwkProvider;
import com.auth0.jwk.SigningKeyNotFoundException;
import com.auth0.jwk.UrlJwkProvider;
import java.net.URL;
import java.util.List;

final class MultiUrlJwkProvider
implements JwkProvider {
    private final List<UrlJwkProvider> urlJwkProviders;

    public MultiUrlJwkProvider(List<URL> publicKeyUris) {
        this.urlJwkProviders = publicKeyUris.stream().map(UrlJwkProvider::new).toList();
    }

    public Jwk get(String keyId) throws JwkException {
        SigningKeyNotFoundException lastException = new SigningKeyNotFoundException("JWT Token keyID doesn't match the configured keyID. This usually happens if you didn't configure proper publicKeyUrls under authentication configuration.", null);
        for (UrlJwkProvider jwkProvider : this.urlJwkProviders) {
            try {
                return jwkProvider.get(keyId);
            }
            catch (JwkException e) {
                lastException.addSuppressed((Throwable)e);
            }
        }
        throw lastException;
    }
}

