/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.util.incidentSeverityClassifier;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.api.configuration.dataQuality.DataQualityConfiguration;
import org.openmetadata.schema.tests.type.Severity;
import org.openmetadata.service.util.incidentSeverityClassifier.LogisticRegressionIncidentSeverityClassifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IncidentSeverityClassifierInterface {
    private static final Logger LOG = LoggerFactory.getLogger(IncidentSeverityClassifierInterface.class);
    protected static IncidentSeverityClassifierInterface instance;

    public static IncidentSeverityClassifierInterface getInstance() {
        if (instance == null) {
            LOG.info("Incident severity classifier instance is null. Default to LogisticRegressionClassifier");
            instance = new LogisticRegressionIncidentSeverityClassifier();
        }
        return instance;
    }

    public static void createInstance(DataQualityConfiguration dataQualityConfiguration) {
        instance = IncidentSeverityClassifierInterface.getClassifierClass(dataQualityConfiguration.getSeverityIncidentClassifier());
    }

    private static IncidentSeverityClassifierInterface getClassifierClass(String severityClassifierClassString) {
        IncidentSeverityClassifierInterface incidentSeverityClassifier;
        try {
            Class<?> severityClassifierClass = Class.forName(severityClassifierClassString);
            Constructor<?> severityClassifierConstructor = severityClassifierClass.getConstructor(new Class[0]);
            incidentSeverityClassifier = (IncidentSeverityClassifierInterface)severityClassifierConstructor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LOG.error("Error occurred while initializing the incident severity classifier. Default to LogisticRegressionClassifier", (Throwable)e);
            incidentSeverityClassifier = new LogisticRegressionIncidentSeverityClassifier();
        }
        return incidentSeverityClassifier;
    }

    public abstract Severity classifyIncidentSeverity(EntityInterface var1);
}

