/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.csv;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.schema.type.csv.CsvFile;
import org.openmetadata.schema.type.csv.CsvHeader;

public final class CsvUtil {
    public static final String SEPARATOR = ",";
    public static final String FIELD_SEPARATOR = ";";
    public static final String LINE_SEPARATOR = "\r\n";

    private CsvUtil() {
    }

    public static String formatCsv(CsvFile csvFile) throws IOException {
        StringWriter writer = new StringWriter();
        List<String> headers = CsvUtil.getHeaders(csvFile.getHeaders());
        CSVFormat csvFormat = CSVFormat.Builder.create((CSVFormat)CSVFormat.DEFAULT).setHeader(headers.toArray(new String[0])).build();
        try (CSVPrinter printer = new CSVPrinter((Appendable)writer, csvFormat);){
            for (List csvRecord : CommonUtil.listOrEmpty((List)csvFile.getRecords())) {
                printer.printRecord((Iterable)csvRecord);
            }
        }
        return writer.toString();
    }

    public static List<String> getHeaders(List<CsvHeader> csvHeaders) {
        ArrayList<String> headers = new ArrayList<String>();
        for (CsvHeader header : csvHeaders) {
            String headerString = header.getName();
            if (Boolean.TRUE.equals(header.getRequired())) {
                headerString = String.format("%s*", header.getName());
            }
            headers.add(headerString);
        }
        return headers;
    }

    public static String recordToString(CSVRecord csvRecord) {
        return CsvUtil.recordToString(csvRecord.toList());
    }

    public static String recordToString(List<String> fields) {
        return CommonUtil.nullOrEmpty(fields) ? "" : fields.stream().map(CsvUtil::quoteCsvField).collect(Collectors.joining(SEPARATOR));
    }

    public static String recordToString(String[] fields) {
        return CsvUtil.recordToString(Arrays.asList(fields));
    }

    public static List<String> fieldToStrings(String field) {
        return field == null ? null : CommonUtil.listOf((Object[])field.split(FIELD_SEPARATOR));
    }

    public static String quote(String field) {
        return String.format("\"%s\"", field);
    }

    public static String quoteField(List<String> field) {
        return CommonUtil.nullOrEmpty(field) ? "" : field.stream().map(CsvUtil::quoteCsvField).collect(Collectors.joining(FIELD_SEPARATOR));
    }

    public static void addField(List<String> csvRecord, Boolean field) {
        csvRecord.add(field == null ? "" : field.toString());
    }

    public static List<String> addField(List<String> csvRecord, String field) {
        csvRecord.add(field);
        return csvRecord;
    }

    public static List<String> addFieldList(List<String> csvRecord, List<String> field) {
        csvRecord.add(CsvUtil.quoteField(field));
        return csvRecord;
    }

    public static List<String> addEntityReferences(List<String> csvRecord, List<EntityReference> refs) {
        csvRecord.add(CommonUtil.nullOrEmpty(refs) ? null : refs.stream().map(EntityReference::getFullyQualifiedName).collect(Collectors.joining(FIELD_SEPARATOR)));
        return csvRecord;
    }

    public static List<String> addEntityReference(List<String> csvRecord, EntityReference ref) {
        csvRecord.add(CommonUtil.nullOrEmpty((Object)ref) ? null : ref.getFullyQualifiedName());
        return csvRecord;
    }

    public static List<String> addTagLabels(List<String> csvRecord, List<TagLabel> tags) {
        csvRecord.add(CommonUtil.nullOrEmpty(tags) ? null : tags.stream().map(TagLabel::getTagFQN).collect(Collectors.joining(FIELD_SEPARATOR)));
        return csvRecord;
    }

    public static void addOwner(List<String> csvRecord, EntityReference owner) {
        csvRecord.add(CommonUtil.nullOrEmpty((Object)owner) ? null : owner.getType() + FIELD_SEPARATOR + owner.getName());
    }

    public static void addUserOwner(List<String> csvRecord, EntityReference owner) {
        csvRecord.add(CommonUtil.nullOrEmpty((Object)owner) ? null : owner.getName());
    }

    private static String quoteCsvField(String str) {
        if (str.contains(SEPARATOR) || str.contains(FIELD_SEPARATOR)) {
            return CsvUtil.quote(str);
        }
        return str;
    }
}

