/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.dataInsight;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.openmetadata.schema.dataInsight.type.DailyActiveUsers;
import org.openmetadata.service.dataInsight.DataInsightAggregatorInterface;

public abstract class DailyActiveUsersAggregator<A, H, B>
implements DataInsightAggregatorInterface {
    private final A aggregations;

    protected DailyActiveUsersAggregator(A aggregations) {
        this.aggregations = aggregations;
    }

    @Override
    public List<Object> aggregate() throws ParseException {
        H histogramBucket = this.getHistogramBucket(this.aggregations);
        ArrayList<Object> data = new ArrayList<Object>();
        for (B bucket : this.getBuckets(histogramBucket)) {
            String dateTimeString = this.getKeyAsString(bucket);
            Long timestamp = this.convertDatTimeStringToTimestamp(dateTimeString);
            long activeUsers = this.getDocCount(bucket);
            data.add(new DailyActiveUsers().withTimestamp(timestamp).withActiveUsers(Integer.valueOf((int)activeUsers)));
        }
        return data;
    }

    protected abstract H getHistogramBucket(A var1);

    protected abstract List<? extends B> getBuckets(H var1);

    protected abstract String getKeyAsString(B var1);

    protected abstract Long getDocCount(B var1);
}

