/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.formatter.entity;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.PipelineStatus;
import org.openmetadata.schema.type.FieldChange;
import org.openmetadata.service.formatter.decorators.MessageDecorator;
import org.openmetadata.service.formatter.entity.EntityFormatter;
import org.openmetadata.service.formatter.util.FormatterUtil;
import org.openmetadata.service.util.JsonUtils;

public class PipelineFormatter
implements EntityFormatter {
    private static final String PIPELINE_STATUS_FIELD = "pipelineStatus";

    @Override
    public String format(MessageDecorator<?> messageFormatter, FieldChange fieldChange, EntityInterface entity, FormatterUtil.CHANGE_TYPE changeType) {
        if (PIPELINE_STATUS_FIELD.equals(fieldChange.getName())) {
            return this.transformPipelineStatus(messageFormatter, fieldChange, entity);
        }
        return FormatterUtil.transformMessage(messageFormatter, fieldChange, entity, changeType);
    }

    private String transformPipelineStatus(MessageDecorator<?> messageFormatter, FieldChange fieldChange, EntityInterface entity) {
        String pipelineName = entity.getName();
        PipelineStatus status = JsonUtils.readOrConvertValue(fieldChange.getNewValue(), PipelineStatus.class);
        if (status != null) {
            String date = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss").format(new Date(status.getTimestamp()));
            String format = String.format("Pipeline %s %s at %s", messageFormatter.getBold(), messageFormatter.getBold(), date);
            return String.format(format, pipelineName, status.getExecutionStatus());
        }
        String format = String.format("Pipeline %s is updated", messageFormatter.getBold());
        return String.format(format, pipelineName);
    }
}

