/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.api.feed.ResolveTask;
import org.openmetadata.schema.entity.data.Topic;
import org.openmetadata.schema.entity.services.MessagingService;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Field;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.schema.type.TaskType;
import org.openmetadata.schema.type.topic.TopicSampleData;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.jdbi3.FeedRepository;
import org.openmetadata.service.resources.feeds.MessageParser;
import org.openmetadata.service.resources.tags.TagLabelUtil;
import org.openmetadata.service.security.mask.PIIMasker;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;
import org.openmetadata.service.util.JsonUtils;

public class TopicRepository
extends EntityRepository<Topic> {
    public TopicRepository() {
        super("v1/topics/", "topic", Topic.class, Entity.getCollectionDAO().topicDAO(), "", "");
        this.supportsSearch = true;
    }

    @Override
    public void setFullyQualifiedName(Topic topic) {
        topic.setFullyQualifiedName(FullyQualifiedName.add(topic.getService().getFullyQualifiedName(), topic.getName()));
        if (topic.getMessageSchema() != null) {
            this.setFieldFQN(topic.getFullyQualifiedName(), topic.getMessageSchema().getSchemaFields());
        }
    }

    @Override
    public void prepare(Topic topic, boolean update) {
        MessagingService messagingService = (MessagingService)Entity.getEntity(topic.getService(), "", Include.ALL);
        topic.setService(messagingService.getEntityReference());
        topic.setServiceType(messagingService.getServiceType());
    }

    @Override
    public void storeEntity(Topic topic, boolean update) {
        EntityReference service = topic.getService();
        topic.withService(null);
        List fieldsWithTags = null;
        if (topic.getMessageSchema() != null) {
            fieldsWithTags = topic.getMessageSchema().getSchemaFields();
            topic.getMessageSchema().setSchemaFields(this.cloneWithoutTags(fieldsWithTags));
            topic.getMessageSchema().getSchemaFields().forEach(field -> field.setTags(null));
        }
        this.store(topic, update);
        if (fieldsWithTags != null) {
            topic.getMessageSchema().withSchemaFields(fieldsWithTags);
        }
        topic.withService(service);
    }

    @Override
    public void storeRelationships(Topic topic) {
        this.addServiceRelationship(topic, topic.getService());
    }

    @Override
    public void setFields(Topic topic, EntityUtil.Fields fields) {
        topic.setService(this.getContainer(topic.getId()));
        if (topic.getMessageSchema() != null) {
            Entity.populateEntityFieldTags(this.entityType, topic.getMessageSchema().getSchemaFields(), topic.getFullyQualifiedName(), fields.contains("tags"));
        }
    }

    @Override
    public void clearFields(Topic topic, EntityUtil.Fields fields) {
    }

    public TopicUpdater getUpdater(Topic original, Topic updated, EntityRepository.Operation operation) {
        return new TopicUpdater(original, updated, operation);
    }

    public Topic getSampleData(UUID topicId, boolean authorizePII) {
        Topic topic = (Topic)this.find(topicId, Include.NON_DELETED);
        TopicSampleData sampleData = JsonUtils.readValue(this.daoCollection.entityExtensionDAO().getExtension(topic.getId(), "topic.sampleData"), TopicSampleData.class);
        topic.setSampleData(sampleData);
        this.setFieldsInternal(topic, EntityUtil.Fields.EMPTY_FIELDS);
        if (!authorizePII) {
            Entity.populateEntityFieldTags(this.entityType, topic.getMessageSchema().getSchemaFields(), topic.getFullyQualifiedName(), true);
            topic.setTags(this.getTags(topic));
            return PIIMasker.getSampleData(topic);
        }
        return topic;
    }

    public Topic addSampleData(UUID topicId, TopicSampleData sampleData) {
        Topic topic = (Topic)this.daoCollection.topicDAO().findEntityById(topicId);
        this.daoCollection.entityExtensionDAO().insert(topicId, "topic.sampleData", "topicSampleData", JsonUtils.pojoToJson(sampleData));
        this.setFieldsInternal(topic, EntityUtil.Fields.EMPTY_FIELDS);
        return topic.withSampleData(sampleData);
    }

    private void setFieldFQN(String parentFQN, List<Field> fields) {
        fields.forEach(c -> {
            String fieldFqn = FullyQualifiedName.add(parentFQN, c.getName());
            c.setFullyQualifiedName(fieldFqn);
            if (c.getChildren() != null) {
                this.setFieldFQN(fieldFqn, c.getChildren());
            }
        });
    }

    List<Field> cloneWithoutTags(List<Field> fields) {
        if (CommonUtil.nullOrEmpty(fields)) {
            return fields;
        }
        ArrayList<Field> copy = new ArrayList<Field>();
        fields.forEach(f -> copy.add(this.cloneWithoutTags((Field)f)));
        return copy;
    }

    private Field cloneWithoutTags(Field field) {
        List<Field> children = this.cloneWithoutTags(field.getChildren());
        return new Field().withDescription(field.getDescription()).withName(field.getName()).withDisplayName(field.getDisplayName()).withFullyQualifiedName(field.getFullyQualifiedName()).withDataType(field.getDataType()).withDataTypeDisplay(field.getDataTypeDisplay()).withChildren(children);
    }

    private void validateSchemaFieldTags(List<Field> fields) {
        for (Field field : fields) {
            this.validateTags(field.getTags());
            field.setTags(TagLabelUtil.addDerivedTags(field.getTags()));
            TagLabelUtil.checkMutuallyExclusive(field.getTags());
            if (field.getChildren() == null) continue;
            this.validateSchemaFieldTags(field.getChildren());
        }
    }

    @Override
    private void applyTags(List<Field> fields) {
        for (Field field : fields) {
            this.applyTags(field.getTags(), field.getFullyQualifiedName());
            if (field.getChildren() == null) continue;
            this.applyTags(field.getChildren());
        }
    }

    @Override
    public void applyTags(Topic topic) {
        super.applyTags(topic);
        if (topic.getMessageSchema() != null) {
            this.applyTags(topic.getMessageSchema().getSchemaFields());
        }
    }

    @Override
    public EntityInterface getParentEntity(Topic entity, String fields) {
        return (EntityInterface)Entity.getEntity(entity.getService(), fields, Include.ALL);
    }

    @Override
    public void validateTags(Topic entity) {
        super.validateTags(entity);
        if (entity.getMessageSchema() != null) {
            this.validateSchemaFieldTags(entity.getMessageSchema().getSchemaFields());
        }
    }

    @Override
    public List<TagLabel> getAllTags(EntityInterface entity) {
        ArrayList<TagLabel> allTags = new ArrayList<TagLabel>();
        Topic topic = (Topic)entity;
        EntityUtil.mergeTags(allTags, topic.getTags());
        List schemaFields = topic.getMessageSchema() != null ? topic.getMessageSchema().getSchemaFields() : null;
        for (Field schemaField : CommonUtil.listOrEmpty((List)schemaFields)) {
            EntityUtil.mergeTags(allTags, schemaField.getTags());
        }
        return allTags;
    }

    @Override
    public FeedRepository.TaskWorkflow getTaskWorkflow(FeedRepository.ThreadContext threadContext) {
        this.validateTaskThread(threadContext);
        MessageParser.EntityLink entityLink = threadContext.getAbout();
        if (entityLink.getFieldName().equals("messageSchema")) {
            TaskType taskType = threadContext.getThread().getTask().getType();
            if (EntityUtil.isDescriptionTask(taskType)) {
                return new MessageSchemaDescriptionWorkflow(threadContext);
            }
            if (EntityUtil.isTagTask(taskType)) {
                return new MessageSchemaTagWorkflow(threadContext);
            }
            throw new IllegalArgumentException(String.format("Invalid task type %s", taskType));
        }
        return super.getTaskWorkflow(threadContext);
    }

    private static Field getSchemaField(Topic topic, String schemaName) {
        String childrenSchemaName = "";
        if (schemaName.contains(".")) {
            String fieldNameWithoutQuotes = schemaName.substring(1, schemaName.length() - 1);
            schemaName = fieldNameWithoutQuotes.substring(0, fieldNameWithoutQuotes.indexOf("."));
            childrenSchemaName = fieldNameWithoutQuotes.substring(fieldNameWithoutQuotes.lastIndexOf(".") + 1);
        }
        Field schemaField = null;
        for (Field field : topic.getMessageSchema().getSchemaFields()) {
            if (!field.getName().equals(schemaName)) continue;
            schemaField = field;
            break;
        }
        if (!"".equals(childrenSchemaName) && schemaField != null) {
            schemaField = TopicRepository.getChildSchemaField(schemaField.getChildren(), childrenSchemaName);
        }
        if (schemaField == null) {
            throw new IllegalArgumentException(CatalogExceptionMessage.invalidFieldName("schema", schemaName));
        }
        return schemaField;
    }

    private static Field getChildSchemaField(List<Field> fields, String childrenSchemaName) {
        Field childrenSchemaField;
        block2: {
            childrenSchemaField = null;
            for (Field field : fields) {
                if (!field.getName().equals(childrenSchemaName)) continue;
                childrenSchemaField = field;
                break;
            }
            if (childrenSchemaField != null) break block2;
            for (Field field : fields) {
                if (field.getChildren() != null && (childrenSchemaField = TopicRepository.getChildSchemaField(field.getChildren(), childrenSchemaName)) != null) break;
            }
        }
        return childrenSchemaField;
    }

    public static Set<TagLabel> getAllFieldTags(Field field) {
        HashSet<TagLabel> tags = new HashSet<TagLabel>();
        if (!CommonUtil.listOrEmpty((List)field.getTags()).isEmpty()) {
            tags.addAll(field.getTags());
        }
        for (Field c : CommonUtil.listOrEmpty((List)field.getChildren())) {
            tags.addAll(TopicRepository.getAllFieldTags(c));
        }
        return tags;
    }

    public class TopicUpdater
    extends EntityRepository.EntityUpdater {
        public static final String FIELD_DATA_TYPE_DISPLAY = "dataTypeDisplay";

        public TopicUpdater(Topic original, Topic updated, EntityRepository.Operation operation) {
            super((EntityRepository)TopicRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        @Transaction
        public void entitySpecificUpdate() {
            this.recordChange("maximumMessageSize", ((Topic)this.original).getMaximumMessageSize(), ((Topic)this.updated).getMaximumMessageSize());
            this.recordChange("minimumInSyncReplicas", ((Topic)this.original).getMinimumInSyncReplicas(), ((Topic)this.updated).getMinimumInSyncReplicas());
            if (((Topic)this.updated).getPartitions() != null) {
                this.recordChange("partitions", ((Topic)this.original).getPartitions(), ((Topic)this.updated).getPartitions());
            }
            this.recordChange("replicationFactor", ((Topic)this.original).getReplicationFactor(), ((Topic)this.updated).getReplicationFactor());
            this.recordChange("retentionTime", ((Topic)this.original).getRetentionTime(), ((Topic)this.updated).getRetentionTime());
            this.recordChange("retentionSize", ((Topic)this.original).getRetentionSize(), ((Topic)this.updated).getRetentionSize());
            if (((Topic)this.updated).getMessageSchema() != null) {
                this.recordChange("messageSchema.schemaText", ((Topic)this.original).getMessageSchema() == null ? null : ((Topic)this.original).getMessageSchema().getSchemaText(), ((Topic)this.updated).getMessageSchema().getSchemaText());
                this.recordChange("messageSchema.schemaType", ((Topic)this.original).getMessageSchema() == null ? null : ((Topic)this.original).getMessageSchema().getSchemaType(), ((Topic)this.updated).getMessageSchema().getSchemaType());
                this.updateSchemaFields("messageSchema.schemaFields", ((Topic)this.original).getMessageSchema() == null ? null : ((Topic)this.original).getMessageSchema().getSchemaFields(), ((Topic)this.updated).getMessageSchema().getSchemaFields(), EntityUtil.schemaFieldMatch);
            }
            this.recordChange("topicConfig", ((Topic)this.original).getTopicConfig(), ((Topic)this.updated).getTopicConfig());
            this.updateCleanupPolicies((Topic)this.original, (Topic)this.updated);
            this.recordChange("sourceUrl", ((Topic)this.original).getSourceUrl(), ((Topic)this.updated).getSourceUrl());
            this.recordChange("sourceHash", ((Topic)this.original).getSourceHash(), ((Topic)this.updated).getSourceHash());
        }

        private void updateCleanupPolicies(Topic original, Topic updated) {
            ArrayList added = new ArrayList();
            ArrayList deleted = new ArrayList();
            this.recordListChange("cleanupPolicies", original.getCleanupPolicies(), updated.getCleanupPolicies(), added, deleted, Enum::equals);
        }

        private void updateSchemaFields(String fieldName, List<Field> origFields, List<Field> updatedFields, BiPredicate<Field, Field> fieldMatch) {
            ArrayList deletedFields = new ArrayList();
            ArrayList addedFields = new ArrayList();
            this.recordListChange(fieldName, origFields, updatedFields, addedFields, deletedFields, fieldMatch);
            Map addedFieldMap = addedFields.stream().collect(Collectors.toMap(Field::getName, Function.identity()));
            for (Field deleted2 : deletedFields) {
                if (!addedFieldMap.containsKey(deleted2.getName())) continue;
                Field addedField = (Field)addedFieldMap.get(deleted2.getName());
                if (CommonUtil.nullOrEmpty((String)addedField.getDescription()) && CommonUtil.nullOrEmpty((String)deleted2.getDescription())) {
                    addedField.setDescription(deleted2.getDescription());
                }
                if (!CommonUtil.nullOrEmpty((List)addedField.getTags()) || !CommonUtil.nullOrEmpty((List)deleted2.getTags())) continue;
                addedField.setTags(deleted2.getTags());
            }
            deletedFields.forEach(deleted -> TopicRepository.this.daoCollection.tagUsageDAO().deleteTagsByTarget(deleted.getFullyQualifiedName()));
            for (Field added : addedFields) {
                TopicRepository.this.applyTags(added.getTags(), added.getFullyQualifiedName());
            }
            for (Field updated : updatedFields) {
                Field stored = origFields.stream().filter(c -> fieldMatch.test((Field)c, updated)).findAny().orElse(null);
                if (stored == null) continue;
                this.updateFieldDescription(stored, updated);
                this.updateFieldDataTypeDisplay(stored, updated);
                this.updateFieldDisplayName(stored, updated);
                this.updateTags(stored.getFullyQualifiedName(), EntityUtil.getFieldName(fieldName, updated.getName(), "tags"), stored.getTags(), updated.getTags());
                if (updated.getChildren() == null || stored.getChildren() == null) continue;
                String childrenFieldName = EntityUtil.getFieldName(fieldName, updated.getName());
                this.updateSchemaFields(childrenFieldName, stored.getChildren(), updated.getChildren(), fieldMatch);
            }
            this.majorVersionChange = this.majorVersionChange || !deletedFields.isEmpty();
        }

        private void updateFieldDescription(Field origField, Field updatedField) {
            if (this.operation.isPut() && !CommonUtil.nullOrEmpty((String)origField.getDescription()) && this.updatedByBot()) {
                updatedField.setDescription(origField.getDescription());
                return;
            }
            String field = EntityUtil.getSchemaField((Topic)this.original, origField, "description");
            this.recordChange(field, origField.getDescription(), updatedField.getDescription());
        }

        private void updateFieldDisplayName(Field origField, Field updatedField) {
            if (this.operation.isPut() && !CommonUtil.nullOrEmpty((String)origField.getDescription()) && this.updatedByBot()) {
                updatedField.setDisplayName(origField.getDisplayName());
                return;
            }
            String field = EntityUtil.getSchemaField((Topic)this.original, origField, "displayName");
            this.recordChange(field, origField.getDisplayName(), updatedField.getDisplayName());
        }

        private void updateFieldDataTypeDisplay(Field origField, Field updatedField) {
            if (this.operation.isPut() && !CommonUtil.nullOrEmpty((String)origField.getDataTypeDisplay()) && this.updatedByBot()) {
                updatedField.setDataTypeDisplay(origField.getDataTypeDisplay());
                return;
            }
            String field = EntityUtil.getSchemaField((Topic)this.original, origField, FIELD_DATA_TYPE_DISPLAY);
            this.recordChange(field, origField.getDataTypeDisplay(), updatedField.getDataTypeDisplay());
        }
    }

    static class MessageSchemaDescriptionWorkflow
    extends EntityRepository.DescriptionTaskWorkflow {
        private final Field schemaField;

        MessageSchemaDescriptionWorkflow(FeedRepository.ThreadContext threadContext) {
            super(threadContext);
            this.schemaField = TopicRepository.getSchemaField((Topic)threadContext.getAboutEntity(), threadContext.getAbout().getArrayFieldName());
        }

        @Override
        public EntityInterface performTask(String user, ResolveTask resolveTask) {
            this.schemaField.setDescription(resolveTask.getNewValue());
            return this.threadContext.getAboutEntity();
        }
    }

    static class MessageSchemaTagWorkflow
    extends EntityRepository.TagTaskWorkflow {
        private final Field schemaField;

        MessageSchemaTagWorkflow(FeedRepository.ThreadContext threadContext) {
            super(threadContext);
            this.schemaField = TopicRepository.getSchemaField((Topic)threadContext.getAboutEntity(), threadContext.getAbout().getArrayFieldName());
        }

        @Override
        public EntityInterface performTask(String user, ResolveTask resolveTask) {
            List<TagLabel> tags = JsonUtils.readObjects(resolveTask.getNewValue(), TagLabel.class);
            this.schemaField.setTags(tags);
            return this.threadContext.getAboutEntity();
        }
    }
}

