/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openmetadata.schema.entity.services.MlModelService;
import org.openmetadata.service.search.SearchIndexUtils;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;
import org.openmetadata.service.util.JsonUtils;

public record MlModelServiceIndex(MlModelService mlModelService) implements SearchIndex
{
    private static final List<String> excludeFields = List.of("changeDescription");

    @Override
    public Map<String, Object> buildESDoc() {
        Map<String, Object> doc = JsonUtils.getMap(this.mlModelService);
        SearchIndexUtils.removeNonIndexableFields(doc, excludeFields);
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.mlModelService.getName()).weight(5).build());
        suggest.add(SearchSuggest.builder().input(this.mlModelService.getFullyQualifiedName()).weight(5).build());
        doc.put("fqnParts", this.getFQNParts(this.mlModelService.getFullyQualifiedName(), suggest.stream().map(SearchSuggest::getInput).toList()));
        doc.put("suggest", suggest);
        doc.put("entityType", "mlmodelService");
        doc.put("owner", this.getEntityWithDisplayName(this.mlModelService.getOwner()));
        doc.put("followers", SearchIndexUtils.parseFollowers(this.mlModelService.getFollowers()));
        return doc;
    }
}

