/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.security.auth;

import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.Provider;
import org.openmetadata.schema.api.security.AuthenticationConfiguration;
import org.openmetadata.service.security.AuthenticationException;
import org.openmetadata.service.security.auth.CatalogSecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class CatalogSecurityContextRequestFilter
implements ContainerRequestFilter {
    private static final Logger LOG = LoggerFactory.getLogger(CatalogSecurityContextRequestFilter.class);
    @Context
    private HttpServletRequest httpRequest;

    private CatalogSecurityContextRequestFilter() {
    }

    public CatalogSecurityContextRequestFilter(AuthenticationConfiguration authenticationConfiguration) {
    }

    public void filter(ContainerRequestContext requestContext) {
        Principal principal = this.httpRequest.getUserPrincipal();
        String scheme = requestContext.getUriInfo().getRequestUri().getScheme();
        LOG.debug("Method: {}, AuthType: {}, RemoteUser: {}, UserPrincipal: {}, Scheme: {}", new Object[]{this.httpRequest.getMethod(), this.httpRequest.getAuthType(), this.httpRequest.getRemoteUser(), principal, scheme});
        if (principal == null) {
            throw new AuthenticationException("Not authorized. Principal is not available");
        }
        CatalogSecurityContext securityContext = new CatalogSecurityContext(principal, scheme, this.httpRequest.getAuthType());
        LOG.debug("SecurityContext {}", (Object)securityContext);
        requestContext.setSecurityContext((SecurityContext)securityContext);
    }
}

