/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.util;

import java.util.ArrayList;
import java.util.List;

public record AsciiTable(List<String> columns, List<List<String>> rows, boolean printHeader, String nullText, String emptyText) {
    private static final String DEFAULT_COLUMN_NAME = "(No column name)";
    private static final String DEFAULT_NO_VALUE = "-";

    public AsciiTable(List<String> columns, List<List<String>> rows, boolean printHeader, String nullText, String emptyText) {
        this.columns = AsciiTable.ensureValidColumns(columns);
        this.rows = rows;
        this.printHeader = printHeader;
        this.nullText = nullText;
        this.emptyText = emptyText;
    }

    private static List<String> ensureValidColumns(List<String> columns) {
        ArrayList<String> validColumns = new ArrayList<String>();
        for (String column : columns) {
            validColumns.add(column != null ? column : DEFAULT_COLUMN_NAME);
        }
        return validColumns;
    }

    public String render() {
        ArrayList<Integer> widths = new ArrayList<Integer>();
        for (String string : this.columns) {
            widths.add(string.length());
        }
        for (List list : this.rows) {
            for (int i = 0; i < list.size(); ++i) {
                widths.set(i, Math.max((Integer)widths.get(i), this.getValue(list, i).length()));
            }
        }
        StringBuilder ruler = new StringBuilder("+");
        for (Integer width : widths) {
            ruler.append(DEFAULT_NO_VALUE).append(this.trimOrPad("", width, '-')).append("-+");
        }
        ruler.append("\n");
        StringBuilder stringBuilder = new StringBuilder();
        if (this.printHeader) {
            StringBuilder header = new StringBuilder("|");
            for (int i = 0; i < widths.size(); ++i) {
                header.append(" ").append(this.trimOrPad(this.columns.get(i), (Integer)widths.get(i), ' ')).append(" |");
            }
            header.append("\n");
            stringBuilder.append((CharSequence)ruler);
            stringBuilder.append((CharSequence)header);
        }
        stringBuilder.append((CharSequence)ruler);
        if (this.rows.isEmpty()) {
            stringBuilder.append("| ").append(this.trimOrPad(this.emptyText, ruler.length() - Math.min(ruler.length(), 5))).append(" |\n");
        } else {
            for (List<String> row : this.rows) {
                StringBuilder r = new StringBuilder("|");
                for (int i = 0; i < widths.size(); ++i) {
                    r.append(" ").append(this.trimOrPad(this.getValue(row, i), (Integer)widths.get(i), ' ')).append(" |");
                }
                r.append("\n");
                stringBuilder.append((CharSequence)r);
            }
        }
        stringBuilder.append((CharSequence)ruler);
        return stringBuilder.toString();
    }

    private String getValue(List<String> row, int i) {
        try {
            String value = row.get(i);
            if (value == null) {
                value = this.nullText;
            }
            return value;
        }
        catch (IndexOutOfBoundsException e) {
            return DEFAULT_NO_VALUE;
        }
    }

    private String trimOrPad(String str, int length, char padChar) {
        StringBuilder result = str == null ? new StringBuilder() : new StringBuilder(str);
        if (result.length() > length) {
            return result.substring(0, length);
        }
        while (result.length() < length) {
            result.append(padChar);
        }
        return result.toString();
    }

    private String trimOrPad(String str, int length) {
        return this.trimOrPad(str, length, ' ');
    }
}

