/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.events;

import java.util.Optional;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.core.SecurityContext;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.service.Entity;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.events.EventHandler;
import org.openmetadata.service.formatter.util.FormatterUtil;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.WebsocketNotificationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeEventHandler
implements EventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ChangeEventHandler.class);
    private final WebsocketNotificationHandler websocketNotificationHandler = new WebsocketNotificationHandler();

    @Override
    public void init(OpenMetadataApplicationConfig config) {
    }

    @Override
    public Void process(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        if (requestContext.getMethod().equals("GET") || responseContext.getEntity() == null) {
            return null;
        }
        this.websocketNotificationHandler.processNotifications(responseContext);
        SecurityContext securityContext = requestContext.getSecurityContext();
        String loggedInUserName = securityContext.getUserPrincipal().getName();
        try {
            Optional<ChangeEvent> optionalChangeEvent = FormatterUtil.getChangeEventFromResponseContext(responseContext, loggedInUserName);
            if (optionalChangeEvent.isPresent()) {
                ChangeEvent changeEvent = optionalChangeEvent.get();
                if (changeEvent.getEntityType().equals("query")) {
                    return null;
                }
                changeEvent.setUserName(loggedInUserName);
                LOG.debug("Recording change event {}:{}:{}:{}", new Object[]{changeEvent.getTimestamp(), changeEvent.getEntityId(), changeEvent.getEventType(), changeEvent.getEntityType()});
                if (changeEvent.getEntity() != null) {
                    Object entity = changeEvent.getEntity();
                    changeEvent = ChangeEventHandler.copyChangeEvent(changeEvent);
                    changeEvent.setEntity((Object)JsonUtils.pojoToMaskedJson(entity));
                }
                Entity.getCollectionDAO().changeEventDAO().insert(JsonUtils.pojoToJson(changeEvent));
            }
        }
        catch (Exception e) {
            LOG.error("Failed to capture the change event for method {} due to ", (Object)requestContext.getMethod(), (Object)e);
        }
        return null;
    }

    private static ChangeEvent copyChangeEvent(ChangeEvent changeEvent) {
        return new ChangeEvent().withId(changeEvent.getId()).withEventType(changeEvent.getEventType()).withEntityId(changeEvent.getEntityId()).withEntityType(changeEvent.getEntityType()).withUserName(changeEvent.getUserName()).withTimestamp(changeEvent.getTimestamp()).withChangeDescription(changeEvent.getChangeDescription()).withCurrentVersion(changeEvent.getCurrentVersion());
    }

    @Override
    public void close() {
    }
}

