/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.formatter.field;

import java.util.ArrayList;
import java.util.Set;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;
import javax.json.stream.JsonParsingException;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.entity.feed.FeedInfo;
import org.openmetadata.schema.entity.feed.Thread;
import org.openmetadata.schema.type.FieldChange;
import org.openmetadata.service.formatter.decorators.MessageDecorator;
import org.openmetadata.service.formatter.field.FieldFormatter;
import org.openmetadata.service.formatter.util.FormatterUtil;
import org.openmetadata.service.resources.feeds.MessageParser;
import org.openmetadata.service.util.JsonUtils;

public class DefaultFieldFormatter
implements FieldFormatter {
    protected final Thread thread;
    protected String fieldChangeName;
    protected FieldChange fieldChange;
    protected final String fieldOldValue;
    protected final String fieldNewValue;
    protected final MessageDecorator<?> messageDecorator;

    public DefaultFieldFormatter(MessageDecorator<?> messageDecorator, Thread thread, FieldChange fieldChange) {
        this.messageDecorator = messageDecorator;
        this.fieldChangeName = DefaultFieldFormatter.getFieldNameChange(fieldChange.getName(), thread);
        this.fieldOldValue = DefaultFieldFormatter.getFieldValue(fieldChange.getOldValue());
        this.fieldNewValue = DefaultFieldFormatter.getFieldValue(fieldChange.getNewValue());
        this.thread = thread;
        this.fieldChange = fieldChange;
    }

    @Override
    public String getFieldChangeName() {
        return this.fieldChangeName;
    }

    @Override
    public String getFieldOldValue() {
        return this.fieldOldValue;
    }

    @Override
    public String getFieldNewValue() {
        return this.fieldNewValue;
    }

    @Override
    public String getFormattedMessage(FormatterUtil.CHANGE_TYPE changeType) {
        String message = "";
        switch (changeType) {
            case ADD: {
                message = this.formatAddedField();
                break;
            }
            case UPDATE: {
                message = this.formatUpdatedField();
                break;
            }
            case DELETE: {
                message = this.formatDeletedField();
            }
        }
        return message;
    }

    @Override
    public MessageDecorator<?> getMessageDecorator() {
        return this.messageDecorator;
    }

    @Override
    public MessageParser.EntityLink getEntityLink() {
        return MessageParser.EntityLink.parse(this.thread.getAbout());
    }

    @Override
    public String formatAddedField() {
        Object message = this.messageDecorator.httpAddMarker() + this.fieldNewValue + this.messageDecorator.httpAddMarker();
        message = String.format("Added " + this.messageDecorator.getBold() + ": %s", this.fieldChangeName, message);
        String spanAdd = this.messageDecorator.getAddMarker();
        String spanAddClose = this.messageDecorator.getAddMarkerClose();
        if (message != null) {
            message = this.messageDecorator.replaceMarkers((String)message, this.messageDecorator.httpAddMarker(), spanAdd, spanAddClose);
        }
        return message;
    }

    @Override
    public String formatUpdatedField() {
        String message = this.messageDecorator.getPlaintextDiff(this.fieldOldValue, this.fieldNewValue);
        message = String.format("Updated %s: %s", this.messageDecorator.getBold(), message);
        return String.format(message, this.fieldChangeName);
    }

    @Override
    public String formatDeletedField() {
        Object message = this.messageDecorator.httpRemoveMarker() + this.fieldOldValue + this.messageDecorator.httpRemoveMarker();
        message = String.format("Deleted " + this.messageDecorator.getBold() + ": %s", this.fieldChangeName, message);
        String spanRemove = this.messageDecorator.getRemoveMarker();
        String spanRemoveClose = this.messageDecorator.getRemoveMarkerClose();
        if (message != null) {
            message = this.messageDecorator.replaceMarkers((String)message, this.messageDecorator.httpRemoveMarker(), spanRemove, spanRemoveClose);
        }
        return message;
    }

    public static void populateThreadFeedInfo(Thread thread, String threadMessage, Thread.CardStyle cardStyle, Thread.FieldOperation operation, FeedInfo feedInfo) {
        thread.withMessage(threadMessage);
        thread.withCardStyle(cardStyle);
        thread.withFieldOperation(operation);
        thread.withFeedInfo(feedInfo);
    }

    public static String getFieldValue(Object fieldValue) {
        if (CommonUtil.nullOrEmpty((Object)fieldValue)) {
            return "";
        }
        try {
            JsonValue json = JsonUtils.readJson(fieldValue.toString());
            if (json.getValueType() == JsonValue.ValueType.ARRAY) {
                JsonArray jsonArray = json.asJsonArray();
                ArrayList<String> labels = new ArrayList<String>();
                for (JsonValue item : jsonArray) {
                    if (item.getValueType() == JsonValue.ValueType.OBJECT) {
                        Set keys = item.asJsonObject().keySet();
                        if (keys.contains("tagFQN")) {
                            labels.add(item.asJsonObject().getString("tagFQN"));
                            continue;
                        }
                        if (keys.contains("displayName")) {
                            labels.add(item.asJsonObject().getString("displayName"));
                            continue;
                        }
                        if (keys.contains("name")) {
                            labels.add(item.asJsonObject().getString("name"));
                            continue;
                        }
                        if (!keys.contains("constraintType")) continue;
                        labels.add(item.asJsonObject().getString("constraintType"));
                        continue;
                    }
                    if (item.getValueType() != JsonValue.ValueType.STRING) continue;
                    String label = item.toString().replaceAll("^\"|\"$", "");
                    labels.add(label.strip());
                }
                return String.join((CharSequence)", ", labels);
            }
            if (json.getValueType() == JsonValue.ValueType.OBJECT) {
                JsonObject jsonObject = json.asJsonObject();
                Set keys = jsonObject.asJsonObject().keySet();
                if (keys.contains("displayName")) {
                    return jsonObject.asJsonObject().getString("displayName");
                }
                if (keys.contains("name")) {
                    return jsonObject.asJsonObject().getString("name");
                }
            }
        }
        catch (JsonParsingException jsonParsingException) {
            // empty catch block
        }
        return fieldValue.toString();
    }

    public static String getFieldNameChange(String fieldChangeName, Thread thread) {
        MessageParser.EntityLink link = FormatterUtil.getEntityLinkForFieldName(fieldChangeName, thread);
        String arrayFieldName = link.getArrayFieldName();
        String arrayFieldValue = link.getArrayFieldValue();
        String updatedField = fieldChangeName;
        if (arrayFieldValue != null) {
            updatedField = String.format("%s.%s", arrayFieldName, arrayFieldValue);
        } else if (arrayFieldName != null) {
            if (arrayFieldName.equals("extension")) {
                return arrayFieldName;
            }
            updatedField = String.format("%s.%s", fieldChangeName, arrayFieldName);
        }
        return updatedField;
    }
}

