/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.openmetadata.schema.analytics.ReportData;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.jdbi3.locator.ConnectionAwareSqlQuery;
import org.openmetadata.service.jdbi3.locator.ConnectionAwareSqlQueryContainer;
import org.openmetadata.service.jdbi3.locator.ConnectionAwareSqlUpdate;
import org.openmetadata.service.jdbi3.locator.ConnectionAwareSqlUpdateContainer;
import org.openmetadata.service.jdbi3.locator.ConnectionType;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.jdbi.BindFQN;

public interface EntityTimeSeriesDAO {
    public String getTimeSeriesTableName();

    default public String getPartitionFieldName() {
        return "entityFQNHash";
    }

    @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="INSERT INTO <table>(entityFQNHash, extension, jsonSchema, json) VALUES (:entityFQNHash, :extension, :jsonSchema, :json)", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="INSERT INTO <table>(entityFQNHash, extension, jsonSchema, json) VALUES (:entityFQNHash, :extension, :jsonSchema, (:json :: jsonb))", connectionType=ConnectionType.POSTGRES)})
    public void insert(@Define(value="table") String var1, @BindFQN(value="entityFQNHash") String var2, @Bind(value="extension") String var3, @Bind(value="jsonSchema") String var4, @Bind(value="json") String var5);

    default public void insert(String entityFQNHash, String extension, String jsonSchema, String json) {
        this.insert(this.getTimeSeriesTableName(), entityFQNHash, extension, jsonSchema, json);
    }

    @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="INSERT INTO <table>(entityFQNHash, jsonSchema, json) VALUES (:entityFQNHash, :jsonSchema, :json)", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="INSERT INTO <table>(entityFQNHash, jsonSchema, json) VALUES (:entityFQNHash, :jsonSchema, (:json :: jsonb))", connectionType=ConnectionType.POSTGRES)})
    public void insertWithoutExtension(@Define(value="table") String var1, @BindFQN(value="entityFQNHash") String var2, @Bind(value="jsonSchema") String var3, @Bind(value="json") String var4);

    default public void insert(String entityFQNHash, String jsonSchema, String json) {
        this.insertWithoutExtension(this.getTimeSeriesTableName(), entityFQNHash, jsonSchema, json);
    }

    @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="UPDATE <table> set json = :json where entityFQNHash=:entityFQNHash and extension=:extension and timestamp=:timestamp", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="UPDATE <table> set json = (:json :: jsonb) where entityFQNHash=:entityFQNHash and extension=:extension and timestamp=:timestamp", connectionType=ConnectionType.POSTGRES)})
    public void update(@Define(value="table") String var1, @BindFQN(value="entityFQNHash") String var2, @Bind(value="extension") String var3, @Bind(value="json") String var4, @Bind(value="timestamp") Long var5);

    default public void update(String entityFQNHash, String extension, String json, Long timestamp) {
        this.update(this.getTimeSeriesTableName(), entityFQNHash, extension, json, timestamp);
    }

    @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="UPDATE <table> set json = :json where id=:id", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="UPDATE <table> set json = (:json :: jsonb) where id=:id", connectionType=ConnectionType.POSTGRES)})
    public void update(@Define(value="table") String var1, @Bind(value="json") String var2, @Bind(value="id") String var3);

    default public void update(String json, UUID id) {
        this.update(this.getTimeSeriesTableName(), json, id.toString());
    }

    @SqlQuery(value="SELECT json FROM <table> <cond> AND timestamp BETWEEN :startTs AND :endTs ORDER BY timestamp DESC LIMIT :limit OFFSET :offset")
    public List<String> listWithOffset(@Define(value="table") String var1, @Define(value="cond") String var2, @Bind(value="limit") int var3, @Bind(value="offset") int var4, @Bind(value="startTs") Long var5, @Bind(value="endTs") Long var6);

    @SqlQuery(value="SELECT json FROM (SELECT id, json, ROW_NUMBER() OVER(PARTITION BY <partition> ORDER BY timestamp DESC) AS row_num FROM <table> <cond> AND timestamp BETWEEN :startTs AND :endTs ORDER BY timestamp DESC) ranked WHERE ranked.row_num = 1 LIMIT :limit OFFSET :offset")
    public List<String> listWithOffset(@Define(value="table") String var1, @Define(value="cond") String var2, @Define(value="partition") String var3, @Bind(value="limit") int var4, @Bind(value="offset") int var5, @Bind(value="startTs") Long var6, @Bind(value="endTs") Long var7);

    default public List<String> listWithOffset(ListFilter filter, int limit, int offset, Long startTs, Long endTs, boolean latest) {
        return latest ? this.listWithOffset(this.getTimeSeriesTableName(), filter.getCondition(), this.getPartitionFieldName(), limit, offset, startTs, endTs) : this.listWithOffset(this.getTimeSeriesTableName(), filter.getCondition(), limit, offset, startTs, endTs);
    }

    @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="UPDATE <table> set json = :json where entityFQNHash=:entityFQNHash and extension=:extension and timestamp=:timestamp and json -> '$.operation' = :operation", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="UPDATE <table> set json = (:json :: jsonb) where entityFQNHash=:entityFQNHash and extension=:extension and timestamp=:timestamp and json #>>'{operation}' = :operation", connectionType=ConnectionType.POSTGRES)})
    public void updateExtensionByOperation(@Define(value="table") String var1, @BindFQN(value="entityFQNHash") String var2, @Bind(value="extension") String var3, @Bind(value="json") String var4, @Bind(value="timestamp") Long var5, @Bind(value="operation") String var6);

    default public void updateExtensionByOperation(String entityFQNHash, String extension, String json, Long timestamp, String operation) {
        this.updateExtensionByOperation(this.getTimeSeriesTableName(), entityFQNHash, extension, json, timestamp, operation);
    }

    @SqlQuery(value="SELECT json FROM <table> WHERE entityFQNHash = :entityFQNHash AND extension = :extension")
    public String getExtension(@Define(value="table") String var1, @BindFQN(value="entityFQNHash") String var2, @Bind(value="extension") String var3);

    default public String getExtension(String entityId, String extension) {
        return this.getExtension(this.getTimeSeriesTableName(), entityId, extension);
    }

    @SqlQuery(value="SELECT count(*) FROM <table> <cond>")
    public int listCount(@Define(value="table") String var1, @Define(value="cond") String var2);

    default public int listCount(ListFilter filter) {
        return this.listCount(this.getTimeSeriesTableName(), filter.getCondition());
    }

    @SqlQuery(value="SELECT count(*) FROM <table> <cond> AND timestamp BETWEEN :startTs AND :endTs")
    public int listCount(@Define(value="table") String var1, @Define(value="cond") String var2, @Bind(value="startTs") Long var3, @Bind(value="endTs") Long var4);

    @SqlQuery(value="SELECT count(*) FROM (SELECT id, ROW_NUMBER() OVER(PARTITION BY <partition> ORDER BY timestamp DESC) AS row_num FROM <table> <cond> AND timestamp BETWEEN :startTs AND :endTs) ranked WHERE ranked.row_num = 1")
    public int listCount(@Define(value="table") String var1, @Define(value="partition") String var2, @Define(value="cond") String var3, @Bind(value="startTs") Long var4, @Bind(value="endTs") Long var5);

    default public int listCount(ListFilter filter, Long startTs, Long endTs, boolean latest) {
        return latest ? this.listCount(this.getTimeSeriesTableName(), this.getPartitionFieldName(), filter.getCondition(), startTs, endTs) : this.listCount(this.getTimeSeriesTableName(), filter.getCondition(), startTs, endTs);
    }

    @SqlQuery(value="SELECT json FROM <table> WHERE id = :id")
    public String getById(@Define(value="table") String var1, @Bind(value="id") String var2);

    default public String getById(UUID id) {
        return this.getById(this.getTimeSeriesTableName(), id.toString());
    }

    @SqlUpdate(value="DELETE from <table> WHERE id = :id")
    public void deleteById(@Define(value="table") String var1, @Bind(value="id") String var2);

    default public void deleteById(UUID id) {
        this.deleteById(this.getTimeSeriesTableName(), id.toString());
    }

    @SqlQuery(value="SELECT COUNT(DISTINCT entityFQN) FROM <table>")
    @Deprecated(since="1.1.1")
    public int listDistinctCount(@Define(value="table") String var1);

    default public void listDistinctCount() {
        this.listDistinctCount(this.getTimeSeriesTableName());
    }

    @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="WITH data AS (SELECT ROW_NUMBER() OVER(ORDER BY timestamp ASC) AS row_num, json FROM <table> WHERE entityFQNHash = :entityFQNHash) SELECT row_num, json FROM data WHERE row_num > :after LIMIT :limit", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="WITH data AS (SELECT ROW_NUMBER() OVER(ORDER BY timestamp ASC) AS row_num, json FROM <table> WHERE entityFQNHash = :entityFQNHash) SELECT row_num, json FROM data WHERE row_num > (:after :: integer) LIMIT :limit", connectionType=ConnectionType.POSTGRES)})
    @RegisterRowMapper(value=ReportDataMapper.class)
    public List<CollectionDAO.ReportDataRow> getAfterExtension(@Define(value="table") String var1, @BindFQN(value="entityFQNHash") String var2, @Bind(value="limit") int var3, @Bind(value="after") String var4);

    default public List<CollectionDAO.ReportDataRow> getAfterExtension(String entityFQNHash, int limit, String after) {
        return this.getAfterExtension(this.getTimeSeriesTableName(), entityFQNHash, limit, after);
    }

    @SqlQuery(value="SELECT json FROM <table> WHERE entityFQNHash = :entityFQNHash AND extension = :extension AND timestamp = :timestamp")
    public String getExtensionAtTimestamp(@Define(value="table") String var1, @BindFQN(value="entityFQNHash") String var2, @Bind(value="extension") String var3, @Bind(value="timestamp") long var4);

    default public String getExtensionAtTimestamp(String entityFQNHash, String extension, long timestamp) {
        return this.getExtensionAtTimestamp(this.getTimeSeriesTableName(), entityFQNHash, extension, timestamp);
    }

    @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT json FROM <table> WHERE entityFQNHash = :entityFQNHash AND extension = :extension AND timestamp = :timestamp AND json -> '$.operation' = :operation", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT json FROM <table> WHERE entityFQNHash = :entityFQNHash AND extension = :extension AND timestamp = :timestamp AND json #>>'{operation}' = :operation", connectionType=ConnectionType.POSTGRES)})
    public String getExtensionAtTimestampWithOperation(@Define(value="table") String var1, @BindFQN(value="entityFQNHash") String var2, @Bind(value="extension") String var3, @Bind(value="timestamp") long var4, @Bind(value="operation") String var6);

    default public String getExtensionAtTimestampWithOperation(String entityFQNHash, String extension, long timestamp, String operation) {
        return this.getExtensionAtTimestampWithOperation(this.getTimeSeriesTableName(), entityFQNHash, extension, timestamp, operation);
    }

    @SqlQuery(value="SELECT json FROM <table> WHERE entityFQNHash = :entityFQNHash AND extension = :extension ORDER BY timestamp DESC LIMIT 1")
    public String getLatestExtension(@Define(value="table") String var1, @BindFQN(value="entityFQNHash") String var2, @Bind(value="extension") String var3);

    default public String getLatestExtension(String entityFQNHash, String extension) {
        return this.getLatestExtension(this.getTimeSeriesTableName(), entityFQNHash, extension);
    }

    @SqlQuery(value="SELECT json FROM <table> WHERE entityFQNHash = :entityFQNHash ORDER BY timestamp DESC LIMIT 1")
    public String getLatestRecord(@Define(value="table") String var1, @BindFQN(value="entityFQNHash") String var2);

    default public String getLatestRecord(String entityFQNHash) {
        return this.getLatestRecord(this.getTimeSeriesTableName(), entityFQNHash);
    }

    @SqlUpdate(value="DELETE FROM <table> WHERE entityFQNHash = :entityFQNHash AND extension = :extension")
    public void delete(@Define(value="table") String var1, @BindFQN(value="entityFQNHash") String var2, @Bind(value="extension") String var3);

    default public void delete(String entityFQNHash, String extension) {
        this.delete(this.getTimeSeriesTableName(), entityFQNHash, extension);
    }

    @SqlUpdate(value="DELETE FROM <table> WHERE entityFQNHash = :entityFQNHash AND extension = :extension AND timestamp = :timestamp")
    public void deleteAtTimestamp(@Define(value="table") String var1, @BindFQN(value="entityFQNHash") String var2, @Bind(value="extension") String var3, @Bind(value="timestamp") Long var4);

    default public void deleteAtTimestamp(String entityFQNHash, String extension, Long timestamp) {
        this.deleteAtTimestamp(this.getTimeSeriesTableName(), entityFQNHash, extension, timestamp);
    }

    @SqlUpdate(value="DELETE FROM <table> WHERE entityFQNHash = :entityFQNHash AND extension = :extension AND timestamp < :timestamp")
    public void deleteBeforeTimestamp(@Define(value="table") String var1, @BindFQN(value="entityFQNHash") String var2, @Bind(value="extension") String var3, @Bind(value="timestamp") Long var4);

    default public void deleteBeforeTimestamp(String entityFQNHash, String extension, Long timestamp) {
        this.deleteBeforeTimestamp(this.getTimeSeriesTableName(), entityFQNHash, extension, timestamp);
    }

    @SqlQuery(value="SELECT json FROM <table> where entityFQNHash = :entityFQNHash and extension = :extension  AND timestamp >= :startTs and timestamp <= :endTs ORDER BY timestamp DESC")
    public List<String> listBetweenTimestamps(@Define(value="table") String var1, @BindFQN(value="entityFQNHash") String var2, @Bind(value="extension") String var3, @Bind(value="startTs") Long var4, @Bind(value="endTs") long var5);

    default public List<String> listBetweenTimestamps(String entityFQNHash, String extension, Long startTs, long endTs) {
        return this.listBetweenTimestamps(this.getTimeSeriesTableName(), entityFQNHash, extension, startTs, endTs);
    }

    @SqlQuery(value="SELECT json FROM <table> where entityFQNHash = :entityFQNHash and extension = :extension  AND timestamp >= :startTs and timestamp <= :endTs ORDER BY timestamp <orderBy>")
    public List<String> listBetweenTimestampsByOrder(@Define(value="table") String var1, @BindFQN(value="entityFQNHash") String var2, @Bind(value="extension") String var3, @Bind(value="startTs") Long var4, @Bind(value="endTs") long var5, @Define(value="orderBy") OrderBy var7);

    default public List<String> listBetweenTimestampsByOrder(String entityFQNHash, String extension, Long startTs, long endTs, OrderBy orderBy) {
        return this.listBetweenTimestampsByOrder(this.getTimeSeriesTableName(), entityFQNHash, extension, startTs, endTs, orderBy);
    }

    @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="UPDATE <table> SET json = :json WHERE entityFQNHash = :entityFQNHash AND extension = :extension <mysqlCond>", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="UPDATE <table> SET json = (:json :: jsonb) WHERE entityFQNHash = :entityFQNHash AND extension = :extension <psqlCond>", connectionType=ConnectionType.POSTGRES)})
    public void updateExtensionByKeyInternal(@Define(value="table") String var1, @Bind(value="value") String var2, @BindFQN(value="entityFQNHash") String var3, @Bind(value="extension") String var4, @Bind(value="json") String var5, @Define(value="mysqlCond") String var6, @Define(value="psqlCond") String var7);

    default public void updateExtensionByKey(String key, String value, String entityFQN, String extension, String json) {
        String mysqlCond = String.format("AND JSON_UNQUOTE(JSON_EXTRACT(json, '$.%s')) = :value", key);
        String psqlCond = String.format("AND json->>'%s' = :value", key);
        this.updateExtensionByKeyInternal(this.getTimeSeriesTableName(), value, entityFQN, extension, json, mysqlCond, psqlCond);
    }

    @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT json from <table> WHERE entityFQNHash = :entityFQNHash AND extension = :extension <mysqlCond>", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT json from <table> WHERE entityFQNHash = :entityFQNHash AND extension = :extension <psqlCond>", connectionType=ConnectionType.POSTGRES)})
    public String getExtensionByKeyInternal(@Define(value="table") String var1, @Bind(value="value") String var2, @BindFQN(value="entityFQNHash") String var3, @Bind(value="extension") String var4, @Define(value="mysqlCond") String var5, @Define(value="psqlCond") String var6);

    default public String getExtensionByKey(String key, String value, String entityFQN, String extension) {
        String mysqlCond = String.format("AND JSON_UNQUOTE(JSON_EXTRACT(json, '$.%s')) = :value", key);
        String psqlCond = String.format("AND json->>'%s' = :value", key);
        return this.getExtensionByKeyInternal(this.getTimeSeriesTableName(), value, entityFQN, extension, mysqlCond, psqlCond);
    }

    @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT json from <table> WHERE entityFQNHash = :entityFQNHash AND extension = :extension <mysqlCond> ORDER BY timestamp DESC LIMIT 1", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT json from <table> WHERE entityFQNHash = :entityFQNHash AND extension = :extension <psqlCond> ORDER BY timestamp DESC LIMIT 1", connectionType=ConnectionType.POSTGRES)})
    public String getLatestExtensionByKeyInternal(@Define(value="table") String var1, @Bind(value="value") String var2, @BindFQN(value="entityFQNHash") String var3, @Bind(value="extension") String var4, @Define(value="mysqlCond") String var5, @Define(value="psqlCond") String var6);

    default public String getLatestExtensionByKey(String key, String value, String entityFQN, String extension) {
        String mysqlCond = String.format("AND JSON_UNQUOTE(JSON_EXTRACT(json, '$.%s')) = :value", key);
        String psqlCond = String.format("AND json->>'%s' = :value", key);
        return this.getLatestExtensionByKeyInternal(this.getTimeSeriesTableName(), value, entityFQN, extension, mysqlCond, psqlCond);
    }

    default public void storeTimeSeriesWithOperation(String fqn, String extension, String jsonSchema, String entityJson, Long timestamp, String operation, boolean update) {
        if (update) {
            this.updateExtensionByOperation(fqn, extension, entityJson, timestamp, operation);
        } else {
            this.insert(fqn, extension, jsonSchema, entityJson);
        }
    }

    @SqlQuery(value="SELECT DISTINCT entityFQN FROM <table> WHERE entityFQNHash = '' or entityFQNHash is null LIMIT :limit")
    @Deprecated(since="1.1.1")
    public List<String> migrationListDistinctWithOffset(@Define(value="table") String var1, @Bind(value="limit") int var2);

    default public List<String> migrationListDistinctWithOffset(int limit) {
        return this.migrationListDistinctWithOffset(this.getTimeSeriesTableName(), limit);
    }

    public static enum OrderBy {
        ASC,
        DESC;

    }

    public static class ReportDataMapper
    implements RowMapper<CollectionDAO.ReportDataRow> {
        public CollectionDAO.ReportDataRow map(ResultSet rs, StatementContext ctx) throws SQLException {
            String rowNumber = rs.getString("row_num");
            String json = rs.getString("json");
            ReportData reportData = JsonUtils.readValue(json, ReportData.class);
            return new CollectionDAO.ReportDataRow(rowNumber, reportData);
        }
    }
}

