/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.openmetadata.schema.EntityTimeSeriesInterface;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.jdbi3.EntityTimeSeriesDAO;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.jdbi3.Repository;
import org.openmetadata.service.search.SearchRepository;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.RestUtil;
import org.openmetadata.service.util.ResultList;

@Repository
public abstract class EntityTimeSeriesRepository<T extends EntityTimeSeriesInterface> {
    protected final String collectionPath;
    protected final EntityTimeSeriesDAO timeSeriesDao;
    protected final SearchRepository searchRepository;
    protected final String entityType;
    protected final Class<T> entityClass;
    protected final CollectionDAO daoCollection;

    protected EntityTimeSeriesRepository(String collectionPath, EntityTimeSeriesDAO timeSeriesDao, Class<T> entityClass, String entityType) {
        this.collectionPath = collectionPath;
        this.timeSeriesDao = timeSeriesDao;
        this.entityClass = entityClass;
        this.entityType = entityType;
        this.searchRepository = Entity.getSearchRepository();
        this.daoCollection = Entity.getCollectionDAO();
        Entity.registerEntity(entityClass, entityType, this);
    }

    @Transaction
    public T createNewRecord(T recordEntity, String extension, String recordFQN) {
        recordEntity.setId(UUID.randomUUID());
        this.storeInternal(recordEntity, recordFQN, extension);
        this.storeRelationshipInternal(recordEntity);
        this.postCreate(recordEntity);
        return recordEntity;
    }

    public T createNewRecord(T recordEntity, String recordFQN) {
        recordEntity.setId(UUID.randomUUID());
        this.storeInternal(recordEntity, recordFQN);
        this.storeRelationshipInternal(recordEntity);
        this.postCreate(recordEntity);
        return recordEntity;
    }

    @Transaction
    protected void storeInternal(T recordEntity, String recordFQN) {
        this.timeSeriesDao.insert(recordFQN, this.entityType, JsonUtils.pojoToJson(recordEntity));
    }

    @Transaction
    protected void storeInternal(T recordEntity, String recordFQN, String extension) {
        this.timeSeriesDao.insert(recordFQN, extension, this.entityType, JsonUtils.pojoToJson(recordEntity));
    }

    protected void storeRelationshipInternal(T recordEntity) {
        this.storeRelationship(recordEntity);
    }

    protected void storeRelationship(T recordEntity) {
    }

    protected void setInheritedFields(T recordEntity) {
    }

    @Transaction
    public final void addRelationship(UUID fromId, UUID toId, String fromEntity, String toEntity, Relationship relationship, String json, boolean bidirectional) {
        UUID from = fromId;
        UUID to = toId;
        if (bidirectional && fromId.compareTo(toId) > 0) {
            from = toId;
            to = fromId;
        }
        this.daoCollection.relationshipDAO().insert(from, to, fromEntity, toEntity, relationship.ordinal(), json);
    }

    protected void postCreate(T recordEntity) {
        this.searchRepository.createTimeSeriesEntity((EntityTimeSeriesInterface)JsonUtils.deepCopy(recordEntity, this.entityClass));
    }

    protected void postDelete(T recordEntity) {
        this.searchRepository.deleteTimeSeriesEntityById((EntityTimeSeriesInterface)JsonUtils.deepCopy(recordEntity, this.entityClass));
    }

    public final List<CollectionDAO.EntityRelationshipRecord> findFromRecords(UUID toId, String toEntityType, Relationship relationship, String fromEntityType) {
        return fromEntityType == null ? this.daoCollection.relationshipDAO().findFrom(toId, toEntityType, relationship.ordinal()) : this.daoCollection.relationshipDAO().findFrom(toId, toEntityType, relationship.ordinal(), fromEntityType);
    }

    protected EntityReference getFromEntityRef(UUID toId, Relationship relationship, String fromEntityType, boolean mustHaveRelationship) {
        List<CollectionDAO.EntityRelationshipRecord> records = this.findFromRecords(toId, this.entityType, relationship, fromEntityType);
        EntityRepository.ensureSingleRelationship(this.entityType, toId, records, relationship.value(), fromEntityType, mustHaveRelationship);
        return !records.isEmpty() ? Entity.getEntityReferenceById(records.get(0).getType(), records.get(0).getId(), Include.ALL) : null;
    }

    public final ResultList<T> getResultList(List<T> entities, String beforeCursor, String afterCursor, int total) {
        return new ResultList<T>(entities, beforeCursor, afterCursor, total);
    }

    protected ResultList<T> listWithOffset(String offset, ListFilter filter, int limitParam, Long startTs, Long endTs, boolean latest) {
        String afterOffset;
        int total = this.timeSeriesDao.listCount(filter, startTs, endTs, latest);
        ArrayList<EntityTimeSeriesInterface> entityList = new ArrayList<EntityTimeSeriesInterface>();
        int offsetInt = offset != null ? Integer.parseInt(RestUtil.decodeCursor(offset)) : 0;
        int afterOffsetInt = offsetInt + limitParam;
        int beforeOffsetInt = offsetInt - limitParam;
        if (beforeOffsetInt < 0) {
            beforeOffsetInt = 0;
        }
        String beforeOffset = offsetInt == 0 ? null : String.valueOf(beforeOffsetInt);
        String string = afterOffset = afterOffsetInt >= total ? null : String.valueOf(afterOffsetInt);
        if (limitParam > 0) {
            List<String> jsons = this.timeSeriesDao.listWithOffset(filter, limitParam, offsetInt, startTs, endTs, latest);
            for (String json : jsons) {
                EntityTimeSeriesInterface recordEntity = (EntityTimeSeriesInterface)JsonUtils.readValue(json, this.entityClass);
                this.setInheritedFields(recordEntity);
                entityList.add(recordEntity);
            }
            return this.getResultList(entityList, beforeOffset, afterOffset, total);
        }
        return this.getResultList(entityList, null, null, total);
    }

    public ResultList<T> list(String offset, Long startTs, Long endTs, int limitParam, ListFilter filter, boolean latest) {
        return this.listWithOffset(offset, filter, limitParam, startTs, endTs, latest);
    }

    public T getLatestRecord(String recordFQN) {
        String jsonRecord = this.timeSeriesDao.getLatestRecord(recordFQN);
        if (jsonRecord == null) {
            return null;
        }
        EntityTimeSeriesInterface entityRecord = (EntityTimeSeriesInterface)JsonUtils.readValue(jsonRecord, this.entityClass);
        this.setInheritedFields(entityRecord);
        return (T)entityRecord;
    }

    public T getById(UUID id) {
        String jsonRecord = this.timeSeriesDao.getById(id);
        if (jsonRecord == null) {
            return null;
        }
        EntityTimeSeriesInterface entityRecord = (EntityTimeSeriesInterface)JsonUtils.readValue(jsonRecord, this.entityClass);
        this.setInheritedFields(entityRecord);
        return (T)entityRecord;
    }

    public void deleteById(UUID id, boolean hardDelete) {
        if (!hardDelete) {
            return;
        }
        T entityRecord = this.getById(id);
        if (entityRecord == null) {
            return;
        }
        this.timeSeriesDao.deleteById(id);
    }

    public String getCollectionPath() {
        return this.collectionPath;
    }

    public EntityTimeSeriesDAO getTimeSeriesDao() {
        return this.timeSeriesDao;
    }

    public SearchRepository getSearchRepository() {
        return this.searchRepository;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public Class<T> getEntityClass() {
        return this.entityClass;
    }

    public CollectionDAO getDaoCollection() {
        return this.daoCollection;
    }
}

