/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.json.JsonPatch;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.api.AddGlossaryToAssetsRequest;
import org.openmetadata.schema.api.feed.CloseTask;
import org.openmetadata.schema.api.feed.ResolveTask;
import org.openmetadata.schema.entity.data.Glossary;
import org.openmetadata.schema.entity.data.GlossaryTerm;
import org.openmetadata.schema.entity.feed.Thread;
import org.openmetadata.schema.type.ApiStatus;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.ProviderType;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.schema.type.TaskDetails;
import org.openmetadata.schema.type.TaskStatus;
import org.openmetadata.schema.type.TaskType;
import org.openmetadata.schema.type.ThreadType;
import org.openmetadata.schema.type.api.BulkOperationResult;
import org.openmetadata.schema.type.api.BulkResponse;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.jdbi3.FeedRepository;
import org.openmetadata.service.resources.feeds.FeedResource;
import org.openmetadata.service.resources.feeds.MessageParser;
import org.openmetadata.service.resources.tags.TagLabelUtil;
import org.openmetadata.service.search.SearchRequest;
import org.openmetadata.service.security.AuthorizationException;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.WebsocketNotificationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlossaryTermRepository
extends EntityRepository<GlossaryTerm> {
    private static final Logger LOG = LoggerFactory.getLogger(GlossaryTermRepository.class);
    private static final String ES_MISSING_DATA = "Entity Details is unavailable in Elastic Search. Please reindex to get more Information.";
    private static final String UPDATE_FIELDS = "references,relatedTerms,synonyms";
    private static final String PATCH_FIELDS = "references,relatedTerms,synonyms";

    public GlossaryTermRepository() {
        super("v1/glossaryTerms/", "glossaryTerm", GlossaryTerm.class, Entity.getCollectionDAO().glossaryTermDAO(), "references,relatedTerms,synonyms", "references,relatedTerms,synonyms");
        this.supportsSearch = true;
        this.renameAllowed = true;
    }

    @Override
    public void setFields(GlossaryTerm entity, EntityUtil.Fields fields) {
        entity.withParent(this.getParent(entity)).withGlossary(this.getGlossary(entity));
        entity.setRelatedTerms(fields.contains("relatedTerms") ? this.getRelatedTerms(entity) : entity.getRelatedTerms());
        entity.withUsageCount(fields.contains("usageCount") ? this.getUsageCount(entity) : entity.getUsageCount());
        entity.withChildrenCount(fields.contains("childrenCount") ? this.getChildrenCount(entity) : entity.getChildrenCount());
    }

    @Override
    public void clearFields(GlossaryTerm entity, EntityUtil.Fields fields) {
        entity.setRelatedTerms(fields.contains("relatedTerms") ? entity.getRelatedTerms() : null);
        entity.withUsageCount(fields.contains("usageCount") ? entity.getUsageCount() : null);
        entity.withChildrenCount(fields.contains("childrenCount") ? entity.getChildrenCount() : null);
    }

    @Override
    public void setInheritedFields(GlossaryTerm glossaryTerm, EntityUtil.Fields fields) {
        EntityInterface parent = this.getParentEntity(glossaryTerm, "owner,domain,reviewers");
        this.inheritOwner(glossaryTerm, fields, parent);
        this.inheritDomain(glossaryTerm, fields, parent);
        this.inheritReviewers(glossaryTerm, fields, parent);
    }

    private Integer getUsageCount(GlossaryTerm term) {
        return this.daoCollection.tagUsageDAO().getTagCount(TagLabel.TagSource.GLOSSARY.ordinal(), term.getFullyQualifiedName());
    }

    private Integer getChildrenCount(GlossaryTerm term) {
        return this.daoCollection.relationshipDAO().findTo(term.getId(), "glossaryTerm", Relationship.CONTAINS.ordinal(), "glossaryTerm").size();
    }

    private List<EntityReference> getRelatedTerms(GlossaryTerm entity) {
        return this.findBoth(entity.getId(), "glossaryTerm", Relationship.RELATED_TO, "glossaryTerm");
    }

    @Override
    public void prepare(GlossaryTerm entity, boolean update) {
        GlossaryTerm parentTerm;
        List parentReviewers = null;
        GlossaryTerm glossaryTerm = parentTerm = entity.getParent() != null ? (GlossaryTerm)Entity.getEntity(entity.getParent().withType("glossaryTerm"), "owner,reviewers", Include.NON_DELETED) : null;
        if (parentTerm != null) {
            parentReviewers = parentTerm.getReviewers();
            entity.setParent(parentTerm.getEntityReference());
        }
        Glossary glossary = (Glossary)Entity.getEntity(entity.getGlossary(), "reviewers", Include.NON_DELETED);
        entity.setGlossary(glossary.getEntityReference());
        parentReviewers = parentReviewers != null ? parentReviewers : glossary.getReviewers();
        this.validateHierarchy(entity);
        EntityUtil.populateEntityReferences(entity.getRelatedTerms());
        EntityUtil.populateEntityReferences(entity.getReviewers());
        if (!update || entity.getStatus() == null) {
            entity.setStatus(!CommonUtil.nullOrEmpty((List)parentReviewers) ? GlossaryTerm.Status.DRAFT : GlossaryTerm.Status.APPROVED);
        }
    }

    @Override
    public void storeEntity(GlossaryTerm entity, boolean update) {
        EntityReference glossary = entity.getGlossary();
        EntityReference parentTerm = entity.getParent();
        List relatedTerms = entity.getRelatedTerms();
        List reviewers = entity.getReviewers();
        entity.withGlossary(null).withParent(null).withRelatedTerms(relatedTerms).withReviewers(null);
        this.store(entity, update);
        entity.withGlossary(glossary).withParent(parentTerm).withRelatedTerms(relatedTerms).withReviewers(reviewers);
    }

    @Override
    public void storeRelationships(GlossaryTerm entity) {
        this.addGlossaryRelationship(entity);
        this.addParentRelationship(entity);
        for (EntityReference relTerm : CommonUtil.listOrEmpty((List)entity.getRelatedTerms())) {
            this.addRelationship(entity.getId(), relTerm.getId(), "glossaryTerm", "glossaryTerm", Relationship.RELATED_TO, true);
        }
        for (EntityReference reviewer : CommonUtil.listOrEmpty((List)entity.getReviewers())) {
            this.addRelationship(reviewer.getId(), entity.getId(), "user", "glossaryTerm", Relationship.REVIEWS);
        }
    }

    @Override
    public void restorePatchAttributes(GlossaryTerm original, GlossaryTerm updated) {
        super.restorePatchAttributes(original, updated);
        updated.withChildren(original.getChildren());
    }

    @Override
    public void setFullyQualifiedName(GlossaryTerm entity) {
        if (entity.getParent() == null) {
            entity.setFullyQualifiedName(FullyQualifiedName.build(entity.getGlossary().getFullyQualifiedName(), entity.getName()));
        } else {
            EntityReference parent = entity.getParent();
            entity.setFullyQualifiedName(FullyQualifiedName.add(parent.getFullyQualifiedName(), entity.getName()));
        }
    }

    public BulkOperationResult bulkAddAndValidateGlossaryToAssets(UUID glossaryTermId, AddGlossaryToAssetsRequest request) {
        boolean dryRun = Boolean.TRUE.equals(request.getDryRun());
        GlossaryTerm term = (GlossaryTerm)this.get(null, glossaryTermId, this.getFields("id,tags"));
        TagLabelUtil.checkMutuallyExclusive(request.getGlossaryTags());
        BulkOperationResult result = new BulkOperationResult().withDryRun(Boolean.valueOf(dryRun));
        ArrayList<BulkResponse> failures = new ArrayList<BulkResponse>();
        ArrayList<BulkResponse> success = new ArrayList<BulkResponse>();
        if (dryRun && (CommonUtil.nullOrEmpty((List)request.getGlossaryTags()) || CommonUtil.nullOrEmpty((List)request.getAssets()))) {
            return result.withStatus(ApiStatus.SUCCESS).withSuccessRequest(List.of(new BulkResponse().withMessage("Nothing to Validate.")));
        }
        EntityUtil.populateEntityReferences(request.getAssets());
        TagLabel tagLabel = new TagLabel().withTagFQN(term.getFullyQualifiedName()).withSource(TagLabel.TagSource.GLOSSARY).withLabelType(TagLabel.LabelType.MANUAL);
        for (EntityReference ref : request.getAssets()) {
            result.setNumberOfRowsProcessed(Integer.valueOf(result.getNumberOfRowsProcessed() + 1));
            EntityRepository<? extends EntityInterface> entityRepository = Entity.getEntityRepository(ref.getType());
            EntityInterface asset = entityRepository.get(null, ref.getId(), entityRepository.getFields("tags"));
            try {
                Map<String, List<TagLabel>> allAssetTags = this.daoCollection.tagUsageDAO().getTagsByPrefix(asset.getFullyQualifiedName(), "%", true);
                TagLabelUtil.checkMutuallyExclusiveForParentAndSubField(asset.getFullyQualifiedName(), FullyQualifiedName.buildHash(asset.getFullyQualifiedName()), allAssetTags, request.getGlossaryTags(), false);
                success.add(new BulkResponse().withRequest((Object)ref));
                result.setNumberOfRowsPassed(Integer.valueOf(result.getNumberOfRowsPassed() + 1));
            }
            catch (Exception ex) {
                failures.add(new BulkResponse().withRequest((Object)ref).withMessage(ex.getMessage()));
                result.withFailedRequest(failures);
                result.setNumberOfRowsFailed(Integer.valueOf(result.getNumberOfRowsFailed() + 1));
            }
            if (dryRun || !CommonUtil.nullOrEmpty((List)result.getFailedRequest())) continue;
            ArrayList<TagLabel> tempList = new ArrayList<TagLabel>(asset.getTags());
            tempList.add(tagLabel);
            entityRepository.applyTags(TagLabelUtil.getUniqueTags(tempList), asset.getFullyQualifiedName());
            this.searchRepository.updateEntity(ref);
        }
        if (!(dryRun || !CommonUtil.nullOrEmpty((List)result.getFailedRequest()) || term.getTags().isEmpty() && request.getGlossaryTags().isEmpty())) {
            this.daoCollection.tagUsageDAO().deleteTagsByTarget(term.getFullyQualifiedName());
            this.applyTags(TagLabelUtil.getUniqueTags(request.getGlossaryTags()), term.getFullyQualifiedName());
            this.searchRepository.updateEntity(term.getEntityReference());
        }
        result.withFailedRequest(failures).withSuccessRequest(success);
        if (result.getNumberOfRowsPassed().equals(result.getNumberOfRowsProcessed())) {
            result.withStatus(ApiStatus.SUCCESS);
        } else if (result.getNumberOfRowsPassed() > 1) {
            result.withStatus(ApiStatus.PARTIAL_SUCCESS);
        } else {
            result.withStatus(ApiStatus.FAILURE);
        }
        return result;
    }

    public BulkOperationResult validateGlossaryTagsAddition(UUID glossaryTermId, AddGlossaryToAssetsRequest request) {
        GlossaryTerm term = (GlossaryTerm)this.get(null, glossaryTermId, this.getFields("id,tags"));
        List glossaryTagsToValidate = request.getGlossaryTags();
        TagLabelUtil.checkMutuallyExclusive(request.getGlossaryTags());
        BulkOperationResult result = new BulkOperationResult().withDryRun(Boolean.valueOf(true));
        ArrayList<BulkResponse> failures = new ArrayList<BulkResponse>();
        ArrayList<BulkResponse> success = new ArrayList<BulkResponse>();
        if (CommonUtil.nullOrEmpty((List)glossaryTagsToValidate)) {
            return result.withStatus(ApiStatus.SUCCESS).withSuccessRequest(List.of(new BulkResponse().withMessage("Nothing to Validate.")));
        }
        HashSet<String> targetFQNHashesFromDb = new HashSet<String>(this.daoCollection.tagUsageDAO().getTargetFQNHashForTag(term.getFullyQualifiedName()));
        Map<String, EntityReference> targetFQNFromES = this.getGlossaryUsageFromES(term.getFullyQualifiedName(), targetFQNHashesFromDb.size());
        for (String fqnHash : targetFQNHashesFromDb) {
            result.setNumberOfRowsProcessed(Integer.valueOf(result.getNumberOfRowsProcessed() + 1));
            Map<String, List<TagLabel>> allAssetTags = this.daoCollection.tagUsageDAO().getTagsByPrefix(fqnHash, "%", false);
            EntityReference refDetails = targetFQNFromES.get(fqnHash);
            try {
                TagLabelUtil.checkMutuallyExclusiveForParentAndSubField(term.getFullyQualifiedName(), fqnHash, allAssetTags, glossaryTagsToValidate, true);
                if (refDetails != null) {
                    success.add(new BulkResponse().withRequest((Object)refDetails));
                } else {
                    success.add(new BulkResponse().withRequest((Object)new EntityReference().withFullyQualifiedName(fqnHash).withType("unknown")).withMessage(ES_MISSING_DATA));
                }
                result.setNumberOfRowsPassed(Integer.valueOf(result.getNumberOfRowsPassed() + 1));
            }
            catch (IllegalArgumentException ex) {
                if (refDetails != null) {
                    failures.add(new BulkResponse().withRequest((Object)refDetails).withMessage(ex.getMessage()));
                } else {
                    failures.add(new BulkResponse().withRequest((Object)new EntityReference().withFullyQualifiedName(fqnHash).withType("unknown")).withMessage(String.format("%s %s", ex.getMessage(), ES_MISSING_DATA)));
                }
                result.setNumberOfRowsFailed(Integer.valueOf(result.getNumberOfRowsFailed() + 1));
            }
        }
        result.withFailedRequest(failures).withSuccessRequest(success);
        if (result.getNumberOfRowsPassed().equals(result.getNumberOfRowsProcessed())) {
            result.withStatus(ApiStatus.SUCCESS);
        } else if (result.getNumberOfRowsPassed() > 1) {
            result.withStatus(ApiStatus.PARTIAL_SUCCESS);
        } else {
            result.withStatus(ApiStatus.FAILURE);
        }
        return result;
    }

    private Map<String, EntityReference> getGlossaryUsageFromES(String glossaryFqn, int size) {
        try {
            String key = "_source";
            SearchRequest searchRequest = new SearchRequest.ElasticSearchRequestBuilder(String.format("** AND (tags.tagFQN:\"%s\")", glossaryFqn), size, "all").from(0).fetchSource(true).trackTotalHits(false).sortFieldParam("_score").deleted(false).sortOrder("desc").includeSourceFields(new ArrayList<String>()).build();
            Response response = this.searchRepository.search(searchRequest);
            String json = (String)response.getEntity();
            TreeSet<EntityReference> fqns = new TreeSet<EntityReference>(EntityUtil.compareEntityReferenceById);
            Iterator it = ((ArrayNode)JsonUtils.extractValue(json, "hits", "hits")).elements();
            while (it.hasNext()) {
                JsonNode jsonNode = (JsonNode)it.next();
                String id = (String)JsonUtils.extractValue(jsonNode, key, "id");
                String fqn = (String)JsonUtils.extractValue(jsonNode, key, "fullyQualifiedName");
                String type = (String)JsonUtils.extractValue(jsonNode, key, "entityType");
                if (CommonUtil.nullOrEmpty((String)fqn) || CommonUtil.nullOrEmpty((String)type)) continue;
                fqns.add(new EntityReference().withId(UUID.fromString(id)).withFullyQualifiedName(fqn).withType(type));
            }
            return fqns.stream().collect(Collectors.toMap(entityReference -> FullyQualifiedName.buildHash(entityReference.getFullyQualifiedName()), entityReference -> entityReference));
        }
        catch (Exception ex) {
            LOG.error("Error while getting glossary usage from ES for validation", (Throwable)ex);
            return new HashMap<String, EntityReference>();
        }
    }

    public BulkOperationResult bulkRemoveGlossaryToAssets(UUID glossaryTermId, AddGlossaryToAssetsRequest request) {
        GlossaryTerm term = (GlossaryTerm)this.get(null, glossaryTermId, this.getFields("id,tags"));
        BulkOperationResult result = new BulkOperationResult().withStatus(ApiStatus.SUCCESS).withDryRun(Boolean.valueOf(false));
        ArrayList<BulkResponse> success = new ArrayList<BulkResponse>();
        EntityUtil.populateEntityReferences(request.getAssets());
        for (EntityReference ref : request.getAssets()) {
            result.setNumberOfRowsProcessed(Integer.valueOf(result.getNumberOfRowsProcessed() + 1));
            EntityRepository<? extends EntityInterface> entityRepository = Entity.getEntityRepository(ref.getType());
            EntityInterface asset = entityRepository.get(null, ref.getId(), entityRepository.getFields("id"));
            this.daoCollection.tagUsageDAO().deleteTagsByTagAndTargetEntity(term.getFullyQualifiedName(), asset.getFullyQualifiedName());
            success.add(new BulkResponse().withRequest((Object)ref));
            result.setNumberOfRowsPassed(Integer.valueOf(result.getNumberOfRowsPassed() + 1));
            this.searchRepository.updateEntity(ref);
        }
        return result.withSuccessRequest(success);
    }

    protected EntityReference getGlossary(GlossaryTerm term) {
        Relationship relationship = term.getParent() != null ? Relationship.HAS : Relationship.CONTAINS;
        return term.getGlossary() != null ? term.getGlossary() : this.getFromEntityRef(term.getId(), relationship, "glossary", true);
    }

    public EntityReference getGlossary(String id) {
        return Entity.getEntityReferenceById("glossary", UUID.fromString(id), Include.ALL);
    }

    public GlossaryTermUpdater getUpdater(GlossaryTerm original, GlossaryTerm updated, EntityRepository.Operation operation) {
        return new GlossaryTermUpdater(original, updated, operation);
    }

    @Override
    protected void postCreate(GlossaryTerm entity) {
        super.postCreate(entity);
        if (entity.getStatus() == GlossaryTerm.Status.DRAFT) {
            this.createApprovalTask(entity, entity.getReviewers());
        }
    }

    @Override
    public void postUpdate(GlossaryTerm original, GlossaryTerm updated) {
        super.postUpdate(original, updated);
        if (original.getStatus() == GlossaryTerm.Status.DRAFT) {
            if (updated.getStatus() == GlossaryTerm.Status.APPROVED) {
                this.closeApprovalTask(updated, "Approved the glossary term");
            } else if (updated.getStatus() == GlossaryTerm.Status.REJECTED) {
                this.closeApprovalTask(updated, "Rejected the glossary term");
            }
        }
    }

    @Override
    protected void preDelete(GlossaryTerm entity, String deletedBy) {
        if (GlossaryTerm.Status.DRAFT.equals((Object)entity.getStatus())) {
            this.checkUpdatedByReviewer(entity, deletedBy);
        }
    }

    @Override
    protected void postDelete(GlossaryTerm entity) {
        this.daoCollection.tagUsageDAO().deleteTagLabels(TagLabel.TagSource.GLOSSARY.ordinal(), entity.getFullyQualifiedName());
    }

    @Override
    public FeedRepository.TaskWorkflow getTaskWorkflow(FeedRepository.ThreadContext threadContext) {
        this.validateTaskThread(threadContext);
        TaskType taskType = threadContext.getThread().getTask().getType();
        if (EntityUtil.isApprovalTask(taskType)) {
            return new ApprovalTaskWorkflow(threadContext);
        }
        return super.getTaskWorkflow(threadContext);
    }

    @Override
    public EntityInterface getParentEntity(GlossaryTerm entity, String fields) {
        return entity.getParent() != null ? (EntityInterface)Entity.getEntity(entity.getParent(), fields, Include.ALL) : (EntityInterface)Entity.getEntity(entity.getGlossary(), fields, Include.ALL);
    }

    private void addGlossaryRelationship(GlossaryTerm term) {
        Relationship relationship = term.getParent() != null ? Relationship.HAS : Relationship.CONTAINS;
        this.addRelationship(term.getGlossary().getId(), term.getId(), "glossary", "glossaryTerm", relationship);
    }

    private void addParentRelationship(GlossaryTerm term) {
        if (term.getParent() != null) {
            this.addRelationship(term.getParent().getId(), term.getId(), "glossaryTerm", "glossaryTerm", Relationship.CONTAINS);
        }
    }

    private void validateHierarchy(GlossaryTerm term) {
        if (term.getParent() == null) {
            return;
        }
        String glossaryFqn = FullyQualifiedName.build(term.getGlossary().getName());
        if (!term.getParent().getFullyQualifiedName().startsWith(glossaryFqn)) {
            throw new IllegalArgumentException(String.format("Invalid hierarchy - parent [%s] does not belong to glossary[%s]", term.getParent().getFullyQualifiedName(), term.getGlossary().getFullyQualifiedName()));
        }
    }

    private void checkUpdatedByReviewer(GlossaryTerm term, String updatedBy) {
        boolean isReviewer;
        List reviewers = term.getReviewers();
        if (!CommonUtil.nullOrEmpty((List)reviewers) && !(isReviewer = reviewers.stream().anyMatch(e -> e.getName().equals(updatedBy) || e.getFullyQualifiedName().equals(updatedBy)))) {
            throw new AuthorizationException(CatalogExceptionMessage.notReviewer(updatedBy));
        }
    }

    private void createApprovalTask(GlossaryTerm entity, List<EntityReference> parentReviewers) {
        TaskDetails taskDetails = new TaskDetails().withAssignees(FeedResource.formatAssignees(parentReviewers)).withType(TaskType.RequestApproval).withStatus(TaskStatus.Open);
        MessageParser.EntityLink about = new MessageParser.EntityLink(this.entityType, entity.getFullyQualifiedName());
        Thread thread = new Thread().withId(UUID.randomUUID()).withThreadTs(Long.valueOf(System.currentTimeMillis())).withMessage("Approval required for ").withCreatedBy(entity.getUpdatedBy()).withAbout(about.getLinkString()).withType(ThreadType.Task).withTask(taskDetails).withUpdatedBy(entity.getUpdatedBy()).withUpdatedAt(Long.valueOf(System.currentTimeMillis()));
        FeedRepository feedRepository = Entity.getFeedRepository();
        feedRepository.create(thread);
        WebsocketNotificationHandler.handleTaskNotification(thread);
    }

    private void closeApprovalTask(GlossaryTerm entity, String comment) {
        MessageParser.EntityLink about = new MessageParser.EntityLink("glossaryTerm", entity.getFullyQualifiedName());
        FeedRepository feedRepository = Entity.getFeedRepository();
        Thread taskThread = feedRepository.getTask(about, TaskType.RequestApproval);
        if (TaskStatus.Open.equals((Object)taskThread.getTask().getStatus())) {
            feedRepository.closeTask(taskThread, entity.getUpdatedBy(), new CloseTask().withComment(comment));
        }
    }

    public class GlossaryTermUpdater
    extends EntityRepository.EntityUpdater {
        public GlossaryTermUpdater(GlossaryTerm original, GlossaryTerm updated, EntityRepository.Operation operation) {
            super((EntityRepository)GlossaryTermRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        @Transaction
        public void entitySpecificUpdate() {
            this.validateParent();
            this.updateStatus((GlossaryTerm)this.original, (GlossaryTerm)this.updated);
            this.updateSynonyms((GlossaryTerm)this.original, (GlossaryTerm)this.updated);
            this.updateReferences((GlossaryTerm)this.original, (GlossaryTerm)this.updated);
            this.updateRelatedTerms((GlossaryTerm)this.original, (GlossaryTerm)this.updated);
            this.updateName((GlossaryTerm)this.original, (GlossaryTerm)this.updated);
            this.updateParent((GlossaryTerm)this.original, (GlossaryTerm)this.updated);
            ((GlossaryTerm)this.updated).setMutuallyExclusive(((GlossaryTerm)this.original).getMutuallyExclusive());
        }

        private boolean validateIfTagsAreEqual(List<TagLabel> originalTags, List<TagLabel> updatedTags) {
            Set originalTagsFqn = CommonUtil.listOrEmpty(originalTags).stream().map(TagLabel::getTagFQN).collect(Collectors.toCollection(TreeSet::new));
            Set updatedTagsFqn = CommonUtil.listOrEmpty(updatedTags).stream().map(TagLabel::getTagFQN).collect(Collectors.toCollection(TreeSet::new));
            return originalTagsFqn.equals(updatedTagsFqn);
        }

        @Override
        protected void updateTags(String fqn, String fieldName, List<TagLabel> origTags, List<TagLabel> updatedTags) {
            origTags = CommonUtil.listOrEmpty(origTags);
            updatedTags = Optional.ofNullable(updatedTags).orElse(new ArrayList());
            if (!(origTags.isEmpty() && updatedTags.isEmpty() || this.validateIfTagsAreEqual(origTags, updatedTags))) {
                List<String> targetFQNHashes = GlossaryTermRepository.this.daoCollection.tagUsageDAO().getTargetFQNHashForTag(fqn);
                for (String fqnHash : targetFQNHashes) {
                    Map<String, List<TagLabel>> allAssetTags = GlossaryTermRepository.this.daoCollection.tagUsageDAO().getTagsByPrefix(fqnHash, "%", false);
                    TagLabelUtil.checkMutuallyExclusiveForParentAndSubField("", fqnHash, allAssetTags, updatedTags, true);
                }
                GlossaryTermRepository.this.daoCollection.tagUsageDAO().deleteTagsByTarget(fqn);
                if (this.operation.isPut()) {
                    EntityUtil.mergeTags(updatedTags, origTags);
                    TagLabelUtil.checkMutuallyExclusive(updatedTags);
                }
                ArrayList addedTags = new ArrayList();
                ArrayList deletedTags = new ArrayList();
                this.recordListChange(fieldName, origTags, updatedTags, addedTags, deletedTags, EntityUtil.tagLabelMatch);
                updatedTags.sort(EntityUtil.compareTagLabel);
                GlossaryTermRepository.this.applyTags(updatedTags, fqn);
            }
        }

        private void updateStatus(GlossaryTerm origTerm, GlossaryTerm updatedTerm) {
            if (origTerm.getStatus() == updatedTerm.getStatus()) {
                return;
            }
            if (origTerm.getStatus() == GlossaryTerm.Status.DRAFT && (updatedTerm.getStatus() == GlossaryTerm.Status.APPROVED || updatedTerm.getStatus() == GlossaryTerm.Status.REJECTED)) {
                GlossaryTermRepository.this.checkUpdatedByReviewer(origTerm, updatedTerm.getUpdatedBy());
            }
            this.recordChange("status", origTerm.getStatus(), updatedTerm.getStatus());
        }

        private void updateSynonyms(GlossaryTerm origTerm, GlossaryTerm updatedTerm) {
            List origSynonyms = CommonUtil.listOrEmpty((List)origTerm.getSynonyms());
            List updatedSynonyms = CommonUtil.listOrEmpty((List)updatedTerm.getSynonyms());
            ArrayList added = new ArrayList();
            ArrayList deleted = new ArrayList();
            this.recordListChange("synonyms", origSynonyms, updatedSynonyms, added, deleted, EntityUtil.stringMatch);
        }

        private void updateReferences(GlossaryTerm origTerm, GlossaryTerm updatedTerm) {
            List origReferences = CommonUtil.listOrEmpty((List)origTerm.getReferences());
            List updatedReferences = CommonUtil.listOrEmpty((List)updatedTerm.getReferences());
            ArrayList added = new ArrayList();
            ArrayList deleted = new ArrayList();
            this.recordListChange("references", origReferences, updatedReferences, added, deleted, EntityUtil.termReferenceMatch);
        }

        private void updateRelatedTerms(GlossaryTerm origTerm, GlossaryTerm updatedTerm) {
            List origRelated = CommonUtil.listOrEmpty((List)origTerm.getRelatedTerms());
            List updatedRelated = CommonUtil.listOrEmpty((List)updatedTerm.getRelatedTerms());
            this.updateToRelationships("relatedTerms", "glossaryTerm", origTerm.getId(), Relationship.RELATED_TO, "glossaryTerm", origRelated, updatedRelated, true);
        }

        public void updateName(GlossaryTerm original, GlossaryTerm updated) {
            if (!original.getName().equals(updated.getName())) {
                if (ProviderType.SYSTEM.equals((Object)original.getProvider())) {
                    throw new IllegalArgumentException(CatalogExceptionMessage.systemEntityRenameNotAllowed(original.getName(), GlossaryTermRepository.this.entityType));
                }
                GlossaryTermRepository.this.setFullyQualifiedName(updated);
                LOG.info("Glossary term name changed from {} to {}", (Object)original.getName(), (Object)updated.getName());
                GlossaryTermRepository.this.daoCollection.glossaryTermDAO().updateFqn(original.getFullyQualifiedName(), updated.getFullyQualifiedName());
                GlossaryTermRepository.this.daoCollection.tagUsageDAO().rename(TagLabel.TagSource.GLOSSARY.ordinal(), original.getFullyQualifiedName(), updated.getFullyQualifiedName());
                this.recordChange("name", original.getName(), updated.getName());
                this.invalidateTerm(original.getId());
            }
        }

        private void updateParent(GlossaryTerm original, GlossaryTerm updated) {
            boolean glossaryChanged;
            UUID newParentId;
            UUID oldParentId = EntityUtil.getId(original.getParent());
            boolean parentChanged = !Objects.equals(oldParentId, newParentId = EntityUtil.getId(updated.getParent()));
            UUID oldGlossaryId = EntityUtil.getId(original.getGlossary());
            UUID newGlossaryId = EntityUtil.getId(updated.getGlossary());
            boolean bl = glossaryChanged = !Objects.equals(oldGlossaryId, newGlossaryId);
            if (!parentChanged && !glossaryChanged) {
                return;
            }
            GlossaryTermRepository.this.setFullyQualifiedName(updated);
            GlossaryTermRepository.this.daoCollection.glossaryTermDAO().updateFqn(original.getFullyQualifiedName(), updated.getFullyQualifiedName());
            GlossaryTermRepository.this.daoCollection.tagUsageDAO().rename(TagLabel.TagSource.GLOSSARY.ordinal(), original.getFullyQualifiedName(), updated.getFullyQualifiedName());
            if (glossaryChanged) {
                this.updateGlossaryRelationship(original, updated);
                this.recordChange("glossary", original.getGlossary(), updated.getGlossary(), true, EntityUtil.entityReferenceMatch);
                this.invalidateTerm(original.getId());
            }
            if (parentChanged) {
                this.updateGlossaryRelationship(original, updated);
                this.updateParentRelationship(original, updated);
                this.recordChange("parent", original.getParent(), updated.getParent(), true, EntityUtil.entityReferenceMatch);
                this.invalidateTerm(original.getId());
            }
        }

        private void validateParent() {
            String newParentFqn;
            String fqn = ((GlossaryTerm)this.original).getFullyQualifiedName();
            String string = newParentFqn = ((GlossaryTerm)this.updated).getParent() == null ? null : ((GlossaryTerm)this.updated).getParent().getFullyQualifiedName();
            if (newParentFqn != null && FullyQualifiedName.isParent(newParentFqn, fqn)) {
                throw new IllegalArgumentException(CatalogExceptionMessage.invalidGlossaryTermMove(fqn, newParentFqn));
            }
        }

        private void updateGlossaryRelationship(GlossaryTerm orig, GlossaryTerm updated) {
            this.deleteGlossaryRelationship(orig);
            GlossaryTermRepository.this.addGlossaryRelationship(updated);
        }

        private void deleteGlossaryRelationship(GlossaryTerm term) {
            Relationship relationship = term.getParent() == null ? Relationship.CONTAINS : Relationship.HAS;
            GlossaryTermRepository.this.deleteRelationship(term.getGlossary().getId(), "glossary", term.getId(), "glossaryTerm", relationship);
        }

        private void updateParentRelationship(GlossaryTerm orig, GlossaryTerm updated) {
            this.deleteParentRelationship(orig);
            GlossaryTermRepository.this.addParentRelationship(updated);
        }

        private void deleteParentRelationship(GlossaryTerm term) {
            if (term.getParent() != null) {
                GlossaryTermRepository.this.deleteRelationship(term.getParent().getId(), "glossaryTerm", term.getId(), "glossaryTerm", Relationship.CONTAINS);
            }
        }

        private void invalidateTerm(UUID termId) {
            List<CollectionDAO.EntityRelationshipRecord> tagRecords = GlossaryTermRepository.this.findToRecords(termId, "glossaryTerm", Relationship.CONTAINS, "glossaryTerm");
            EntityRepository.CACHE_WITH_ID.invalidate((Object)new ImmutablePair((Object)"glossaryTerm", (Object)termId));
            for (CollectionDAO.EntityRelationshipRecord tagRecord : tagRecords) {
                this.invalidateTerm(tagRecord.getId());
            }
        }
    }

    public static class ApprovalTaskWorkflow
    extends FeedRepository.TaskWorkflow {
        ApprovalTaskWorkflow(FeedRepository.ThreadContext threadContext) {
            super(threadContext);
        }

        @Override
        public EntityInterface performTask(String user, ResolveTask resolveTask) {
            GlossaryTerm glossaryTerm = (GlossaryTerm)this.threadContext.getAboutEntity();
            glossaryTerm.setStatus(GlossaryTerm.Status.APPROVED);
            return glossaryTerm;
        }

        @Override
        protected void closeTask(String user, CloseTask closeTask) {
            GlossaryTerm term = (GlossaryTerm)this.threadContext.getAboutEntity();
            if (term.getStatus() == GlossaryTerm.Status.DRAFT) {
                String origJson = JsonUtils.pojoToJson(term);
                term.setStatus(GlossaryTerm.Status.REJECTED);
                String updatedJson = JsonUtils.pojoToJson(term);
                JsonPatch patch = JsonUtils.getJsonPatch(origJson, updatedJson);
                EntityRepository<? extends EntityInterface> repository = this.threadContext.getEntityRepository();
                repository.patch(null, term.getId(), user, patch);
            }
        }
    }
}

