/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.json.JsonPatch;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.csv.CsvUtil;
import org.openmetadata.csv.EntityCsv;
import org.openmetadata.schema.api.lineage.AddLineage;
import org.openmetadata.schema.entity.data.Container;
import org.openmetadata.schema.entity.data.Dashboard;
import org.openmetadata.schema.entity.data.DashboardDataModel;
import org.openmetadata.schema.entity.data.MlModel;
import org.openmetadata.schema.entity.data.SearchIndex;
import org.openmetadata.schema.entity.data.Table;
import org.openmetadata.schema.entity.data.Topic;
import org.openmetadata.schema.type.ColumnLineage;
import org.openmetadata.schema.type.Edge;
import org.openmetadata.schema.type.EntityLineage;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.EventType;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.LineageDetails;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.schema.type.csv.CsvDocumentation;
import org.openmetadata.schema.type.csv.CsvFile;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.ColumnUtil;
import org.openmetadata.service.jdbi3.Repository;
import org.openmetadata.service.search.SearchClient;
import org.openmetadata.service.search.models.IndexMapping;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.RestUtil;

@Repository
public class LineageRepository {
    private final CollectionDAO dao = Entity.getCollectionDAO();
    private static final SearchClient searchClient = Entity.getSearchRepository().getSearchClient();

    public LineageRepository() {
        Entity.setLineageRepository(this);
    }

    public EntityLineage get(String entityType, String id, int upstreamDepth, int downstreamDepth) {
        EntityReference ref = Entity.getEntityReferenceById(entityType, UUID.fromString(id), Include.NON_DELETED);
        return this.getLineage(ref, upstreamDepth, downstreamDepth);
    }

    public EntityLineage getByName(String entityType, String fqn, int upstreamDepth, int downstreamDepth) {
        EntityReference ref = Entity.getEntityReferenceByName(entityType, fqn, Include.NON_DELETED);
        return this.getLineage(ref, upstreamDepth, downstreamDepth);
    }

    @Transaction
    public void addLineage(AddLineage addLineage) {
        EntityReference from = addLineage.getEdge().getFromEntity();
        from = Entity.getEntityReferenceById(from.getType(), from.getId(), Include.NON_DELETED);
        EntityReference to = addLineage.getEdge().getToEntity();
        to = Entity.getEntityReferenceById(to.getType(), to.getId(), Include.NON_DELETED);
        if (addLineage.getEdge().getLineageDetails() != null && addLineage.getEdge().getLineageDetails().getPipeline() != null) {
            EntityReference pipeline = addLineage.getEdge().getLineageDetails().getPipeline();
            pipeline = Entity.getEntityReferenceById(pipeline.getType(), pipeline.getId(), Include.NON_DELETED);
            addLineage.getEdge().getLineageDetails().withPipeline(pipeline);
        }
        String detailsJson = this.validateLineageDetails(from, to, addLineage.getEdge().getLineageDetails());
        this.dao.relationshipDAO().insert(from.getId(), to.getId(), from.getType(), to.getType(), Relationship.UPSTREAM.ordinal(), detailsJson);
        this.addLineageToSearch(from, to, addLineage.getEdge().getLineageDetails());
    }

    private void addLineageToSearch(EntityReference fromEntity, EntityReference toEntity, LineageDetails lineageDetails) {
        IndexMapping sourceIndexMapping = Entity.getSearchRepository().getIndexMapping(fromEntity.getType());
        String sourceIndexName = sourceIndexMapping.getIndexName(Entity.getSearchRepository().getClusterAlias());
        IndexMapping destinationIndexMapping = Entity.getSearchRepository().getIndexMapping(toEntity.getType());
        String destinationIndexName = destinationIndexMapping.getIndexName(Entity.getSearchRepository().getClusterAlias());
        Map<String, Object> relationshipDetails = LineageRepository.buildRelationshipDetailsMap(fromEntity, toEntity, lineageDetails);
        ImmutablePair from = new ImmutablePair((Object)"_id", (Object)fromEntity.getId().toString());
        ImmutablePair to = new ImmutablePair((Object)"_id", (Object)toEntity.getId().toString());
        searchClient.updateLineage(sourceIndexName, (Pair<String, String>)from, relationshipDetails);
        searchClient.updateLineage(destinationIndexName, (Pair<String, String>)to, relationshipDetails);
    }

    public static Map<String, Object> buildEntityRefMap(EntityReference entityRef) {
        HashMap<String, Object> details = new HashMap<String, Object>();
        details.put("id", entityRef.getId().toString());
        details.put("type", entityRef.getType());
        details.put("fqn", entityRef.getFullyQualifiedName());
        return details;
    }

    public static Map<String, Object> buildRelationshipDetailsMap(EntityReference fromEntity, EntityReference toEntity, LineageDetails lineageDetails) {
        HashMap<String, Object> relationshipDetails = new HashMap<String, Object>();
        relationshipDetails.put("doc_id", fromEntity.getId().toString() + "-" + toEntity.getId().toString());
        relationshipDetails.put("fromEntity", LineageRepository.buildEntityRefMap(fromEntity));
        relationshipDetails.put("toEntity", LineageRepository.buildEntityRefMap(toEntity));
        if (lineageDetails != null) {
            LineageRepository.addPipelineDetails(relationshipDetails, lineageDetails.getPipeline());
            relationshipDetails.put("description", CommonUtil.nullOrEmpty((String)lineageDetails.getDescription()) ? null : lineageDetails.getDescription());
            if (!CommonUtil.nullOrEmpty((List)lineageDetails.getColumnsLineage())) {
                ArrayList<Map<String, Object>> colummnLineageList = new ArrayList<Map<String, Object>>();
                for (ColumnLineage columnLineage : lineageDetails.getColumnsLineage()) {
                    colummnLineageList.add(JsonUtils.getMap(columnLineage));
                }
                relationshipDetails.put("columns", colummnLineageList);
            }
            relationshipDetails.put("sqlQuery", CommonUtil.nullOrEmpty((String)lineageDetails.getSqlQuery()) ? null : lineageDetails.getSqlQuery());
            relationshipDetails.put("source", CommonUtil.nullOrEmpty((Object)lineageDetails.getSource()) ? null : lineageDetails.getSource());
        }
        return relationshipDetails;
    }

    public static void addPipelineDetails(Map<String, Object> relationshipDetails, EntityReference pipelineRef) {
        if (CommonUtil.nullOrEmpty((Object)pipelineRef)) {
            relationshipDetails.put("pipeline", JsonUtils.getMap(null));
        } else {
            Map<String, Object> pipelineMap = pipelineRef.getType().equals("pipeline") ? JsonUtils.getMap(Entity.getEntity(pipelineRef, "pipelineStatus,tags,owner", Include.ALL)) : JsonUtils.getMap(Entity.getEntity(pipelineRef, "tags,owner", Include.ALL));
            relationshipDetails.put("pipelineEntityType", pipelineRef.getType());
            relationshipDetails.put("pipeline", pipelineMap);
        }
    }

    private String validateLineageDetails(EntityReference from, EntityReference to, LineageDetails details) {
        if (details == null) {
            return null;
        }
        List columnsLineage = details.getColumnsLineage();
        if (columnsLineage != null && !columnsLineage.isEmpty()) {
            for (ColumnLineage columnLineage : columnsLineage) {
                for (String fromColumn : columnLineage.getFromColumns()) {
                    this.validateChildren(fromColumn, from);
                }
                this.validateChildren(columnLineage.getToColumn(), to);
            }
        }
        return JsonUtils.pojoToJson(details);
    }

    public final String exportCsv(String fqn, int upstreamDepth, int downstreamDepth, String queryFilter, boolean deleted, String entityType) throws IOException {
        CsvDocumentation documentation = EntityCsv.getCsvDocumentation("lineage");
        List headers = documentation.getHeaders();
        Map<String, Object> lineageMap = Entity.getSearchRepository().searchLineageForExport(fqn, upstreamDepth, downstreamDepth, queryFilter, deleted, entityType);
        CsvFile csvFile = new CsvFile().withHeaders(headers);
        this.addRecords(csvFile, lineageMap);
        return CsvUtil.formatCsv(csvFile);
    }

    private String getStringOrNull(HashMap map, String key) {
        return CommonUtil.nullOrEmpty(map.get(key)) ? "" : map.get(key).toString();
    }

    private String getStringOrNull(HashMap map, String key, String nestedKey) {
        return CommonUtil.nullOrEmpty(map.get(key)) ? "" : this.getStringOrNull((HashMap)map.get(key), nestedKey);
    }

    private String processColumnLineage(HashMap lineageMap) {
        if (lineageMap.get("columns") != null) {
            StringBuilder str = new StringBuilder();
            Collection collection = (Collection)lineageMap.get("columns");
            HashSet hashSet = new HashSet(collection);
            for (HashMap colLineage : hashSet) {
                for (String fromColumn : (List)colLineage.get("fromColumns")) {
                    str.append(fromColumn);
                    str.append(":");
                    str.append(colLineage.get("toColumn"));
                    str.append(";");
                }
            }
            return str.toString().substring(0, str.toString().length() - 1);
        }
        return "";
    }

    protected void addRecords(CsvFile csvFile, Map<String, Object> lineageMap) {
        if (lineageMap.get("edges") != null && lineageMap.get("edges") instanceof Collection) {
            Collection collection = (Collection)lineageMap.get("edges");
            HashSet edges = new HashSet(collection);
            List finalRecordList = csvFile.getRecords();
            for (HashMap edge : edges) {
                ArrayList<String> recordList = new ArrayList<String>();
                CsvUtil.addField(recordList, this.getStringOrNull(edge, "fromEntity", "id"));
                CsvUtil.addField(recordList, this.getStringOrNull(edge, "fromEntity", "type"));
                CsvUtil.addField(recordList, this.getStringOrNull(edge, "fromEntity", "fqn"));
                CsvUtil.addField(recordList, this.getStringOrNull(edge, "toEntity", "id"));
                CsvUtil.addField(recordList, this.getStringOrNull(edge, "toEntity", "type"));
                CsvUtil.addField(recordList, this.getStringOrNull(edge, "toEntity", "fqn"));
                CsvUtil.addField(recordList, this.getStringOrNull(edge, "description"));
                CsvUtil.addField(recordList, this.getStringOrNull(edge, "pipeline", "id"));
                CsvUtil.addField(recordList, this.getStringOrNull(edge, "pipeline", "fullyQualifiedName"));
                CsvUtil.addField(recordList, this.processColumnLineage(edge));
                CsvUtil.addField(recordList, this.getStringOrNull(edge, "sqlQuery"));
                CsvUtil.addField(recordList, this.getStringOrNull(edge, "source"));
                finalRecordList.add(recordList);
            }
            csvFile.withRecords(finalRecordList);
        }
    }

    private void validateChildren(String columnFQN, EntityReference entityReference) {
        switch (entityReference.getType()) {
            case "table": {
                Table table = (Table)Entity.getEntity("table", entityReference.getId(), "columns", Include.NON_DELETED);
                ColumnUtil.validateColumnFQN(table.getColumns(), columnFQN);
                break;
            }
            case "searchIndex": {
                SearchIndex searchIndex = (SearchIndex)Entity.getEntity("searchIndex", entityReference.getId(), "fields", Include.NON_DELETED);
                ColumnUtil.validateSearchIndexFieldFQN(searchIndex.getFields(), columnFQN);
                break;
            }
            case "topic": {
                Topic topic = (Topic)Entity.getEntity("topic", entityReference.getId(), "messageSchema", Include.NON_DELETED);
                ColumnUtil.validateFieldFQN(topic.getMessageSchema().getSchemaFields(), columnFQN);
                break;
            }
            case "container": {
                Container container = (Container)Entity.getEntity("container", entityReference.getId(), "dataModel", Include.NON_DELETED);
                ColumnUtil.validateColumnFQN(container.getDataModel().getColumns(), columnFQN);
                break;
            }
            case "dashboardDataModel": {
                DashboardDataModel dashboardDataModel = (DashboardDataModel)Entity.getEntity("dashboardDataModel", entityReference.getId(), "columns", Include.NON_DELETED);
                ColumnUtil.validateColumnFQN(dashboardDataModel.getColumns(), columnFQN);
                break;
            }
            case "dashboard": {
                Dashboard dashboard = (Dashboard)Entity.getEntity("dashboard", entityReference.getId(), "charts", Include.NON_DELETED);
                dashboard.getCharts().stream().filter(c -> c.getFullyQualifiedName().equals(columnFQN)).findAny().orElseThrow(() -> new IllegalArgumentException(CatalogExceptionMessage.invalidFieldName("chart", columnFQN)));
                break;
            }
            case "mlmodel": {
                MlModel mlModel = (MlModel)Entity.getEntity("mlmodel", entityReference.getId(), "", Include.NON_DELETED);
                mlModel.getMlFeatures().stream().filter(f -> f.getFullyQualifiedName().equals(columnFQN)).findAny().orElseThrow(() -> new IllegalArgumentException(CatalogExceptionMessage.invalidFieldName("feature", columnFQN)));
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unsupported Entity Type %s for lineage", entityReference.getType()));
            }
        }
    }

    @Transaction
    public boolean deleteLineageByFQN(String fromEntity, String fromFQN, String toEntity, String toFQN) {
        EntityReference from = Entity.getEntityReferenceByName(fromEntity, fromFQN, Include.NON_DELETED);
        EntityReference to = Entity.getEntityReferenceByName(toEntity, toFQN, Include.NON_DELETED);
        boolean result = this.dao.relationshipDAO().delete(from.getId(), from.getType(), to.getId(), to.getType(), Relationship.UPSTREAM.ordinal()) > 0;
        this.deleteLineageFromSearch(from, to);
        return result;
    }

    @Transaction
    public boolean deleteLineage(String fromEntity, String fromId, String toEntity, String toId) {
        EntityReference from = Entity.getEntityReferenceById(fromEntity, UUID.fromString(fromId), Include.NON_DELETED);
        EntityReference to = Entity.getEntityReferenceById(toEntity, UUID.fromString(toId), Include.NON_DELETED);
        boolean result = this.dao.relationshipDAO().delete(from.getId(), from.getType(), to.getId(), to.getType(), Relationship.UPSTREAM.ordinal()) > 0;
        this.deleteLineageFromSearch(from, to);
        return result;
    }

    private void deleteLineageFromSearch(EntityReference fromEntity, EntityReference toEntity) {
        searchClient.updateChildren("all", (Pair<String, String>)new ImmutablePair((Object)"lineage.doc_id.keyword", (Object)(fromEntity.getId().toString() + "-" + toEntity.getId().toString())), (Pair<String, Map<String, Object>>)new ImmutablePair((Object)String.format("for (int i = 0; i < ctx._source.lineage.length; i++) { if (ctx._source.lineage[i].doc_id == '%s') { ctx._source.lineage.remove(i) }}", fromEntity.getId().toString() + "-" + toEntity.getId().toString()), null));
    }

    private EntityLineage getLineage(EntityReference primary, int upstreamDepth, int downstreamDepth) {
        ArrayList entities = new ArrayList();
        EntityLineage lineage = new EntityLineage().withEntity(primary).withNodes(entities).withUpstreamEdges(new ArrayList()).withDownstreamEdges(new ArrayList());
        this.getUpstreamLineage(primary.getId(), primary.getType(), lineage, upstreamDepth);
        this.getDownstreamLineage(primary.getId(), primary.getType(), lineage, downstreamDepth);
        lineage.withNodes(lineage.getNodes().stream().distinct().toList());
        return lineage;
    }

    private void getUpstreamLineage(UUID id, String entityType, EntityLineage lineage, int upstreamDepth) {
        if (upstreamDepth == 0) {
            return;
        }
        List<CollectionDAO.EntityRelationshipRecord> records = entityType.equals("pipeline") || entityType.equals("storedProcedure") ? this.dao.relationshipDAO().findFromPipeline(id, Relationship.UPSTREAM.ordinal()) : this.dao.relationshipDAO().findFrom(id, entityType, Relationship.UPSTREAM.ordinal());
        ArrayList<EntityReference> upstreamEntityReferences = new ArrayList<EntityReference>();
        for (CollectionDAO.EntityRelationshipRecord entityRelationshipRecord : records) {
            EntityReference ref = Entity.getEntityReferenceById(entityRelationshipRecord.getType(), entityRelationshipRecord.getId(), Include.ALL);
            LineageDetails lineageDetails = JsonUtils.readValue(entityRelationshipRecord.getJson(), LineageDetails.class);
            upstreamEntityReferences.add(ref);
            lineage.getUpstreamEdges().add(new Edge().withFromEntity(ref.getId()).withToEntity(id).withLineageDetails(lineageDetails));
        }
        lineage.getNodes().addAll(upstreamEntityReferences);
        --upstreamDepth;
        for (EntityReference entity : upstreamEntityReferences) {
            this.getUpstreamLineage(entity.getId(), entity.getType(), lineage, upstreamDepth);
        }
    }

    public Response getLineageEdge(UUID fromId, UUID toId) {
        String json = this.dao.relationshipDAO().getRelation(fromId, toId, Relationship.UPSTREAM.ordinal());
        if (json != null) {
            HashMap<String, LineageDetails> responseMap = new HashMap<String, LineageDetails>();
            LineageDetails lineageDetails = JsonUtils.readValue(json, LineageDetails.class);
            responseMap.put("edge", lineageDetails);
            return Response.status((Response.Status)Response.Status.OK).entity(responseMap).build();
        }
        throw new EntityNotFoundException("Lineage edge not found between " + fromId + " and  " + toId);
    }

    public Response patchLineageEdge(String fromEntity, UUID fromId, String toEntity, UUID toId, JsonPatch patch) {
        EntityReference from = Entity.getEntityReferenceById(fromEntity, fromId, Include.NON_DELETED);
        EntityReference to = Entity.getEntityReferenceById(toEntity, toId, Include.NON_DELETED);
        String json = this.dao.relationshipDAO().getRelation(fromId, toId, Relationship.UPSTREAM.ordinal());
        if (json != null) {
            LineageDetails original = JsonUtils.readValue(json, LineageDetails.class);
            LineageDetails updated = JsonUtils.applyPatch(original, patch, LineageDetails.class);
            if (updated.getPipeline() != null) {
                EntityReference pipeline = updated.getPipeline();
                pipeline = Entity.getEntityReferenceById(pipeline.getType(), pipeline.getId(), Include.NON_DELETED);
                updated.withPipeline(pipeline);
            }
            String detailsJson = JsonUtils.pojoToJson(updated);
            this.dao.relationshipDAO().insert(fromId, toId, fromEntity, toEntity, Relationship.UPSTREAM.ordinal(), detailsJson);
            this.addLineageToSearch(from, to, updated);
            return new RestUtil.PatchResponse<LineageDetails>(Response.Status.OK, updated, EventType.ENTITY_UPDATED).toResponse();
        }
        throw new EntityNotFoundException("Lineage edge not found between " + fromEntity + " " + fromId + " and " + toEntity + " " + toId);
    }

    private void getDownstreamLineage(UUID id, String entityType, EntityLineage lineage, int downstreamDepth) {
        if (downstreamDepth == 0) {
            return;
        }
        List<CollectionDAO.EntityRelationshipRecord> records = entityType.equals("pipeline") || entityType.equals("storedProcedure") ? this.dao.relationshipDAO().findToPipeline(id, Relationship.UPSTREAM.ordinal()) : this.dao.relationshipDAO().findTo(id, entityType, Relationship.UPSTREAM.ordinal());
        ArrayList<EntityReference> downstreamEntityReferences = new ArrayList<EntityReference>();
        for (CollectionDAO.EntityRelationshipRecord entityRelationshipRecord : records) {
            EntityReference ref = Entity.getEntityReferenceById(entityRelationshipRecord.getType(), entityRelationshipRecord.getId(), Include.ALL);
            LineageDetails lineageDetails = JsonUtils.readValue(entityRelationshipRecord.getJson(), LineageDetails.class);
            downstreamEntityReferences.add(ref);
            lineage.getDownstreamEdges().add(new Edge().withToEntity(ref.getId()).withFromEntity(id).withLineageDetails(lineageDetails));
        }
        lineage.getNodes().addAll(downstreamEntityReferences);
        --downstreamDepth;
        for (EntityReference entity : downstreamEntityReferences) {
            this.getDownstreamLineage(entity.getId(), entity.getType(), lineage, downstreamDepth);
        }
    }
}

