/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.migration.context;

import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;
import org.jdbi.v3.core.Handle;
import org.openmetadata.service.migration.context.CommonMigrationOps;
import org.openmetadata.service.migration.context.MigrationOps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationContext {
    private static final Logger LOG = LoggerFactory.getLogger(MigrationContext.class);
    private final String version;
    private final List<MigrationOps> migrationOps;
    private final Handle handle;
    private final HashMap<String, Long> results = new HashMap();

    public MigrationContext(String version, List<MigrationOps> migrationOps, Handle handle) {
        this.version = version;
        this.migrationOps = Stream.concat(migrationOps.stream(), CommonMigrationOps.getCommonOps().stream()).toList();
        this.handle = handle;
    }

    public void compute() {
        this.migrationOps.forEach(ops -> {
            ops.compute(this.handle);
            this.results.put(ops.getName(), ops.getResult());
        });
    }

    public void show() {
        LOG.debug(String.format("Version [%s] context is [%s]", this.version, this.results));
    }

    public String getVersion() {
        return this.version;
    }

    public List<MigrationOps> getMigrationOps() {
        return this.migrationOps;
    }

    public HashMap<String, Long> getResults() {
        return this.results;
    }
}

