/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.analytics;

import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import lombok.NonNull;
import org.openmetadata.schema.analytics.ReportData;
import org.openmetadata.schema.type.MetadataOperation;
import org.openmetadata.service.jdbi3.ReportDataRepository;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.resources.EntityTimeSeriesResource;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.security.policyevaluator.OperationContext;
import org.openmetadata.service.security.policyevaluator.ReportDataContext;
import org.openmetadata.service.util.ResultList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/analytics/dataInsights/data")
@Tag(name="Data Insights", description="APIs related to Data Insights data and charts.")
@Hidden
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="analytics")
public class ReportDataResource
extends EntityTimeSeriesResource<ReportData, ReportDataRepository> {
    private static final Logger LOG = LoggerFactory.getLogger(ReportDataResource.class);
    public static final String COLLECTION_PATH = "v1/analytics/dataInsights/data";

    public ReportDataResource(Authorizer authorizer) {
        super("entityReportData", authorizer);
    }

    @GET
    @Operation(operationId="getReportData", summary="List the report data", description="Get a list of all the report data for a given data insight report type , optionally filtered by  `startTs` and `endTs` of the result. Use cursor-based pagination to limit the number of entries in the list using `limit` and `before` or `after` query params.", responses={@ApiResponse(responseCode="200", description="List of report data", content={@Content(mediaType="application/json", schema=@Schema(implementation=ReportDataResultList.class))})})
    public ResultList<ReportData> list(@Context SecurityContext securityContext, @Parameter(description="report data type", schema=@Schema(implementation=ReportData.ReportDataType.class)) @QueryParam(value="reportDataType") @NonNull ReportData.ReportDataType reportDataType, @Parameter(description="Filter report data results after the given start timestamp", schema=@Schema(type="number")) @QueryParam(value="startTs") @NonNull Long startTs, @Parameter(description="Filter report data results before the given end timestamp", schema=@Schema(type="number")) @QueryParam(value="endTs") @NonNull Long endTs) {
        if (reportDataType == null) {
            throw new NullPointerException("reportDataType is marked non-null but is null");
        }
        if (startTs == null) {
            throw new NullPointerException("startTs is marked non-null but is null");
        }
        if (endTs == null) {
            throw new NullPointerException("endTs is marked non-null but is null");
        }
        OperationContext operationContext = new OperationContext("dataInsightChart", MetadataOperation.VIEW_ALL);
        ReportDataContext resourceContext = ReportDataContext.builder().build();
        this.authorizer.authorize(securityContext, operationContext, resourceContext);
        return ((ReportDataRepository)this.repository).getReportData(reportDataType, startTs, endTs);
    }

    @POST
    @Operation(operationId="addReportData", summary="Add data to a data insight report", description="Add data to a data insight report type", responses={@ApiResponse(responseCode="200", description="Successfully added reportData.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ReportData.class))})})
    public Response addReportData(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid ReportData reportData) {
        OperationContext operationContext = new OperationContext("dataInsightChart", MetadataOperation.CREATE);
        ReportDataContext resourceContext = ReportDataContext.builder().build();
        this.authorizer.authorize(securityContext, operationContext, resourceContext);
        return this.create(reportData, "reportData.reportDataResult", reportData.getReportDataType().toString());
    }

    @DELETE
    @Path(value="/{reportDataType}/{date}")
    @Operation(operationId="deleteReportData", summary="Delete report data for a given report data type ando date", description="Delete report data for a given report data type and date.", responses={@ApiResponse(responseCode="200", description="Successfully deleted report data.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ReportData.class))})})
    public Response deleteReportData(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="report data type", schema=@Schema(implementation=ReportData.ReportDataType.class)) @PathParam(value="reportDataType") @NonNull ReportData.ReportDataType reportDataType, @Parameter(description="date in format YYYY-MM-DD", schema=@Schema(type="String")) @PathParam(value="date") @NonNull String date) {
        if (reportDataType == null) {
            throw new NullPointerException("reportDataType is marked non-null but is null");
        }
        if (date == null) {
            throw new NullPointerException("date is marked non-null but is null");
        }
        OperationContext operationContext = new OperationContext("dataInsightChart", MetadataOperation.DELETE);
        ReportDataContext resourceContext = ReportDataContext.builder().build();
        this.authorizer.authorize(securityContext, operationContext, resourceContext);
        ((ReportDataRepository)this.repository).deleteReportDataAtDate(reportDataType, date);
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/{reportDataType}")
    @Operation(operationId="deletePreviousReportData", summary="Delete all the previous report data for a given report data type", description="Delete all the previous report data for a given report data type.", responses={@ApiResponse(responseCode="200", description="Successfully deleted previous report data.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ReportData.class))})})
    public Response deletePreviousReportData(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="report data type", schema=@Schema(implementation=ReportData.ReportDataType.class)) @PathParam(value="reportDataType") @NonNull ReportData.ReportDataType reportDataType) {
        if (reportDataType == null) {
            throw new NullPointerException("reportDataType is marked non-null but is null");
        }
        OperationContext operationContext = new OperationContext("dataInsightChart", MetadataOperation.DELETE);
        ReportDataContext resourceContext = ReportDataContext.builder().build();
        this.authorizer.authorize(securityContext, operationContext, resourceContext);
        ((ReportDataRepository)this.repository).deleteReportData(reportDataType);
        return Response.ok().build();
    }

    public static class ReportDataResultList
    extends ResultList<ReportData> {
    }
}

