/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.services.MessagingService;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;

public record MessagingServiceIndex(MessagingService messagingService) implements SearchIndex
{
    @Override
    public List<SearchSuggest> getSuggest() {
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.messagingService.getName()).weight(5).build());
        suggest.add(SearchSuggest.builder().input(this.messagingService.getFullyQualifiedName()).weight(5).build());
        return suggest;
    }

    @Override
    public Object getEntity() {
        return this.messagingService;
    }

    @Override
    public Map<String, Object> buildSearchIndexDocInternal(Map<String, Object> doc) {
        Map<String, Object> commonAttributes = this.getCommonAttributesMap((EntityInterface)this.messagingService, "messagingService");
        doc.putAll(commonAttributes);
        return doc;
    }
}

