/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.secrets;

import java.util.HashMap;
import java.util.Map;
import org.openmetadata.schema.security.secrets.SecretsManagerProvider;
import org.openmetadata.service.exception.SecretsManagerException;
import org.openmetadata.service.secrets.ExternalSecretsManager;
import org.openmetadata.service.secrets.SecretsManager;

public class InMemorySecretsManager
extends ExternalSecretsManager {
    private static InMemorySecretsManager instance;
    private final Map<String, String> secretsMap = new HashMap<String, String>();

    protected InMemorySecretsManager(SecretsManager.SecretsConfig secretsConfig) {
        super(SecretsManagerProvider.IN_MEMORY, secretsConfig, 0L);
    }

    public static InMemorySecretsManager getInstance(SecretsManager.SecretsConfig secretsConfig) {
        if (instance == null) {
            instance = new InMemorySecretsManager(secretsConfig);
        }
        return instance;
    }

    @Override
    void storeSecret(String secretName, String secretValue) {
        this.secretsMap.put(secretName, secretValue);
    }

    @Override
    void updateSecret(String secretName, String secretValue) {
        this.storeSecret(secretName, secretValue);
    }

    @Override
    protected void deleteSecretInternal(String secretName) {
        this.secretsMap.remove(secretName);
    }

    @Override
    String getSecret(String secretName) {
        String value = this.secretsMap.getOrDefault(secretName, null);
        if (value == null) {
            throw new SecretsManagerException(String.format("Key [%s] not found in in-memory secrets manager", secretName));
        }
        return value;
    }

    public Map<String, String> getSecretsMap() {
        return this.secretsMap;
    }
}

