/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.StreamReadFeature;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.datatype.jsr353.JSR353Module;
import com.github.fge.jsonpatch.diff.JsonDiff;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonPatch;
import javax.json.JsonReader;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.openmetadata.annotations.IgnoreMaskedFieldAnnotationIntrospector;
import org.openmetadata.annotations.OnlyExposedFieldAnnotationIntrospector;
import org.openmetadata.schema.entity.Type;
import org.openmetadata.schema.entity.type.Category;
import org.openmetadata.service.exception.UnhandledServerException;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.RestUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsonUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JsonUtils.class);
    public static final String FIELD_TYPE_ANNOTATION = "@om-field-type";
    public static final String ENTITY_TYPE_ANNOTATION = "@om-entity-type";
    public static final String JSON_FILE_EXTENSION = ".json";
    private static final ObjectMapper OBJECT_MAPPER;
    private static final ObjectMapper EXPOSED_OBJECT_MAPPER;
    private static final ObjectMapper MASKER_OBJECT_MAPPER;
    private static final JsonSchemaFactory schemaFactory;
    private static final String FAILED_TO_PROCESS_JSON = "Failed to process JSON ";

    private JsonUtils() {
    }

    public static String pojoToJson(Object o) {
        if (o == null) {
            return null;
        }
        return JsonUtils.pojoToJson(o, false);
    }

    public static String pojoToJson(Object o, boolean prettyPrint) {
        try {
            return prettyPrint ? OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(o) : OBJECT_MAPPER.writeValueAsString(o);
        }
        catch (JsonProcessingException e) {
            throw new UnhandledServerException(FAILED_TO_PROCESS_JSON, e);
        }
    }

    public static JsonStructure getJsonStructure(Object o) {
        return (JsonStructure)OBJECT_MAPPER.convertValue(o, JsonStructure.class);
    }

    public static Map<String, Object> getMap(Object o) {
        Map map = (Map)OBJECT_MAPPER.convertValue(o, Map.class);
        return map;
    }

    public static <T> T readOrConvertValue(Object obj, Class<T> clz) {
        if (obj instanceof String) {
            return JsonUtils.readValue((String)obj, clz);
        }
        return JsonUtils.convertValue(obj, clz);
    }

    public static <T> List<T> readOrConvertValues(Object obj, Class<T> clz) {
        if (obj instanceof String) {
            String str = (String)obj;
            return JsonUtils.readObjects(str, clz);
        }
        return JsonUtils.convertObjects(obj, clz);
    }

    public static <T> T readValue(String json, String clazzName) {
        try {
            return (T)JsonUtils.readValue(json, Class.forName(clazzName));
        }
        catch (ClassNotFoundException e) {
            throw new UnhandledServerException(FAILED_TO_PROCESS_JSON, e);
        }
    }

    public static <T> T readValue(String json, Class<T> clz) {
        if (json == null) {
            return null;
        }
        try {
            return (T)OBJECT_MAPPER.readValue(json, clz);
        }
        catch (JsonProcessingException e) {
            throw new UnhandledServerException(FAILED_TO_PROCESS_JSON, e);
        }
    }

    public static <T> T readValue(String json, TypeReference<T> valueTypeRef) {
        if (json == null) {
            return null;
        }
        try {
            return (T)OBJECT_MAPPER.readValue(json, valueTypeRef);
        }
        catch (JsonProcessingException e) {
            throw new UnhandledServerException(FAILED_TO_PROCESS_JSON, e);
        }
    }

    public static <T> List<T> convertObjects(Object json, Class<T> clz) {
        if (json == null) {
            return Collections.emptyList();
        }
        TypeFactory typeFactory = OBJECT_MAPPER.getTypeFactory();
        return (List)OBJECT_MAPPER.convertValue(json, (JavaType)typeFactory.constructCollectionType(List.class, clz));
    }

    public static <T> List<T> readObjects(String json, Class<T> clz) {
        if (json == null) {
            return Collections.emptyList();
        }
        TypeFactory typeFactory = OBJECT_MAPPER.getTypeFactory();
        try {
            return (List)OBJECT_MAPPER.readValue(json, (JavaType)typeFactory.constructCollectionType(List.class, clz));
        }
        catch (JsonProcessingException e) {
            throw new UnhandledServerException(FAILED_TO_PROCESS_JSON, e);
        }
    }

    public static <T> List<T> readObjects(List<String> jsons, Class<T> clz) {
        if (jsons == null) {
            return Collections.emptyList();
        }
        ArrayList<T> list = new ArrayList<T>();
        for (String json : jsons) {
            list.add(JsonUtils.readValue(json, clz));
        }
        return list;
    }

    public static <T> T convertValue(Object object, Class<T> clz) {
        return (T)(object == null ? null : OBJECT_MAPPER.convertValue(object, clz));
    }

    public static <T> T convertValue(Object object, TypeReference<T> toValueTypeRef) {
        return (T)(object == null ? null : OBJECT_MAPPER.convertValue(object, toValueTypeRef));
    }

    public static JsonValue applyPatch(Object original, JsonPatch patch) {
        JsonStructure targetJson = JsonUtils.getJsonStructure(original);
        JsonArray array = patch.toJsonArray();
        ArrayList filteredPatchItems = new ArrayList();
        array.forEach(entry -> {
            JsonObject jsonObject = entry.asJsonObject();
            if (jsonObject.getString("path").endsWith("href")) {
                return;
            }
            filteredPatchItems.add(jsonObject);
        });
        JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
        filteredPatchItems.forEach(arg_0 -> ((JsonArrayBuilder)arrayBuilder).add(arg_0));
        JsonPatch filteredPatch = Json.createPatch((JsonArray)arrayBuilder.build());
        try {
            return filteredPatch.apply(targetJson);
        }
        catch (Exception e) {
            LOG.debug("Failed to apply the json patch {}", (Object)filteredPatch);
            throw e;
        }
    }

    public static <T> T applyPatch(T original, JsonPatch patch, Class<T> clz) {
        JsonValue value = JsonUtils.applyPatch(original, patch);
        return (T)OBJECT_MAPPER.convertValue((Object)value, clz);
    }

    public static JsonPatch getJsonPatch(String v1, String v2) {
        JsonNode source = JsonUtils.readTree(v1);
        JsonNode dest = JsonUtils.readTree(v2);
        return Json.createPatch((JsonArray)JsonUtils.treeToValue(JsonDiff.asJson((JsonNode)source, (JsonNode)dest), JsonArray.class));
    }

    public static JsonPatch getJsonPatch(Object v1, Object v2) {
        JsonNode source = JsonUtils.valueToTree(v1);
        JsonNode dest = JsonUtils.valueToTree(v2);
        return Json.createPatch((JsonArray)JsonUtils.treeToValue(JsonDiff.asJson((JsonNode)source, (JsonNode)dest), JsonArray.class));
    }

    public static JsonValue readJson(String s) {
        try (JsonReader reader = Json.createReader((Reader)new StringReader(s));){
            JsonValue jsonValue = reader.readValue();
            return jsonValue;
        }
    }

    public static JsonSchema getJsonSchema(String schema) {
        return schemaFactory.getSchema(schema);
    }

    public static JsonNode valueToTree(Object object) {
        return OBJECT_MAPPER.valueToTree(object);
    }

    public static boolean hasAnnotation(JsonNode jsonNode, String annotation) {
        String comment = String.valueOf(jsonNode.get("$comment"));
        return comment != null && comment.contains(annotation);
    }

    public static List<Type> getTypes() {
        List<String> jsonSchemas;
        ArrayList<Type> types = new ArrayList<Type>();
        try {
            jsonSchemas = EntityUtil.getJsonDataResources(".*json/schema/type/.*\\.json$");
        }
        catch (IOException e) {
            throw new UnhandledServerException("Failed to read JSON resources at .*json/schema/type", e);
        }
        for (String jsonSchema : jsonSchemas) {
            try {
                types.addAll(JsonUtils.getFieldTypes(jsonSchema));
            }
            catch (Exception e) {
                LOG.warn("Failed to initialize the types from jsonSchema file {}", (Object)jsonSchema, (Object)e);
            }
        }
        try {
            jsonSchemas = EntityUtil.getJsonDataResources(".*json/schema/entity/.*\\.json$");
        }
        catch (IOException e) {
            throw new UnhandledServerException("Failed to read JSON resources at .*json/schema/entity", e);
        }
        for (String jsonSchema : jsonSchemas) {
            try {
                Type entityType = JsonUtils.getEntityType(jsonSchema);
                if (entityType == null) continue;
                types.add(entityType);
            }
            catch (Exception e) {
                LOG.warn("Failed to initialize the types from jsonSchema file {}", (Object)jsonSchema, (Object)e);
            }
        }
        return types;
    }

    public static List<Type> getFieldTypes(String jsonSchemaFile) {
        JsonNode node;
        try {
            node = OBJECT_MAPPER.readTree(Objects.requireNonNull(JsonUtils.class.getClassLoader().getResourceAsStream(jsonSchemaFile)));
        }
        catch (IOException e) {
            throw new UnhandledServerException("Failed to read jsonSchemaFile " + jsonSchemaFile, e);
        }
        if (node.get("definitions") == null) {
            return Collections.emptyList();
        }
        String jsonNamespace = JsonUtils.getSchemaName(jsonSchemaFile);
        ArrayList<Type> types = new ArrayList<Type>();
        Iterator definitions = node.get("definitions").fields();
        while (definitions != null && definitions.hasNext()) {
            Map.Entry entry = (Map.Entry)definitions.next();
            String typeName = (String)entry.getKey();
            JsonNode value = (JsonNode)entry.getValue();
            if (!JsonUtils.hasAnnotation(value, FIELD_TYPE_ANNOTATION)) continue;
            String description = String.valueOf(value.get("description"));
            Type type = new Type().withName(typeName).withCategory(Category.Field).withFullyQualifiedName(typeName).withNameSpace(jsonNamespace).withDescription(description).withDisplayName((String)entry.getKey()).withSchema(value.toPrettyString());
            types.add(type);
        }
        return types;
    }

    public static Type getEntityType(String jsonSchemaFile) {
        JsonNode node;
        try {
            node = OBJECT_MAPPER.readTree(Objects.requireNonNull(JsonUtils.class.getClassLoader().getResourceAsStream(jsonSchemaFile)));
        }
        catch (IOException e) {
            throw new UnhandledServerException("Failed to read jsonSchemaFile " + jsonSchemaFile, e);
        }
        if (!JsonUtils.hasAnnotation(node, ENTITY_TYPE_ANNOTATION)) {
            return null;
        }
        String entityName = JsonUtils.getSchemaName(jsonSchemaFile);
        String namespace = JsonUtils.getSchemaGroup(jsonSchemaFile);
        String description = String.valueOf(node.get("description"));
        return new Type().withName(entityName).withCategory(Category.Entity).withFullyQualifiedName(entityName).withNameSpace(namespace).withDescription(description).withDisplayName(entityName).withSchema(node.toPrettyString());
    }

    private static String getSchemaName(String path) {
        String fileName = Paths.get(path, new String[0]).getFileName().toString();
        return fileName.replace(" ", "").replace(JSON_FILE_EXTENSION, "");
    }

    private static String getSchemaGroup(String path) {
        return Paths.get(path, new String[0]).getParent().getFileName().toString();
    }

    public static String pojoToMaskedJson(Object entity) {
        try {
            return MASKER_OBJECT_MAPPER.writeValueAsString(entity);
        }
        catch (JsonProcessingException e) {
            throw new UnhandledServerException(FAILED_TO_PROCESS_JSON, e);
        }
    }

    public static <T> T toExposedEntity(Object entity, Class<T> clazz) {
        try {
            String jsonString = EXPOSED_OBJECT_MAPPER.writeValueAsString(entity);
            return (T)EXPOSED_OBJECT_MAPPER.readValue(jsonString, clazz);
        }
        catch (JsonProcessingException e) {
            throw new UnhandledServerException(FAILED_TO_PROCESS_JSON, e);
        }
    }

    public static ObjectNode getObjectNode(String key, JsonNode value) {
        ObjectNode objectNode = JsonUtils.getObjectNode();
        return (ObjectNode)objectNode.set(key, value);
    }

    public static ObjectNode getObjectNode() {
        return OBJECT_MAPPER.createObjectNode();
    }

    public static JsonNode readTree(String extensionJson) {
        try {
            return OBJECT_MAPPER.readTree(extensionJson);
        }
        catch (JsonProcessingException e) {
            throw new UnhandledServerException(FAILED_TO_PROCESS_JSON, e);
        }
    }

    public static <T> T treeToValue(JsonNode jsonNode, Class<T> classType) {
        try {
            return (T)OBJECT_MAPPER.treeToValue((TreeNode)jsonNode, classType);
        }
        catch (JsonProcessingException e) {
            throw new UnhandledServerException(FAILED_TO_PROCESS_JSON, e);
        }
    }

    public static boolean areEquals(Object obj1, Object obj2) {
        try {
            ObjectMapper mapper = ((JsonMapper.Builder)JsonMapper.builder().nodeFactory((JsonNodeFactory)new SortedNodeFactory())).build();
            JsonNode obj1sorted = mapper.reader().with(StreamReadFeature.STRICT_DUPLICATE_DETECTION).readTree(JsonUtils.pojoToJson(obj1));
            JsonNode obj2sorted = mapper.reader().with(StreamReadFeature.STRICT_DUPLICATE_DETECTION).readTree(JsonUtils.pojoToJson(obj2));
            return OBJECT_MAPPER.writeValueAsString((Object)obj1sorted).equals(OBJECT_MAPPER.writeValueAsString((Object)obj2sorted));
        }
        catch (JsonProcessingException e) {
            throw new UnhandledServerException(FAILED_TO_PROCESS_JSON, e);
        }
    }

    public static <T> T deepCopy(T original, Class<T> clazz) {
        String json = JsonUtils.pojoToJson(original);
        return (T)OBJECT_MAPPER.readValue(json, clazz);
    }

    public static <T> T extractValue(String jsonResponse, String ... keys) {
        JsonNode jsonNode = JsonUtils.readTree(jsonResponse);
        for (String key : keys) {
            jsonNode = jsonNode.path(key);
        }
        return (T)JsonUtils.treeToValue(jsonNode, JsonUtils.getValueClass(jsonNode));
    }

    public static <T> T extractValue(JsonNode jsonNode, String ... keys) {
        for (String key : keys) {
            jsonNode = jsonNode.path(key);
        }
        return (T)JsonUtils.treeToValue(jsonNode, JsonUtils.getValueClass(jsonNode));
    }

    public static <T> void validateJsonSchema(Object fromValue, Class<T> toValueType) {
        Object convertedValue = OBJECT_MAPPER.convertValue(fromValue, toValueType);
        try (ValidatorFactory validatorFactory = Validation.buildDefaultValidatorFactory();){
            Validator validator = validatorFactory.getValidator();
            Set violations = validator.validate(convertedValue, new Class[0]);
            if (!violations.isEmpty()) {
                String detailedErrors = violations.stream().map(violation -> violation.getPropertyPath() + ": " + violation.getMessage()).collect(Collectors.joining(", "));
                throw new ConstraintViolationException(FAILED_TO_PROCESS_JSON + detailedErrors, violations);
            }
        }
    }

    private static Class<?> getValueClass(JsonNode jsonNode) {
        return switch (jsonNode.getNodeType()) {
            default -> throw new IncompatibleClassChangeError();
            case JsonNodeType.ARRAY, JsonNodeType.OBJECT -> JsonNode.class;
            case JsonNodeType.BINARY -> byte[].class;
            case JsonNodeType.BOOLEAN -> Boolean.class;
            case JsonNodeType.NUMBER -> Number.class;
            case JsonNodeType.STRING -> String.class;
            case JsonNodeType.MISSING, JsonNodeType.NULL, JsonNodeType.POJO -> Object.class;
        };
    }

    static {
        schemaFactory = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V7);
        OBJECT_MAPPER = new ObjectMapper();
        OBJECT_MAPPER.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        OBJECT_MAPPER.setDateFormat(RestUtil.DATE_TIME_FORMAT);
        OBJECT_MAPPER.registerModule((Module)new JSR353Module());
        EXPOSED_OBJECT_MAPPER = OBJECT_MAPPER.copy();
        EXPOSED_OBJECT_MAPPER.setAnnotationIntrospector((AnnotationIntrospector)new OnlyExposedFieldAnnotationIntrospector());
        MASKER_OBJECT_MAPPER = OBJECT_MAPPER.copy();
        MASKER_OBJECT_MAPPER.setAnnotationIntrospector((AnnotationIntrospector)new IgnoreMaskedFieldAnnotationIntrospector());
    }

    static class SortedNodeFactory
    extends JsonNodeFactory {
        SortedNodeFactory() {
        }

        public ObjectNode objectNode() {
            return new ObjectNode((JsonNodeFactory)this, new TreeMap());
        }
    }
}

