/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.util;

import ch.qos.logback.classic.Level;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.dropwizard.configuration.ConfigurationSourceProvider;
import io.dropwizard.configuration.EnvironmentVariableSubstitutor;
import io.dropwizard.configuration.FileConfigurationSourceProvider;
import io.dropwizard.configuration.SubstitutingSourceProvider;
import io.dropwizard.configuration.YamlConfigurationFactory;
import io.dropwizard.db.DataSourceFactory;
import io.dropwizard.jackson.Jackson;
import io.dropwizard.jersey.validation.Validators;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.json.JsonPatch;
import javax.validation.Validator;
import org.apache.commons.text.StringSubstitutor;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.internal.info.MigrationInfoDumper;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.SqlObjects;
import org.jdbi.v3.sqlobject.locator.SqlLocator;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.ServiceEntityInterface;
import org.openmetadata.schema.entity.app.App;
import org.openmetadata.schema.entity.app.AppRunRecord;
import org.openmetadata.schema.entity.services.ingestionPipelines.IngestionPipeline;
import org.openmetadata.schema.services.connections.metadata.OpenMetadataConnection;
import org.openmetadata.schema.system.EventPublisherJob;
import org.openmetadata.schema.type.Include;
import org.openmetadata.sdk.PipelineServiceClient;
import org.openmetadata.service.Entity;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.apps.ApplicationHandler;
import org.openmetadata.service.apps.scheduler.AppScheduler;
import org.openmetadata.service.clients.pipeline.PipelineServiceClientFactory;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.exception.UnhandledServerException;
import org.openmetadata.service.fernet.Fernet;
import org.openmetadata.service.jdbi3.AppRepository;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.jdbi3.IngestionPipelineRepository;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.jdbi3.MigrationDAO;
import org.openmetadata.service.jdbi3.locator.ConnectionAwareAnnotationSqlLocator;
import org.openmetadata.service.jdbi3.locator.ConnectionType;
import org.openmetadata.service.migration.api.MigrationWorkflow;
import org.openmetadata.service.resources.CollectionRegistry;
import org.openmetadata.service.resources.databases.DatasourceConfig;
import org.openmetadata.service.search.SearchRepository;
import org.openmetadata.service.secrets.SecretsManager;
import org.openmetadata.service.secrets.SecretsManagerFactory;
import org.openmetadata.service.secrets.SecretsManagerUpdateService;
import org.openmetadata.service.util.AsciiTable;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.OpenMetadataConnectionBuilder;
import org.openmetadata.service.util.jdbi.DatabaseAuthenticationProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="OpenMetadataSetup", mixinStandardHelpOptions=true, version={"OpenMetadataSetup 1.3"}, description={"Creates or Migrates Database/Search Indexes. ReIndex the existing data into Elastic Search or OpenSearch. Re-Deploys the service pipelines."})
public class OpenMetadataOperations
implements Callable<Integer> {
    private static final Logger LOG = LoggerFactory.getLogger(OpenMetadataOperations.class);
    private OpenMetadataApplicationConfig config;
    private Flyway flyway;
    private Jdbi jdbi;
    private SearchRepository searchRepository;
    private String nativeSQLScriptRootPath;
    private String extensionSQLScriptRootPath;
    private SecretsManager secretsManager;
    private CollectionDAO collectionDAO;
    @CommandLine.Option(names={"-d", "--debug"}, defaultValue="false")
    private boolean debug;
    @CommandLine.Option(names={"-c", "--config"}, required=true)
    private String configFilePath;

    @Override
    public Integer call() {
        LOG.info("Subcommand needed: 'info', 'validate', 'repair', 'check-connection', 'drop-create', 'migrate', 'reindex', 'deploy-pipelines'");
        return 0;
    }

    @CommandLine.Command(name="info", description={"Shows the list of migrations applied and the pending migration waiting to be applied on the target database"})
    public Integer info() {
        try {
            this.parseConfig();
            LOG.info(MigrationInfoDumper.dumpToAsciiTable((MigrationInfo[])this.flyway.info().all()));
            return 0;
        }
        catch (Exception e) {
            LOG.error("Failed due to ", (Throwable)e);
            return 1;
        }
    }

    @CommandLine.Command(name="validate", description={"Checks if the all the migrations haven been applied on the target database."})
    public Integer validate() {
        try {
            this.parseConfig();
            this.flyway.validate();
            return 0;
        }
        catch (Exception e) {
            LOG.error("Database migration validation failed due to ", (Throwable)e);
            return 1;
        }
    }

    @CommandLine.Command(name="repair", description={"Repairs the DATABASE_CHANGE_LOG table which is used to trackall the migrations on the target database This involves removing entries for the failed migrations and updatethe checksum of migrations already applied on the target database"})
    public Integer repair() {
        try {
            this.parseConfig();
            this.flyway.repair();
            return 0;
        }
        catch (Exception e) {
            LOG.error("Repair of CHANGE_LOG failed due to ", (Throwable)e);
            return 1;
        }
    }

    @CommandLine.Command(name="check-connection", description={"Checks if a connection can be successfully obtained for the target database"})
    public Integer checkConnection() {
        try {
            this.parseConfig();
            this.flyway.getConfiguration().getDataSource().getConnection();
            return 0;
        }
        catch (Exception e) {
            LOG.error("Failed to check connection due to ", (Throwable)e);
            return 1;
        }
    }

    @CommandLine.Command(name="drop-create", description={"Deletes any tables in configured database and creates a new tables based on current version of OpenMetadata. This command also re-creates the search indexes."})
    public Integer dropCreate() {
        try {
            this.promptUserForDelete();
            this.parseConfig();
            LOG.info("Deleting all the OpenMetadata tables.");
            this.flyway.clean();
            LOG.info("Creating the OpenMetadata Schema.");
            this.flyway.migrate();
            this.validateAndRunSystemDataMigrations(true);
            LOG.info("OpenMetadata Database Schema is Updated.");
            LOG.info("create indexes.");
            this.searchRepository.createIndexes();
            Entity.cleanup();
            return 0;
        }
        catch (Exception e) {
            LOG.error("Failed to drop create due to ", (Throwable)e);
            return 1;
        }
    }

    @CommandLine.Command(name="migrate", description={"Migrates the OpenMetadata database schema and search index mappings."})
    public Integer migrate(@CommandLine.Option(names={"--force"}, description={"Forces migrations to be run again, even if they have ran previously"}, defaultValue="false") boolean force) {
        try {
            LOG.info("Migrating the OpenMetadata Schema.");
            this.parseConfig();
            this.flyway.migrate();
            this.validateAndRunSystemDataMigrations(force);
            LOG.info("Update Search Indexes.");
            this.searchRepository.updateIndexes();
            this.printChangeLog();
            new SecretsManagerUpdateService(this.secretsManager, this.config.getClusterName()).updateEntities();
            Entity.cleanup();
            return 0;
        }
        catch (Exception e) {
            LOG.error("Failed to db migration due to ", (Throwable)e);
            return 1;
        }
    }

    @CommandLine.Command(name="changelog", description={"Prints the change log of database migration."})
    public Integer changelog() {
        try {
            this.parseConfig();
            this.printChangeLog();
            return 0;
        }
        catch (Exception e) {
            LOG.error("Failed to fetch db change log due to ", (Throwable)e);
            return 1;
        }
    }

    @CommandLine.Command(name="reindex", description={"Re Indexes data into search engine from command line."})
    public Integer reIndex(@CommandLine.Option(names={"-b", "--batch-size"}, defaultValue="100") int batchSize, @CommandLine.Option(names={"--recreate-indexes"}, defaultValue="true") boolean recreateIndexes) {
        try {
            this.parseConfig();
            CollectionRegistry.initialize();
            ApplicationHandler.initialize(this.config);
            CollectionRegistry.getInstance().loadSeedData(this.jdbi, this.config, null, null, true);
            ApplicationHandler.initialize(this.config);
            AppScheduler.initialize(this.config, this.collectionDAO, this.searchRepository);
            String appName = "SearchIndexingApplication";
            return this.executeSearchReindexApp(appName, batchSize, recreateIndexes);
        }
        catch (Exception e) {
            LOG.error("Failed to reindex due to ", (Throwable)e);
            return 1;
        }
    }

    private int executeSearchReindexApp(String appName, int batchSize, boolean recreateIndexes) {
        AppRepository appRepository = (AppRepository)Entity.getEntityRepository("app");
        App originalSearchIndexApp = (App)appRepository.getByName(null, appName, appRepository.getFields("id"));
        EventPublisherJob storedJob = JsonUtils.convertValue(originalSearchIndexApp.getAppConfiguration(), EventPublisherJob.class);
        App updatedSearchIndexApp = JsonUtils.deepCopy(originalSearchIndexApp, App.class);
        updatedSearchIndexApp.withAppConfiguration((Object)storedJob.withRecreateIndex(Boolean.valueOf(recreateIndexes)).withBatchSize(Integer.valueOf(batchSize)));
        JsonPatch patch = JsonUtils.getJsonPatch(originalSearchIndexApp, updatedSearchIndexApp);
        appRepository.patch(null, originalSearchIndexApp.getId(), "admin", patch);
        AppScheduler.getInstance().triggerOnDemandApplication(updatedSearchIndexApp);
        int result = this.waitAndReturnReindexingAppStatus(updatedSearchIndexApp);
        JsonPatch repatch = JsonUtils.getJsonPatch(updatedSearchIndexApp, originalSearchIndexApp);
        appRepository.patch(null, originalSearchIndexApp.getId(), "admin", repatch);
        return result;
    }

    private int waitAndReturnReindexingAppStatus(App searchIndexApp) {
        AppRunRecord appRunRecord;
        do {
            try {
                AppRepository appRepository = (AppRepository)Entity.getEntityRepository("app");
                appRunRecord = appRepository.getLatestAppRuns(searchIndexApp.getId());
                if (!this.isRunCompleted(appRunRecord)) continue;
                ArrayList<String> columns = new ArrayList<String>(List.of("status", "startTime", "endTime", "executionTime", "success", "failure"));
                ArrayList<List<String>> rows = new ArrayList<List<String>>();
                rows.add(Arrays.asList(this.getValueOrUnavailable(appRunRecord.getStatus().value()), this.getValueOrUnavailable(appRunRecord.getStartTime()), this.getValueOrUnavailable(appRunRecord.getEndTime()), this.getValueOrUnavailable(appRunRecord.getExecutionTime()), this.getValueOrUnavailable(appRunRecord.getSuccessContext()), this.getValueOrUnavailable(appRunRecord.getFailureContext())));
                OpenMetadataOperations.printToAsciiTable(columns, rows, "Failed to run Search Reindexing");
            }
            catch (UnhandledServerException e) {
                LOG.info("Reindexing Status not available yet, waiting for 10 seconds to fetch the status again.");
                appRunRecord = null;
                Thread.sleep(10000L);
            }
        } while (!this.isRunCompleted(appRunRecord));
        if (appRunRecord.getStatus().equals((Object)AppRunRecord.Status.SUCCESS) || appRunRecord.getStatus().equals((Object)AppRunRecord.Status.COMPLETED)) {
            LOG.debug("Reindexing Completed Successfully.");
            return 0;
        }
        LOG.error("Reindexing completed in Failure.");
        return 1;
    }

    public String getValueOrUnavailable(Object obj) {
        return CommonUtil.nullOrEmpty((Object)obj) ? "Unavailable" : JsonUtils.pojoToJson(obj);
    }

    boolean isRunCompleted(AppRunRecord appRunRecord) {
        if (appRunRecord == null) {
            return false;
        }
        return appRunRecord.getStatus().equals((Object)AppRunRecord.Status.SUCCESS) || appRunRecord.getStatus().equals((Object)AppRunRecord.Status.FAILED);
    }

    @CommandLine.Command(name="deploy-pipelines", description={"Deploy all the service pipelines."})
    public Integer deployPipelines() {
        try {
            LOG.info("Deploying Pipelines");
            this.parseConfig();
            PipelineServiceClient pipelineServiceClient = PipelineServiceClientFactory.createPipelineServiceClient(this.config.getPipelineServiceClientConfiguration());
            IngestionPipelineRepository pipelineRepository = (IngestionPipelineRepository)Entity.getEntityRepository("ingestionPipeline");
            List pipelines = pipelineRepository.listAll(new EntityUtil.Fields(Set.of("owner", "service")), new ListFilter(Include.NON_DELETED));
            LOG.debug(String.format("Pipelines %d", pipelines.size()));
            List<String> columns = Arrays.asList("Name", "Type", "Service Name", "Status");
            ArrayList<List<String>> pipelineStatuses = new ArrayList<List<String>>();
            for (IngestionPipeline pipeline : pipelines) {
                this.deployPipeline(pipeline, pipelineServiceClient, pipelineStatuses);
            }
            OpenMetadataOperations.printToAsciiTable(columns, pipelineStatuses, "No Pipelines Found");
            return 0;
        }
        catch (Exception e) {
            LOG.error("Failed to deploy pipelines due to ", (Throwable)e);
            return 1;
        }
    }

    @CommandLine.Command(name="migrate-secrets", description={"Migrate secrets from DB to the configured Secrets Manager. Note that this does not support migrating between external Secrets Managers"})
    public Integer migrateSecrets() {
        try {
            LOG.info("Migrating Secrets from DB...");
            this.parseConfig();
            new SecretsManagerUpdateService(this.secretsManager, this.config.getClusterName()).updateEntities();
            return 0;
        }
        catch (Exception e) {
            LOG.error("Failed to migrate secrets due to ", (Throwable)e);
            return 1;
        }
    }

    @CommandLine.Command(name="analyze-tables", description={"Migrate secrets from DB to the configured Secrets Manager. Note that this does not support migrating between external Secrets Managers"})
    public Integer analyzeTables() {
        try {
            LOG.info("Analyzing Tables...");
            this.parseConfig();
            Entity.getEntityList().forEach(this::analyzeEntityTable);
            return 0;
        }
        catch (Exception e) {
            LOG.error("Failed to analyze tables due to ", (Throwable)e);
            return 1;
        }
    }

    private void analyzeEntityTable(String entity) {
        try {
            EntityRepository<? extends EntityInterface> repository = Entity.getEntityRepository(entity);
            LOG.info("Analyzing table for [{}] Entity", (Object)entity);
            repository.getDao().analyzeTable();
        }
        catch (EntityNotFoundException e) {
            LOG.debug("No repository for [{}] Entity", (Object)entity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deployPipeline(IngestionPipeline pipeline, PipelineServiceClient pipelineServiceClient, List<List<String>> pipelineStatuses) {
        try {
            LOG.debug(String.format("deploying pipeline %s", pipeline.getName()));
            pipeline.setOpenMetadataServerConnection(new OpenMetadataConnectionBuilder(this.config).build());
            this.secretsManager.decryptIngestionPipeline(pipeline);
            OpenMetadataConnection openMetadataServerConnection = new OpenMetadataConnectionBuilder(this.config).build();
            pipeline.setOpenMetadataServerConnection(this.secretsManager.encryptOpenMetadataConnection(openMetadataServerConnection, false));
            ServiceEntityInterface service = (ServiceEntityInterface)Entity.getEntity(pipeline.getService(), "", Include.NON_DELETED);
            pipelineServiceClient.deployPipeline(pipeline, service);
        }
        catch (Exception e) {
            try {
                LOG.error(String.format("Failed to deploy pipeline %s of type %s for service %s", pipeline.getName(), pipeline.getPipelineType().value(), pipeline.getService().getName()), (Throwable)e);
                pipeline.setDeployed(Boolean.valueOf(false));
            }
            catch (Throwable throwable) {
                LOG.debug("update the pipeline");
                this.collectionDAO.ingestionPipelineDAO().update((EntityInterface)pipeline);
                pipelineStatuses.add(Arrays.asList(pipeline.getName(), pipeline.getPipelineType().value(), pipeline.getService().getName(), pipeline.getDeployed().toString()));
                throw throwable;
            }
            LOG.debug("update the pipeline");
            this.collectionDAO.ingestionPipelineDAO().update((EntityInterface)pipeline);
            pipelineStatuses.add(Arrays.asList(pipeline.getName(), pipeline.getPipelineType().value(), pipeline.getService().getName(), pipeline.getDeployed().toString()));
        }
        LOG.debug("update the pipeline");
        this.collectionDAO.ingestionPipelineDAO().update((EntityInterface)pipeline);
        pipelineStatuses.add(Arrays.asList(pipeline.getName(), pipeline.getPipelineType().value(), pipeline.getService().getName(), pipeline.getDeployed().toString()));
    }

    private void parseConfig() throws Exception {
        if (this.debug) {
            ch.qos.logback.classic.Logger root = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"ROOT");
            root.setLevel(Level.DEBUG);
        }
        ObjectMapper objectMapper = Jackson.newObjectMapper();
        Validator validator = Validators.newValidator();
        YamlConfigurationFactory factory = new YamlConfigurationFactory(OpenMetadataApplicationConfig.class, validator, objectMapper, "dw");
        this.config = (OpenMetadataApplicationConfig)((Object)factory.build((ConfigurationSourceProvider)new SubstitutingSourceProvider((ConfigurationSourceProvider)new FileConfigurationSourceProvider(), (StringSubstitutor)new EnvironmentVariableSubstitutor(false)), this.configFilePath));
        Fernet.getInstance().setFernetKey(this.config);
        DataSourceFactory dataSourceFactory = this.config.getDataSourceFactory();
        if (dataSourceFactory == null) {
            throw new IllegalArgumentException("No database in config file");
        }
        DatabaseAuthenticationProviderFactory.get(dataSourceFactory.getUrl()).ifPresent(databaseAuthenticationProvider -> {
            String token = databaseAuthenticationProvider.authenticate(dataSourceFactory.getUrl(), dataSourceFactory.getUser(), dataSourceFactory.getPassword());
            dataSourceFactory.setPassword(token);
        });
        String jdbcUrl = dataSourceFactory.getUrl();
        String user = dataSourceFactory.getUser();
        String password = dataSourceFactory.getPassword();
        assert (user != null && password != null);
        String flywayRootPath = this.config.getMigrationConfiguration().getFlywayPath();
        String location = "filesystem:" + flywayRootPath + File.separator + this.config.getDataSourceFactory().getDriverClass();
        this.flyway = Flyway.configure().encoding(StandardCharsets.UTF_8).table("DATABASE_CHANGE_LOG").sqlMigrationPrefix("v").validateOnMigrate(false).outOfOrder(false).baselineOnMigrate(true).baselineVersion(MigrationVersion.fromVersion((String)"000")).cleanOnValidationError(false).locations(new String[]{location}).dataSource(jdbcUrl, user, password).cleanDisabled(false).load();
        this.nativeSQLScriptRootPath = this.config.getMigrationConfiguration().getNativePath();
        this.extensionSQLScriptRootPath = this.config.getMigrationConfiguration().getExtensionPath();
        this.jdbi = Jdbi.create((String)jdbcUrl, (String)user, (String)password);
        this.jdbi.installPlugin((JdbiPlugin)new SqlObjectPlugin());
        ((SqlObjects)this.jdbi.getConfig(SqlObjects.class)).setSqlLocator((SqlLocator)new ConnectionAwareAnnotationSqlLocator(this.config.getDataSourceFactory().getDriverClass()));
        this.searchRepository = new SearchRepository(this.config.getElasticSearchConfiguration());
        this.secretsManager = SecretsManagerFactory.createSecretsManager(this.config.getSecretsManagerConfiguration(), this.config.getClusterName());
        this.collectionDAO = (CollectionDAO)this.jdbi.onDemand(CollectionDAO.class);
        Entity.setCollectionDAO(this.collectionDAO);
        Entity.initializeRepositories(this.config, this.jdbi);
    }

    private void promptUserForDelete() {
        LOG.info("You are about drop all the data in the database. ALL METADATA WILL BE DELETED. \nThis is not recommended for a Production setup or any deployment where you have collected \na lot of information from the users, such as descriptions, tags, etc.\n");
        String input = "";
        Scanner scanner = new Scanner(System.in);
        while (!input.equals("DELETE")) {
            LOG.info("Enter QUIT to quit. If you still want to continue, please enter DELETE: ");
            input = scanner.next();
            if (!input.equals("QUIT")) continue;
            LOG.info("Exiting without deleting data");
            System.exit(1);
        }
    }

    private void validateAndRunSystemDataMigrations(boolean force) {
        ConnectionType connType = ConnectionType.from(this.config.getDataSourceFactory().getDriverClass());
        DatasourceConfig.initialize(connType.label);
        MigrationWorkflow workflow = new MigrationWorkflow(this.jdbi, this.nativeSQLScriptRootPath, connType, this.extensionSQLScriptRootPath, force);
        workflow.loadMigrations();
        workflow.printMigrationInfo();
        workflow.runMigrationWorkflows();
    }

    public static void printToAsciiTable(List<String> columns, List<List<String>> rows, String emptyText) {
        LOG.info(new AsciiTable(columns, rows, true, "", emptyText).render());
    }

    private void printChangeLog() {
        MigrationDAO migrationDAO = (MigrationDAO)this.jdbi.onDemand(MigrationDAO.class);
        List<MigrationDAO.ServerChangeLog> serverChangeLogs = migrationDAO.listMetricsFromDBMigrations();
        LinkedHashSet<String> columns = new LinkedHashSet<String>(Set.of("version", "installedOn"));
        ArrayList<List<String>> rows = new ArrayList<List<String>>();
        try {
            for (MigrationDAO.ServerChangeLog serverChangeLog : serverChangeLogs) {
                ArrayList<String> row = new ArrayList<String>();
                if (serverChangeLog.getMetrics() == null) continue;
                JsonObject metricsJson = (JsonObject)new Gson().fromJson(serverChangeLog.getMetrics(), JsonObject.class);
                Set keys = metricsJson.keySet();
                columns.addAll(keys);
                row.add(serverChangeLog.getVersion());
                row.add(serverChangeLog.getInstalledOn());
                row.addAll(metricsJson.entrySet().stream().map(Map.Entry::getValue).map(JsonElement::toString).toList());
                rows.add(row);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to generate migration metrics due to", (Throwable)e);
        }
        OpenMetadataOperations.printToAsciiTable(columns.stream().toList(), rows, "No Server Change log found");
    }

    public static void main(String ... args) {
        LOG.info(AsciiTable.printOpenMetadataText());
        int exitCode = new CommandLine((Object)new OpenMetadataOperations()).execute(args);
        System.exit(exitCode);
    }
}

