/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.workflows.searchIndex;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.glassfish.jersey.internal.util.ExceptionUtils;
import org.openmetadata.schema.analytics.ReportData;
import org.openmetadata.schema.system.EntityError;
import org.openmetadata.schema.system.IndexingError;
import org.openmetadata.schema.system.StepStats;
import org.openmetadata.service.exception.SearchIndexException;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.RestUtil;
import org.openmetadata.service.util.ResultList;
import org.openmetadata.service.workflows.interfaces.Source;
import org.openmetadata.service.workflows.searchIndex.ReindexingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaginatedDataInsightSource
implements Source<ResultList<ReportData>> {
    private static final Logger LOG = LoggerFactory.getLogger(PaginatedDataInsightSource.class);
    private final CollectionDAO dao;
    private final String entityType;
    private final int batchSize;
    private final List<String> readerErrors = new ArrayList<String>();
    private final StepStats stats = new StepStats();
    private String cursor = null;
    private boolean isDone = false;

    public PaginatedDataInsightSource(CollectionDAO dao, String entityType, int batchSize) {
        this.dao = dao;
        this.entityType = entityType;
        this.batchSize = batchSize;
        this.stats.withTotalRecords(Integer.valueOf(dao.reportDataTimeSeriesDao().listCount((ListFilter)new ListFilter(null).addQueryParam("entityFQNHash", entityType)))).withSuccessRecords(Integer.valueOf(0)).withFailedRecords(Integer.valueOf(0));
    }

    @Override
    public ResultList<ReportData> readNext(Map<String, Object> contextData) throws SearchIndexException {
        if (!this.isDone) {
            ResultList<ReportData> data = this.read(this.cursor);
            this.cursor = data.getPaging().getAfter();
            if (this.cursor == null) {
                this.isDone = true;
            }
            return data;
        }
        return null;
    }

    @Override
    public void reset() {
        this.cursor = null;
        this.isDone = false;
    }

    private ResultList<ReportData> read(String afterCursor) throws SearchIndexException {
        LOG.debug("[DataInsightReader] Fetching a Batch of Size: {} ", (Object)this.batchSize);
        ResultList<ReportData> result = null;
        try {
            result = this.getReportDataPagination(this.entityType, this.batchSize, afterCursor);
            LOG.debug("[DataInsightReader] Batch Stats :- Submitted : {} Success: {} Failed: {}", new Object[]{this.batchSize, result.getData().size(), 0});
        }
        catch (Exception ex) {
            IndexingError indexingError = new IndexingError().withErrorSource(IndexingError.ErrorSource.READER).withSubmittedCount(Integer.valueOf(this.batchSize)).withSuccessCount(Integer.valueOf(0)).withFailedCount(Integer.valueOf(this.batchSize)).withMessage("Issues in Reading A Batch For Data Insight Data.").withStackTrace(ExceptionUtils.exceptionStackTraceAsString((Throwable)ex));
            LOG.debug("[DataInsightReader] Failing Completely. Details : {}", (Object)JsonUtils.pojoToJson(indexingError));
            if (result != null) {
                if (result.getPaging().getAfter() == null) {
                    this.isDone = true;
                    int recordToRead = this.stats.getTotalRecords() - (this.stats.getSuccessRecords() + this.stats.getFailedRecords());
                    this.updateStats(result.getData().size(), recordToRead - result.getData().size());
                } else {
                    this.updateStats(result.getData().size(), this.batchSize - result.getData().size());
                }
            } else {
                this.updateStats(0, this.batchSize);
            }
            throw new SearchIndexException(indexingError);
        }
        return result;
    }

    public ResultList<ReportData> getReportDataPagination(String entityFQN, int limit, String after) {
        int reportDataCount = this.dao.reportDataTimeSeriesDao().listCount((ListFilter)new ListFilter(null).addQueryParam("entityFQNHash", entityFQN));
        List<CollectionDAO.ReportDataRow> reportDataList = this.dao.reportDataTimeSeriesDao().getAfterExtension(entityFQN, limit + 1, after == null ? "0" : RestUtil.decodeCursor(after));
        return this.getAfterExtensionList(reportDataList, after, limit, reportDataCount);
    }

    private ResultList<ReportData> getAfterExtensionList(List<CollectionDAO.ReportDataRow> reportDataRowList, String after, int limit, int total) {
        String beforeCursor;
        String afterCursor = null;
        String string = beforeCursor = after == null ? null : reportDataRowList.get(0).getRowNum();
        if (reportDataRowList.size() > limit) {
            reportDataRowList.remove(limit);
            afterCursor = reportDataRowList.get(limit - 1).getRowNum();
        }
        ArrayList<ReportData> reportDataList = new ArrayList<ReportData>();
        for (CollectionDAO.ReportDataRow reportDataRow : reportDataRowList) {
            reportDataList.add(reportDataRow.getReportData());
        }
        return new ResultList<ReportData>(reportDataList, new ArrayList<EntityError>(), beforeCursor, afterCursor, total);
    }

    @Override
    public void updateStats(int currentSuccess, int currentFailed) {
        ReindexingUtil.getUpdatedStats(this.stats, currentSuccess, currentFailed);
    }

    public String getEntityType() {
        return this.entityType;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public List<String> getReaderErrors() {
        return this.readerErrors;
    }

    @Override
    public StepStats getStats() {
        return this.stats;
    }

    public boolean isDone() {
        return this.isDone;
    }
}

