/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.dataInsight;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.openmetadata.schema.dataInsight.type.PageViewsByEntities;
import org.openmetadata.service.dataInsight.DataInsightAggregatorInterface;

public abstract class PageViewsByEntitiesAggregator<A, B, M, S>
implements DataInsightAggregatorInterface {
    private final A aggregations;

    protected PageViewsByEntitiesAggregator(A aggregations) {
        this.aggregations = aggregations;
    }

    @Override
    public List<Object> aggregate() throws ParseException {
        M timestampBuckets = this.getTimestampBuckets(this.aggregations);
        ArrayList<Object> data = new ArrayList<Object>();
        for (B timestampBucket : this.getBuckets(timestampBuckets)) {
            String dateTimeString = this.getKeyAsString(timestampBucket);
            Long timestamp = this.convertDatTimeStringToTimestamp(dateTimeString);
            M entityTypeBuckets = this.getEntityBuckets(timestampBucket);
            for (B entityTypeBucket : this.getBuckets(entityTypeBuckets)) {
                String entityType = this.getKeyAsString(entityTypeBucket);
                S sumPageViews = this.getSumAggregations(entityTypeBucket, "pageViews");
                data.add(new PageViewsByEntities().withEntityType(entityType).withTimestamp(timestamp).withPageViews(this.getValue(sumPageViews)));
            }
        }
        return data;
    }

    protected abstract Double getValue(S var1);

    protected abstract S getSumAggregations(B var1, String var2);

    protected abstract M getEntityBuckets(B var1);

    protected abstract String getKeyAsString(B var1);

    protected abstract List<? extends B> getBuckets(M var1);

    protected abstract M getTimestampBuckets(A var1);
}

