/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.teams;

import io.dropwizard.jersey.PATCH;
import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import javax.json.JsonPatch;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.api.data.RestoreEntity;
import org.openmetadata.schema.api.teams.CreateRole;
import org.openmetadata.schema.entity.teams.Role;
import org.openmetadata.schema.type.EntityHistory;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.MetadataOperation;
import org.openmetadata.service.Entity;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.jdbi3.RoleRepository;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.resources.EntityResource;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.RestUtil;
import org.openmetadata.service.util.ResultList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/roles")
@Tag(name="Roles", description="A `Role` is a collection of `Policies` that provides access control. A user or a team can be assigned one or multiple roles that provide privileges to a user and members of a team to perform the job function.")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="roles", order=1, requiredForOps=true)
public class RoleResource
extends EntityResource<Role, RoleRepository> {
    private static final Logger LOG = LoggerFactory.getLogger(RoleResource.class);
    public static final String COLLECTION_PATH = "/v1/roles/";
    public static final String FIELDS = "policies,teams,users";

    @Override
    public Role addHref(UriInfo uriInfo, Role role) {
        super.addHref(uriInfo, role);
        Entity.withHref(uriInfo, role.getPolicies());
        Entity.withHref(uriInfo, role.getTeams());
        Entity.withHref(uriInfo, role.getUsers());
        return role;
    }

    public RoleResource(Authorizer authorizer) {
        super("role", authorizer);
    }

    @Override
    protected List<MetadataOperation> getEntitySpecificOperations() {
        this.addViewOperation(FIELDS, MetadataOperation.VIEW_BASIC);
        return null;
    }

    @Override
    public void initialize(OpenMetadataApplicationConfig config) throws IOException {
        List roles = ((RoleRepository)this.repository).getEntitiesFromSeedData();
        for (Role role : roles) {
            role.setFullyQualifiedName(role.getName());
            List policies = role.getPolicies();
            for (EntityReference policy : policies) {
                EntityReference ref = Entity.getEntityReferenceByName("policy", policy.getName(), Include.NON_DELETED);
                policy.setId(ref.getId());
            }
            ((RoleRepository)this.repository).initializeEntity(role);
        }
    }

    @GET
    @Valid
    @Operation(operationId="listRoles", summary="List roles", description="Get a list of roles. Use cursor-based pagination to limit the number of entries in the list using `limit` and `before` or `after` query params.", responses={@ApiResponse(responseCode="200", description="List of roles", content={@Content(mediaType="application/json", schema=@Schema(implementation=RoleList.class))})})
    public ResultList<Role> list(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="List only default role(s)", schema=@Schema(type="boolean", example="true")) @QueryParam(value="default") boolean defaultParam, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="policies,teams,users")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Limit the number tables returned. (1 to 1000000, default = 10)") @DefaultValue(value="10") @Min(value=0L) @Max(value=1000000L) @QueryParam(value="limit") @Min(value=0L) @Max(value=1000000L) int limitParam, @Parameter(description="Returns list of tables before this cursor", schema=@Schema(type="string")) @QueryParam(value="before") String before, @Parameter(description="Returns list of tables after this cursor", schema=@Schema(type="string")) @QueryParam(value="after") String after, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        RestUtil.validateCursors(before, after);
        EntityUtil.Fields fields = this.getFields(fieldsParam);
        ListFilter filter = new ListFilter(include);
        ResultList roles = before != null ? ((RoleRepository)this.repository).listBefore(uriInfo, fields, filter, limitParam, before) : ((RoleRepository)this.repository).listAfter(uriInfo, fields, filter, limitParam, after);
        return this.addHref(uriInfo, roles);
    }

    @GET
    @Path(value="/{id}/versions")
    @Operation(operationId="listAllRoleVersion", summary="List role versions", description="Get a list of all the versions of a role identified by `id`", responses={@ApiResponse(responseCode="200", description="List of role versions", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntityHistory.class))})})
    public EntityHistory listVersions(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the role", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) {
        return super.listVersionsInternal(securityContext, id);
    }

    @GET
    @Valid
    @Path(value="/{id}")
    @Operation(operationId="getRoleByID", summary="Get a role by id", description="Get a role by `id`.", responses={@ApiResponse(responseCode="200", description="The role", content={@Content(mediaType="application/json", schema=@Schema(implementation=Role.class))}), @ApiResponse(responseCode="404", description="Role for instance {id} is not found")})
    public Role get(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the role", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="policies,teams,users")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        return (Role)this.getInternal(uriInfo, securityContext, id, fieldsParam, include);
    }

    @GET
    @Valid
    @Path(value="/name/{name}")
    @Operation(operationId="getRoleByFQN", summary="Get a role by name", description="Get a role by `name`.", responses={@ApiResponse(responseCode="200", description="The role", content={@Content(mediaType="application/json", schema=@Schema(implementation=Role.class))}), @ApiResponse(responseCode="404", description="Role for instance {name} is not found")})
    public Role getByName(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Name of the role", schema=@Schema(type="string")) @PathParam(value="name") String name, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="policies,teams,users")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        return (Role)this.getByNameInternal(uriInfo, securityContext, name, fieldsParam, include);
    }

    @GET
    @Path(value="/{id}/versions/{version}")
    @Operation(operationId="getSpecificRoleVersion", summary="Get a version of the role", description="Get a version of the role by given `id`", responses={@ApiResponse(responseCode="200", description="role", content={@Content(mediaType="application/json", schema=@Schema(implementation=Role.class))}), @ApiResponse(responseCode="404", description="Role for instance {id} and version {version} is not found")})
    public Role getVersion(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the role", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Role version number in the form `major`.`minor`", schema=@Schema(type="string", example="0.1 or 1.1")) @PathParam(value="version") String version) {
        return (Role)super.getVersionInternal(securityContext, id, version);
    }

    @Override
    @POST
    @Operation(operationId="createRole", summary="Create a role", description="Create a new role.", responses={@ApiResponse(responseCode="200", description="The role", content={@Content(mediaType="application/json", schema=@Schema(implementation=Role.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response create(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateRole createRole) {
        Role role = this.getRole(createRole, securityContext.getUserPrincipal().getName());
        return this.create(uriInfo, securityContext, role);
    }

    @PUT
    @Operation(operationId="createOrUpdateRole", summary="Update role", description="Create or Update a role.", responses={@ApiResponse(responseCode="200", description="The role ", content={@Content(mediaType="application/json", schema=@Schema(implementation=Role.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response createOrUpdateRole(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateRole createRole) {
        Role role = this.getRole(createRole, securityContext.getUserPrincipal().getName());
        return this.createOrUpdate(uriInfo, securityContext, role);
    }

    @PATCH
    @Path(value="/{id}")
    @Consumes(value={"application/json-patch+json"})
    @Operation(operationId="patchRole", summary="Update a role", description="Update an existing role with JsonPatch.", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"))
    public Response patch(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the role", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @RequestBody(description="JsonPatch with array of operations", content={@Content(mediaType="application/json-patch+json", examples={@ExampleObject(value="[{op:remove, path:/a},{op:add, path: /b, value: val}]")})}) JsonPatch patch) {
        return this.patchInternal(uriInfo, securityContext, id, patch);
    }

    @PATCH
    @Path(value="/name/{fqn}")
    @Consumes(value={"application/json-patch+json"})
    @Operation(operationId="patchRole", summary="Update a role using name.", description="Update an existing role with JsonPatch.", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"))
    public Response patch(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Name of the role", schema=@Schema(type="string")) @PathParam(value="fqn") String fqn, @RequestBody(description="JsonPatch with array of operations", content={@Content(mediaType="application/json-patch+json", examples={@ExampleObject(value="[{op:remove, path:/a},{op:add, path: /b, value: val}]")})}) JsonPatch patch) {
        return this.patchInternal(uriInfo, securityContext, fqn, patch);
    }

    @DELETE
    @Path(value="/{id}")
    @Operation(operationId="deleteRole", summary="Delete a role", description="Delete a role by given `id`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Role for instance {id} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Id of the role", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) {
        return this.delete(uriInfo, securityContext, id, true, hardDelete);
    }

    @DELETE
    @Path(value="/name/{name}")
    @Operation(operationId="deleteRoleByName", summary="Delete a role", description="Delete a role by given `name`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Role for instance {name} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Name of the role", schema=@Schema(type="string")) @PathParam(value="name") String name) {
        return this.deleteByName(uriInfo, securityContext, name, false, hardDelete);
    }

    @PUT
    @Path(value="/restore")
    @Operation(operationId="restore", summary="Restore a soft deleted role", description="Restore a soft deleted role.", responses={@ApiResponse(responseCode="200", description="Successfully restored the Role. ", content={@Content(mediaType="application/json", schema=@Schema(implementation=Role.class))})})
    public Response restoreRole(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid RestoreEntity restore) {
        return this.restoreEntity(uriInfo, securityContext, restore.getId());
    }

    private Role getRole(CreateRole create, String user) {
        if (CommonUtil.nullOrEmpty((List)create.getPolicies())) {
            throw new IllegalArgumentException("At least one policy is required to create a role");
        }
        return ((RoleRepository)this.repository).copy(new Role(), (CreateEntity)create, user).withPolicies(RoleResource.getEntityReferences("policy", create.getPolicies()));
    }

    public static EntityReference getRole(String roleName) {
        RoleRepository roleRepository = (RoleRepository)Entity.getEntityRepository("role");
        return roleRepository.getReferenceByName(roleName, Include.NON_DELETED);
    }

    public static class RoleList
    extends ResultList<Role> {
    }
}

