/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.Chart;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;

public record ChartIndex(Chart chart) implements SearchIndex
{
    @Override
    public List<SearchSuggest> getSuggest() {
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.chart.getName()).weight(10).build());
        suggest.add(SearchSuggest.builder().input(this.chart.getFullyQualifiedName()).weight(5).build());
        return suggest;
    }

    @Override
    public Object getEntity() {
        return this.chart;
    }

    @Override
    public Map<String, Object> buildSearchIndexDocInternal(Map<String, Object> esDoc) {
        Map<String, Object> commonAttributes = this.getCommonAttributesMap((EntityInterface)this.chart, "chart");
        esDoc.putAll(commonAttributes);
        return esDoc;
    }
}

