/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.Query;
import org.openmetadata.service.Entity;
import org.openmetadata.service.search.ParseTags;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;

public class QueryIndex
implements SearchIndex {
    final Query query;

    public QueryIndex(Query query) {
        this.query = query;
    }

    @Override
    public List<SearchSuggest> getSuggest() {
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        if (this.query.getDisplayName() != null) {
            suggest.add(SearchSuggest.builder().input(this.query.getName()).weight(10).build());
        }
        return suggest;
    }

    @Override
    public Object getEntity() {
        return this.query;
    }

    @Override
    public Map<String, Object> buildSearchIndexDocInternal(Map<String, Object> doc) {
        ParseTags parseTags = new ParseTags(Entity.getEntityTags("query", (EntityInterface)this.query));
        Map<String, Object> commonAttributes = this.getCommonAttributesMap((EntityInterface)this.query, "query");
        doc.putAll(commonAttributes);
        doc.put("displayName", this.query.getDisplayName() != null ? this.query.getDisplayName() : "");
        doc.put("tags", parseTags.getTags());
        doc.put("tier", parseTags.getTierTag());
        return doc;
    }

    public static Map<String, Float> getFields() {
        Map<String, Float> fields = SearchIndex.getDefaultFields();
        fields.put("query", Float.valueOf(10.0f));
        fields.put("query.ngram", Float.valueOf(1.0f));
        return fields;
    }
}

