/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.security.mask;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.ws.rs.core.SecurityContext;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.entity.data.Query;
import org.openmetadata.schema.entity.data.SearchIndex;
import org.openmetadata.schema.entity.data.Table;
import org.openmetadata.schema.entity.data.Topic;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.tests.TestCase;
import org.openmetadata.schema.type.Column;
import org.openmetadata.schema.type.ColumnProfile;
import org.openmetadata.schema.type.Field;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.TableData;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.schema.type.searchindex.SearchIndexSampleData;
import org.openmetadata.schema.type.topic.TopicSampleData;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.ColumnUtil;
import org.openmetadata.service.jdbi3.TopicRepository;
import org.openmetadata.service.resources.feeds.MessageParser;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.util.FullyQualifiedName;
import org.openmetadata.service.util.ResultList;

public class PIIMasker {
    public static final String SENSITIVE_PII_TAG = "PII.Sensitive";
    public static final String MASKED_VALUE = "********";
    public static final String MASKED_NAME = "[MASKED]";
    public static final String MASKED_MAIL = "********@masked.com";

    private PIIMasker() {
    }

    public static TableData maskSampleData(TableData sampleData, Table table, List<Column> columns) {
        if (sampleData == null) {
            return null;
        }
        List<Integer> columnsPositionToBeMasked = PIIMasker.hasPiiSensitiveTag(table) ? IntStream.range(0, columns.size()).boxed().collect(Collectors.toList()) : columns.stream().collect(Collectors.toMap(Function.identity(), c -> sampleData.getColumns().indexOf(c.getName()))).entrySet().stream().filter(entry -> PIIMasker.hasPiiSensitiveTag((Column)entry.getKey())).map(Map.Entry::getValue).collect(Collectors.toList());
        sampleData.setRows(sampleData.getRows().stream().map(r -> PIIMasker.maskSampleDataRow(r, columnsPositionToBeMasked)).collect(Collectors.toList()));
        List sampleDataColumns = sampleData.getColumns();
        columnsPositionToBeMasked.forEach(position -> sampleDataColumns.set((int)position, PIIMasker.flagMaskedName((String)sampleDataColumns.get((int)position))));
        return sampleData;
    }

    public static Table getSampleData(Table table) {
        TableData sampleData = PIIMasker.maskSampleData(table.getSampleData(), table, table.getColumns());
        table.setSampleData(sampleData);
        return table;
    }

    public static Topic getSampleData(Topic topic) {
        TopicSampleData sampleData = topic.getSampleData();
        if (sampleData == null) {
            return topic;
        }
        if (PIIMasker.hasPiiSensitiveTag(topic)) {
            sampleData.setMessages(List.of(MASKED_VALUE));
            topic.setSampleData(sampleData);
        }
        return topic;
    }

    public static SearchIndex getSampleData(SearchIndex searchIndex) {
        SearchIndexSampleData sampleData = searchIndex.getSampleData();
        if (sampleData == null) {
            return searchIndex;
        }
        if (PIIMasker.hasPiiSensitiveTag(searchIndex)) {
            sampleData.setMessages(List.of(MASKED_VALUE));
            searchIndex.setSampleData(sampleData);
        }
        return searchIndex;
    }

    public static Table getTableProfile(Table table) {
        for (Column column : table.getColumns()) {
            if (!PIIMasker.hasPiiSensitiveTag(column)) continue;
            column.setProfile(null);
            column.setName(PIIMasker.flagMaskedName(column.getName()));
        }
        return table;
    }

    public static List<ColumnProfile> getColumnProfile(String fqn, List<ColumnProfile> columnProfiles) {
        Table table = (Table)Entity.getEntityByName("table", FullyQualifiedName.getTableFQN(fqn), "columns,tags", Include.ALL);
        Column column = table.getColumns().stream().filter(c -> c.getFullyQualifiedName().equals(fqn)).findFirst().orElse(null);
        if (column != null && PIIMasker.hasPiiSensitiveTag(column)) {
            return Collections.nCopies(columnProfiles.size(), new ColumnProfile());
        }
        return columnProfiles;
    }

    private static TestCase getTestCase(Column column, TestCase testCase) {
        if (!PIIMasker.hasPiiSensitiveTag(column)) {
            return testCase;
        }
        testCase.setTestCaseResult(null);
        testCase.setParameterValues(null);
        testCase.setDescription(null);
        testCase.setName(PIIMasker.flagMaskedName(testCase.getName()));
        return testCase;
    }

    public static ResultList<TestCase> getTestCases(ResultList<TestCase> testCases, Authorizer authorizer, SecurityContext securityContext) {
        HashMap entityFQNToTable = new HashMap();
        List maskedTests = testCases.getData().stream().map(testCase -> {
            Table table;
            MessageParser.EntityLink testCaseLink = MessageParser.EntityLink.parse(testCase.getEntityLink());
            if (entityFQNToTable.containsKey(testCaseLink.getEntityFQN())) {
                table = (Table)entityFQNToTable.get(testCaseLink.getEntityFQN());
            } else {
                table = (Table)Entity.getEntityByName("table", testCaseLink.getEntityFQN(), "owner,tags,columns", Include.NON_DELETED);
                entityFQNToTable.put(testCaseLink.getEntityFQN(), table);
            }
            if (testCaseLink.getFieldName() == null) {
                return testCase;
            }
            Optional<Column> referencedColumn = table.getColumns().stream().filter(col -> testCaseLink.getFullyQualifiedFieldValue().equals(col.getFullyQualifiedName())).findFirst();
            if (referencedColumn.isPresent()) {
                Column col2 = referencedColumn.get();
                boolean authorizePII = authorizer.authorizePII(securityContext, table.getOwner());
                if (!authorizePII) {
                    return PIIMasker.getTestCase(col2, testCase);
                }
                return testCase;
            }
            return testCase;
        }).collect(Collectors.toList());
        testCases.setData(maskedTests);
        return testCases;
    }

    private static Query getQuery(Query query) {
        if (!PIIMasker.hasPiiSensitiveTag(query)) {
            return query;
        }
        query.setQuery(MASKED_VALUE);
        return query;
    }

    public static ResultList<Query> getQueries(ResultList<Query> queries, Authorizer authorizer, SecurityContext securityContext) {
        List maskedQueries = queries.getData().stream().map(query -> {
            boolean authorizePII = authorizer.authorizePII(securityContext, query.getOwner());
            if (!authorizePII) {
                return PIIMasker.getQuery(query);
            }
            return query;
        }).collect(Collectors.toList());
        queries.setData(maskedQueries);
        return queries;
    }

    private static boolean hasPiiSensitiveTag(Query query) {
        return query.getTags().stream().map(TagLabel::getTagFQN).anyMatch(SENSITIVE_PII_TAG::equals);
    }

    private static boolean hasPiiSensitiveTag(Column column) {
        return ColumnUtil.getAllTags(column).stream().anyMatch(SENSITIVE_PII_TAG::equals);
    }

    private static boolean hasPiiSensitiveTag(Table table) {
        return table.getTags().stream().map(TagLabel::getTagFQN).anyMatch(SENSITIVE_PII_TAG::equals);
    }

    private static boolean hasPiiSensitiveTag(SearchIndex searchIndex) {
        return searchIndex.getTags().stream().map(TagLabel::getTagFQN).anyMatch(SENSITIVE_PII_TAG::equals);
    }

    private static boolean hasPiiSensitiveTag(Topic topic) {
        if (topic.getTags().stream().map(TagLabel::getTagFQN).anyMatch(SENSITIVE_PII_TAG::equals)) {
            return true;
        }
        HashSet<TagLabel> fieldTags = new HashSet<TagLabel>();
        List schemaFields = topic.getMessageSchema() != null ? topic.getMessageSchema().getSchemaFields() : null;
        for (Field schemaField : CommonUtil.listOrEmpty((List)schemaFields)) {
            fieldTags.addAll(TopicRepository.getAllFieldTags(schemaField));
        }
        return fieldTags.stream().map(TagLabel::getTagFQN).anyMatch(SENSITIVE_PII_TAG::equals);
    }

    private static List<Object> maskSampleDataRow(List<Object> row, List<Integer> columnsPositionToBeMasked) {
        columnsPositionToBeMasked.forEach(position -> row.set((int)position, MASKED_VALUE));
        return row;
    }

    private static String flagMaskedName(String name) {
        return String.format("%s %s", name, MASKED_NAME);
    }

    public static User maskUser(Authorizer authorizer, SecurityContext securityContext, User user) {
        if (authorizer.authorizePII(securityContext, null)) {
            return user;
        }
        user.setEmail(MASKED_MAIL);
        return user;
    }
}

