/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.apps.scheduler;

import com.cronutils.mapper.CronMapper;
import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.parser.CronParser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.AppRuntime;
import org.openmetadata.schema.entity.app.App;
import org.openmetadata.schema.entity.app.AppSchedule;
import org.openmetadata.schema.entity.app.ScheduleTimeline;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.apps.AbstractNativeApplication;
import org.openmetadata.service.apps.scheduler.CustomJobFactory;
import org.openmetadata.service.apps.scheduler.OmAppJobListener;
import org.openmetadata.service.exception.UnhandledServerException;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.locator.ConnectionType;
import org.openmetadata.service.search.SearchRepository;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.JobListener;
import org.quartz.Matcher;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.spi.JobFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppScheduler {
    private static final Logger LOG = LoggerFactory.getLogger(AppScheduler.class);
    private static final Map<String, String> defaultAppScheduleConfig = new HashMap<String, String>();
    public static final String ON_DEMAND_JOB = "OnDemandJob";
    public static final String APPS_JOB_GROUP = "OMAppsJobGroup";
    public static final String APPS_TRIGGER_GROUP = "OMAppsJobGroup";
    public static final String APP_INFO_KEY = "applicationInfoKey";
    public static final String APP_NAME = "appName";
    private static AppScheduler instance;
    private static volatile boolean initialized;
    private final Scheduler scheduler;
    private static final CronMapper cronMapper;
    private static final CronParser cronParser;

    private AppScheduler(OpenMetadataApplicationConfig config, CollectionDAO dao, SearchRepository searchClient) throws SchedulerException {
        this.overrideDefaultConfig(config);
        Properties properties = new Properties();
        properties.putAll(defaultAppScheduleConfig);
        StdSchedulerFactory factory = new StdSchedulerFactory();
        factory.initialize(properties);
        this.scheduler = factory.getScheduler();
        this.scheduler.setJobFactory((JobFactory)new CustomJobFactory(dao, searchClient));
        this.scheduler.getListenerManager().addJobListener((JobListener)new OmAppJobListener(dao), (Matcher)GroupMatcher.jobGroupEquals((String)"OMAppsJobGroup"));
        this.scheduler.start();
    }

    public static void initialize(OpenMetadataApplicationConfig config, CollectionDAO dao, SearchRepository searchClient) throws SchedulerException {
        if (!initialized) {
            instance = new AppScheduler(config, dao, searchClient);
            initialized = true;
        } else {
            LOG.info("Reindexing Handler is already initialized");
        }
    }

    private void overrideDefaultConfig(OpenMetadataApplicationConfig config) {
        defaultAppScheduleConfig.put("org.quartz.dataSource.myDS.driver", config.getDataSourceFactory().getDriverClass());
        defaultAppScheduleConfig.put("org.quartz.dataSource.myDS.URL", config.getDataSourceFactory().getUrl());
        defaultAppScheduleConfig.put("org.quartz.dataSource.myDS.user", config.getDataSourceFactory().getUser());
        defaultAppScheduleConfig.put("org.quartz.dataSource.myDS.password", config.getDataSourceFactory().getPassword());
        if (ConnectionType.MYSQL.label.equals(config.getDataSourceFactory().getDriverClass())) {
            defaultAppScheduleConfig.put("org.quartz.jobStore.driverDelegateClass", "org.quartz.impl.jdbcjobstore.StdJDBCDelegate");
        } else {
            defaultAppScheduleConfig.put("org.quartz.jobStore.driverDelegateClass", "org.quartz.impl.jdbcjobstore.PostgreSQLDelegate");
        }
    }

    public static AppScheduler getInstance() {
        if (initialized) {
            return instance;
        }
        throw new UnhandledServerException("App Scheduler is not Initialized");
    }

    public void addApplicationSchedule(App application) {
        try {
            if (this.scheduler.getJobDetail(new JobKey(application.getName(), "OMAppsJobGroup")) != null) {
                LOG.info("Job already exists for the application, skipping the scheduling");
                return;
            }
            AppRuntime context = AbstractNativeApplication.getAppRuntime(application);
            if (Boolean.TRUE.equals(context.getEnabled())) {
                JobDetail jobDetail = this.jobBuilder(application, application.getName());
                if (!application.getAppSchedule().getScheduleTimeline().equals((Object)ScheduleTimeline.NONE)) {
                    Trigger trigger = this.trigger(application);
                    this.scheduler.scheduleJob(jobDetail, trigger);
                }
            } else {
                LOG.info("[Applications] App cannot be scheduled since it is disabled");
            }
        }
        catch (Exception ex) {
            LOG.error("Failed in setting up job Scheduler for Data Reporting", (Throwable)ex);
            throw new UnhandledServerException("Failed in scheduling Job for the Application", ex);
        }
    }

    public void deleteScheduledApplication(App app) throws SchedulerException {
        this.scheduler.deleteJob(new JobKey(app.getName(), "OMAppsJobGroup"));
        this.scheduler.unscheduleJob(new TriggerKey(app.getName(), "OMAppsJobGroup"));
        this.scheduler.deleteJob(new JobKey(String.format("%s-%s", app.getName(), ON_DEMAND_JOB), "OMAppsJobGroup"));
        this.scheduler.unscheduleJob(new TriggerKey(String.format("%s-%s", app.getName(), ON_DEMAND_JOB), "OMAppsJobGroup"));
    }

    private JobDetail jobBuilder(App app, String jobIdentity) throws ClassNotFoundException {
        JobDataMap dataMap = new JobDataMap();
        dataMap.put(APP_NAME, app.getName());
        dataMap.put("triggerType", app.getAppSchedule().getScheduleTimeline().value());
        Class<?> clz = Class.forName(app.getClassName());
        JobBuilder jobBuilder = JobBuilder.newJob(clz).withIdentity(jobIdentity, "OMAppsJobGroup").usingJobData(dataMap).requestRecovery(false);
        return jobBuilder.build();
    }

    private Trigger trigger(App app) {
        return TriggerBuilder.newTrigger().withIdentity(app.getName(), "OMAppsJobGroup").withSchedule((ScheduleBuilder)AppScheduler.getCronSchedule(app.getAppSchedule())).build();
    }

    public static void shutDown() throws SchedulerException {
        if (instance != null) {
            AppScheduler.instance.scheduler.shutdown();
        }
    }

    public static CronScheduleBuilder getCronSchedule(AppSchedule scheduleInfo) {
        switch (scheduleInfo.getScheduleTimeline()) {
            case HOURLY: {
                return CronScheduleBuilder.cronSchedule((String)"0 0 * ? * *");
            }
            case DAILY: {
                return CronScheduleBuilder.dailyAtHourAndMinute((int)0, (int)0);
            }
            case WEEKLY: {
                return CronScheduleBuilder.weeklyOnDayAndHourAndMinute((int)7, (int)0, (int)0);
            }
            case MONTHLY: {
                return CronScheduleBuilder.monthlyOnDayAndHourAndMinute((int)1, (int)0, (int)0);
            }
            case CUSTOM: {
                if (!CommonUtil.nullOrEmpty((String)scheduleInfo.getCronExpression())) {
                    Cron unixCron = AppScheduler.getCronParser().parse(scheduleInfo.getCronExpression());
                    return CronScheduleBuilder.cronSchedule((String)AppScheduler.getCronMapper().map(unixCron).asString());
                }
                throw new IllegalArgumentException("Missing Cron Expression for Custom Schedule.");
            }
        }
        throw new IllegalArgumentException("Invalid Trigger Info for the scheduled application.");
    }

    public void triggerOnDemandApplication(App application) {
        if (application.getFullyQualifiedName() == null) {
            throw new IllegalArgumentException("Application's fullyQualifiedName is null.");
        }
        try {
            JobDetail jobDetailScheduled = this.scheduler.getJobDetail(new JobKey(application.getName(), "OMAppsJobGroup"));
            JobDetail jobDetailOnDemand = this.scheduler.getJobDetail(new JobKey(String.format("%s-%s", application.getName(), ON_DEMAND_JOB), "OMAppsJobGroup"));
            List currentJobs = this.scheduler.getCurrentlyExecutingJobs();
            for (JobExecutionContext context : currentJobs) {
                if ((jobDetailScheduled == null || !context.getJobDetail().getKey().equals((Object)jobDetailScheduled.getKey())) && (jobDetailOnDemand == null || !context.getJobDetail().getKey().equals((Object)jobDetailOnDemand.getKey()))) continue;
                throw new UnhandledServerException("Job is already running, please wait for it to complete.");
            }
            AppRuntime context = AbstractNativeApplication.getAppRuntime(application);
            if (Boolean.TRUE.equals(context.getEnabled())) {
                JobDetail newJobDetail = this.jobBuilder(application, String.format("%s-%s", application.getName(), ON_DEMAND_JOB));
                newJobDetail.getJobDataMap().put("triggerType", ON_DEMAND_JOB);
                newJobDetail.getJobDataMap().put(APP_NAME, application.getFullyQualifiedName());
                Trigger trigger = TriggerBuilder.newTrigger().withIdentity(String.format("%s-%s", application.getName(), ON_DEMAND_JOB), "OMAppsJobGroup").startNow().build();
                this.scheduler.scheduleJob(newJobDetail, trigger);
            } else {
                LOG.info("[Applications] App cannot be scheduled since it is disabled");
            }
        }
        catch (ObjectAlreadyExistsException ex) {
            throw new UnhandledServerException("Job is already running, please wait for it to complete.");
        }
        catch (ClassNotFoundException | SchedulerException ex) {
            LOG.error("Failed in running job", ex);
        }
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public static CronMapper getCronMapper() {
        return cronMapper;
    }

    public static CronParser getCronParser() {
        return cronParser;
    }

    static {
        defaultAppScheduleConfig.put("org.quartz.scheduler.instanceName", "AppScheduler");
        defaultAppScheduleConfig.put("org.quartz.scheduler.instanceId", "AUTO");
        defaultAppScheduleConfig.put("org.quartz.scheduler.skipUpdateCheck", "true");
        defaultAppScheduleConfig.put("org.quartz.threadPool.class", "org.quartz.simpl.SimpleThreadPool");
        defaultAppScheduleConfig.put("org.quartz.threadPool.threadCount", "10");
        defaultAppScheduleConfig.put("org.quartz.threadPool.threadPriority", "5");
        defaultAppScheduleConfig.put("org.quartz.jobStore.misfireThreshold", "60000");
        defaultAppScheduleConfig.put("org.quartz.jobStore.class", "org.quartz.impl.jdbcjobstore.JobStoreTX");
        defaultAppScheduleConfig.put("org.quartz.jobStore.useProperties", "false");
        defaultAppScheduleConfig.put("org.quartz.jobStore.tablePrefix", "QRTZ_");
        defaultAppScheduleConfig.put("org.quartz.jobStore.isClustered", "true");
        defaultAppScheduleConfig.put("org.quartz.jobStore.dataSource", "myDS");
        defaultAppScheduleConfig.put("org.quartz.dataSource.myDS.maxConnections", "5");
        defaultAppScheduleConfig.put("org.quartz.dataSource.myDS.validationQuery", "select 1");
        initialized = false;
        cronMapper = CronMapper.fromUnixToQuartz();
        cronParser = new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.UNIX));
    }
}

