/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.formatter.decorators;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.bitbucket.cowwoc.diffmatchpatch.DiffMatchPatch;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.feed.Thread;
import org.openmetadata.schema.tests.TestCase;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.ThreadType;
import org.openmetadata.service.Entity;
import org.openmetadata.service.events.subscription.AlertUtil;
import org.openmetadata.service.events.subscription.AlertsRuleEvaluator;
import org.openmetadata.service.exception.UnhandledServerException;
import org.openmetadata.service.formatter.decorators.OutgoingMessage;
import org.openmetadata.service.formatter.entity.IngestionPipelineFormatter;
import org.openmetadata.service.resources.feeds.MessageParser;
import org.openmetadata.service.util.FeedUtils;

public interface MessageDecorator<T> {
    public String getBold();

    public String getLineBreak();

    public String getAddMarker();

    public String getAddMarkerClose();

    public String getRemoveMarker();

    default public String httpAddMarker() {
        return "<!add>";
    }

    default public String httpRemoveMarker() {
        return "<!remove>";
    }

    public String getRemoveMarkerClose();

    public String getEntityUrl(String var1, String var2, String var3);

    public T buildEntityMessage(ChangeEvent var1);

    public T buildThreadMessage(ChangeEvent var1);

    default public String buildEntityUrl(String entityType, EntityInterface entityInterface) {
        String fqn = entityInterface.getFullyQualifiedName();
        if (CommonUtil.nullOrEmpty((String)fqn)) {
            EntityInterface result = (EntityInterface)Entity.getEntity(entityType, entityInterface.getId(), "id", Include.NON_DELETED);
            fqn = result.getFullyQualifiedName();
        }
        if (entityType.equals("testCase")) {
            TestCase testCase = (TestCase)entityInterface;
            return this.getEntityUrl("incident-manager", testCase.getFullyQualifiedName(), "test-case-results");
        }
        if (entityType.equals("glossaryTerm")) {
            return this.getEntityUrl("glossary", fqn, "");
        }
        if (entityType.equals("tag")) {
            return this.getEntityUrl("tags", fqn.split("\\.")[0], "");
        }
        if (entityType.equals("ingestionPipeline")) {
            return IngestionPipelineFormatter.getIngestionPipelineUrl(this, entityType, entityInterface);
        }
        return this.getEntityUrl(entityType, fqn, "");
    }

    default public String buildThreadUrl(ThreadType threadType, String entityType, EntityInterface entityInterface) {
        String activeTab = threadType.equals((Object)ThreadType.Task) ? "activity_feed/tasks" : "activity_feed/all";
        String fqn = entityInterface.getFullyQualifiedName();
        if (CommonUtil.nullOrEmpty((String)fqn)) {
            EntityInterface result = (EntityInterface)Entity.getEntity(entityType, entityInterface.getId(), "id", Include.NON_DELETED);
            fqn = result.getFullyQualifiedName();
        }
        if (entityType.equals("testCase")) {
            TestCase testCase = (TestCase)entityInterface;
            return this.getEntityUrl("incident-manager", testCase.getFullyQualifiedName(), "issues");
        }
        if (entityType.equals("glossaryTerm")) {
            return this.getEntityUrl("glossary", fqn, activeTab);
        }
        if (entityType.equals("tag")) {
            return this.getEntityUrl("tags", fqn.split("\\.")[0], "");
        }
        if (entityType.equals("ingestionPipeline")) {
            return IngestionPipelineFormatter.getIngestionPipelineUrl(this, entityType, entityInterface);
        }
        return this.getEntityUrl(entityType, fqn, activeTab);
    }

    default public T buildOutgoingMessage(ChangeEvent event) {
        if (event.getEntityType().equals("THREAD")) {
            return this.buildThreadMessage(event);
        }
        if (Entity.getEntityList().contains(event.getEntityType())) {
            return this.buildEntityMessage(event);
        }
        throw new IllegalArgumentException("Cannot Build Message, Unsupported Entity Type: " + event.getEntityType());
    }

    default public String getPlaintextDiff(String oldValue, String newValue) {
        oldValue = oldValue == null ? "" : oldValue;
        String addMarker = this.httpAddMarker();
        String removeMarker = this.httpRemoveMarker();
        DiffMatchPatch dmp = new DiffMatchPatch();
        LinkedList diffs = dmp.diffMain(oldValue, newValue);
        dmp.diffCleanupSemantic(diffs);
        StringBuilder outputStr = new StringBuilder();
        for (DiffMatchPatch.Diff d : diffs) {
            if (DiffMatchPatch.Operation.EQUAL.equals((Object)d.operation)) {
                outputStr.append(d.text.trim()).append(" ");
                continue;
            }
            if (DiffMatchPatch.Operation.INSERT.equals((Object)d.operation)) {
                outputStr.append(addMarker).append(d.text.trim()).append(addMarker).append(" ");
                continue;
            }
            outputStr.append(removeMarker).append(d.text.trim()).append(removeMarker).append(" ");
        }
        String diff = outputStr.toString().trim();
        diff = this.replaceMarkers(diff, addMarker, this.getAddMarker(), this.getAddMarkerClose());
        diff = this.replaceMarkers(diff, removeMarker, this.getRemoveMarker(), this.getRemoveMarkerClose());
        return diff;
    }

    default public String replaceMarkers(String diff, String marker, String openTag, String closeTag) {
        int index = 0;
        while (diff.contains(marker)) {
            String replacement = index % 2 == 0 ? openTag : closeTag;
            diff = diff.replaceFirst(marker, replacement);
            ++index;
        }
        return diff;
    }

    default public OutgoingMessage createEntityMessage(ChangeEvent event) {
        OutgoingMessage message = new OutgoingMessage();
        message.setUserName(event.getUserName());
        EntityInterface entityInterface = AlertsRuleEvaluator.getEntity(event);
        if (event.getEntity() != null) {
            String headerText;
            String eventType = event.getEntity() instanceof TestCase ? "testSuite" : event.getEntityType();
            if (eventType.equals("query")) {
                headerTxt = "%s posted on " + eventType;
                headerText = String.format(headerTxt, event.getUserName());
            } else {
                String entityUrl = this.buildEntityUrl(event.getEntityType(), entityInterface);
                message.setEntityUrl(entityUrl);
                headerTxt = "%s posted on " + eventType + " %s";
                headerText = String.format(headerTxt, event.getUserName(), entityUrl);
            }
            message.setHeader(headerText);
        }
        List<Thread> thread = FeedUtils.getThreadWithMessage(this, event);
        ArrayList<String> messages = new ArrayList<String>();
        thread.forEach(entry -> messages.add(entry.getMessage()));
        message.setMessages(messages);
        return message;
    }

    default public OutgoingMessage createThreadMessage(ChangeEvent event) {
        OutgoingMessage message = new OutgoingMessage();
        message.setUserName(event.getUserName());
        Thread thread = AlertsRuleEvaluator.getThread(event);
        MessageParser.EntityLink entityLink = MessageParser.EntityLink.parse(thread.getAbout());
        EntityInterface entityInterface = (EntityInterface)Entity.getEntity(entityLink, "", Include.ALL);
        String entityUrl = this.buildEntityUrl(entityLink.getEntityType(), entityInterface);
        String headerMessage = "";
        ArrayList<String> attachmentList = new ArrayList<String>();
        String assetUrl = this.getThreadAssetsUrl(thread.getType(), MessageParser.EntityLink.parse(thread.getAbout()));
        block0 : switch (thread.getType()) {
            case Conversation: {
                switch (event.getEventType()) {
                    case THREAD_CREATED: {
                        headerMessage = String.format("@%s started a conversation for asset %s", thread.getCreatedBy(), assetUrl);
                        attachmentList.add(MessageParser.replaceEntityLinks(thread.getMessage()));
                        break;
                    }
                    case POST_CREATED: {
                        headerMessage = String.format("@%s posted a message on asset %s", thread.getCreatedBy(), assetUrl);
                        attachmentList.add(String.format("@%s : %s", thread.getCreatedBy(), MessageParser.replaceEntityLinks(thread.getMessage())));
                        thread.getPosts().forEach(post -> attachmentList.add(String.format("@%s : %s", post.getFrom(), MessageParser.replaceEntityLinks(post.getMessage()))));
                        break;
                    }
                    case THREAD_UPDATED: {
                        headerMessage = String.format("@%s posted update on Conversation for asset %s", thread.getUpdatedBy(), assetUrl);
                        attachmentList.add(MessageParser.replaceEntityLinks(thread.getMessage()));
                    }
                }
                break;
            }
            case Task: {
                switch (event.getEventType()) {
                    case THREAD_CREATED: {
                        headerMessage = String.format("@%s created a Task for %s %s", thread.getCreatedBy(), entityLink.getEntityType(), assetUrl);
                        attachmentList.add(String.format("Task Type : %s", thread.getTask().getType().value()));
                        attachmentList.add(String.format("Assignees : %s", AlertUtil.convertInputListToString(thread.getTask().getAssignees().stream().map(assignee -> String.format("@%s", assignee.getName())).toList())));
                        attachmentList.add(String.format("Current Status : %s", thread.getTask().getStatus()));
                        break;
                    }
                    case POST_CREATED: {
                        headerMessage = String.format("@%s posted a message on the Task with Id : %s for Asset %s", thread.getCreatedBy(), thread.getTask().getId(), assetUrl);
                        thread.getPosts().forEach(post -> attachmentList.add(String.format("@%s : %s", post.getFrom(), MessageParser.replaceEntityLinks(post.getMessage()))));
                        break;
                    }
                    case THREAD_UPDATED: {
                        headerMessage = String.format("@%s posted update on the Task with Id : %s for Asset %s", thread.getUpdatedBy(), thread.getTask().getId(), assetUrl);
                        attachmentList.add(String.format("Task Type : %s", thread.getTask().getType().value()));
                        attachmentList.add(String.format("Assignees : %s", AlertUtil.convertInputListToString(thread.getTask().getAssignees().stream().map(assignee -> String.format("@%s", assignee.getName())).toList())));
                        attachmentList.add(String.format("Current Status : %s", thread.getTask().getStatus()));
                        break;
                    }
                    case TASK_CLOSED: {
                        headerMessage = String.format("@%s closed Task with Id : %s for Asset %s", thread.getCreatedBy(), thread.getTask().getId(), assetUrl);
                        attachmentList.add(String.format("Current Status : %s", thread.getTask().getStatus()));
                        break;
                    }
                    case TASK_RESOLVED: {
                        headerMessage = String.format("@%s resolved Task with Id : %s for Asset %s", thread.getCreatedBy(), thread.getTask().getId(), assetUrl);
                        attachmentList.add(String.format("Current Status : %s", thread.getTask().getStatus()));
                    }
                }
                break;
            }
            case Announcement: {
                switch (event.getEventType()) {
                    case THREAD_CREATED: {
                        headerMessage = String.format("**@%s** posted an **Announcement**", thread.getCreatedBy());
                        attachmentList.add(String.format("Description : %s", thread.getAnnouncement().getDescription()));
                        attachmentList.add(String.format("Started At : %s", MessageDecorator.getDateString(thread.getAnnouncement().getStartTime())));
                        attachmentList.add(String.format("Ends At : %s", MessageDecorator.getDateString(thread.getAnnouncement().getEndTime())));
                        break block0;
                    }
                    case POST_CREATED: {
                        headerMessage = String.format("**@%s** posted a message on **Announcement**", thread.getCreatedBy());
                        thread.getPosts().forEach(post -> attachmentList.add(String.format("@%s : %s", post.getFrom(), MessageParser.replaceEntityLinks(post.getMessage()))));
                        break block0;
                    }
                    case THREAD_UPDATED: {
                        headerMessage = String.format("**@%s** posted an update on  **Announcement**", thread.getUpdatedBy());
                        attachmentList.add(String.format("Description : %s", thread.getAnnouncement().getDescription()));
                        attachmentList.add(String.format("Started At : %s", MessageDecorator.getDateString(thread.getAnnouncement().getStartTime())));
                        attachmentList.add(String.format("Ends At : %s", MessageDecorator.getDateString(thread.getAnnouncement().getEndTime())));
                    }
                }
            }
        }
        if (CommonUtil.nullOrEmpty((String)headerMessage) || attachmentList.isEmpty()) {
            throw new UnhandledServerException("Unable to build Slack Message");
        }
        message.setHeader(headerMessage);
        message.setMessages(attachmentList);
        message.setEntityUrl(entityUrl);
        return message;
    }

    default public String getThreadAssetsUrl(ThreadType threadType, MessageParser.EntityLink aboutEntityLink) {
        try {
            return this.buildThreadUrl(threadType, aboutEntityLink.getEntityType(), (EntityInterface)Entity.getEntity(aboutEntityLink, "id", Include.ALL));
        }
        catch (Exception ex) {
            return "";
        }
    }

    public static String getDateString(long epochTimestamp) {
        Instant instant = Instant.ofEpochSecond(epochTimestamp);
        return MessageDecorator.getDateString(instant);
    }

    public static String getDateStringEpochMilli(long epochTimestamp) {
        Instant instant = Instant.ofEpochMilli(epochTimestamp);
        return MessageDecorator.getDateString(instant);
    }

    private static String getDateString(Instant instant) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return localDateTime.format(formatter);
    }
}

