/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.formatter.field;

import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.entity.feed.FeedInfo;
import org.openmetadata.schema.entity.feed.OwnerFeedInfo;
import org.openmetadata.schema.entity.feed.Thread;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.FieldChange;
import org.openmetadata.service.formatter.decorators.MessageDecorator;
import org.openmetadata.service.formatter.field.DefaultFieldFormatter;
import org.openmetadata.service.util.JsonUtils;

public class OwnerFormatter
extends DefaultFieldFormatter {
    private static final String HEADER_MESSAGE = "%s %s the owner for %s %s";

    public OwnerFormatter(MessageDecorator<?> messageDecorator, Thread thread, FieldChange fieldChange) {
        super(messageDecorator, thread, fieldChange);
    }

    @Override
    public String formatAddedField() {
        String message = super.formatAddedField();
        this.populateOwnerFeedInfo(Thread.FieldOperation.ADDED, message);
        return message;
    }

    @Override
    public String formatUpdatedField() {
        Object diff = this.getMessageDecorator().httpRemoveMarker() + this.getFieldOldValue() + this.getMessageDecorator().httpRemoveMarker() + " changed to " + this.getMessageDecorator().httpAddMarker() + this.getFieldNewValue() + this.getMessageDecorator().httpAddMarker();
        diff = this.getMessageDecorator().replaceMarkers((String)diff, this.getMessageDecorator().httpAddMarker(), this.getMessageDecorator().getAddMarker(), this.getMessageDecorator().getAddMarkerClose());
        diff = this.getMessageDecorator().replaceMarkers((String)diff, this.getMessageDecorator().httpRemoveMarker(), this.getMessageDecorator().getRemoveMarker(), this.getMessageDecorator().getRemoveMarkerClose());
        if (!CommonUtil.nullOrEmpty((String)diff)) {
            String field = String.format("Updated %s: %s", this.getMessageDecorator().getBold(), diff);
            diff = String.format(field, this.getFieldChangeName());
        }
        this.populateOwnerFeedInfo(Thread.FieldOperation.UPDATED, (String)diff);
        return diff;
    }

    @Override
    public String formatDeletedField() {
        String message = super.formatDeletedField();
        this.populateOwnerFeedInfo(Thread.FieldOperation.DELETED, message);
        return message;
    }

    private void populateOwnerFeedInfo(Thread.FieldOperation operation, String threadMessage) {
        OwnerFeedInfo ownerFeedInfo = new OwnerFeedInfo().withPreviousOwner(JsonUtils.readOrConvertValue(this.fieldChange.getOldValue(), EntityReference.class)).withUpdatedOwner(JsonUtils.readOrConvertValue(this.fieldChange.getNewValue(), EntityReference.class));
        FeedInfo feedInfo = new FeedInfo().withHeaderMessage(this.getHeaderForOwnerUpdate(operation.value())).withFieldName("owner").withEntitySpecificInfo((Object)ownerFeedInfo);
        OwnerFormatter.populateThreadFeedInfo(this.thread, threadMessage, Thread.CardStyle.OWNER, operation, feedInfo);
    }

    private String getHeaderForOwnerUpdate(String eventTypeMessage) {
        return String.format(HEADER_MESSAGE, this.thread.getUpdatedBy(), eventTypeMessage, this.thread.getEntityType(), this.thread.getEntityUrlLink());
    }
}

